/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

public class HashCodeUtils {
    private static final int prime = 31;
    private static final int seed = 17;

    public static int hash(int hash, boolean item) {
        return hash * 31 + (item ? 1 : 0);
    }

    public static int hash(int hash, char item) {
        return hash * 31 + item;
    }

    public static int hash(int hash, int item) {
        return hash * 31 + item;
    }

    public static int hash(int hash, long item) {
        return hash * 31 + (int)(item ^ item >>> 32);
    }

    public static int hash(int hash, float item) {
        return hash * 31 + Float.floatToIntBits(item);
    }

    public static int hash(int hash, double item) {
        long l = Double.doubleToLongBits(item);
        return 527 + (int)(l ^ l >>> 32);
    }

    public static int hash(int hash, Object item) {
        if (item == null) {
            return hash * 31;
        }
        return hash * 31 + item.hashCode();
    }

    public static int hash(boolean item) {
        return item ? 1 : 0;
    }

    public static int hash(char item) {
        return item;
    }

    public static int hash(int item) {
        return item;
    }

    public static int hash(long item) {
        return (int)(item ^ item >>> 32);
    }

    public static int hash(float item) {
        return Float.floatToIntBits(item);
    }

    public static int hash(double item) {
        long l = Double.doubleToLongBits(item);
        return (int)(l ^ l >>> 32);
    }

    public static int hash(Object item) {
        if (item == null) {
            return 0;
        }
        return item.hashCode();
    }

    public static int hash(Object ... items) {
        int result = 17;
        for (Object item : items) {
            result = result * 31 + (item == null ? 0 : item.hashCode());
        }
        return result;
    }
}

