/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Optional;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class OptionalCodec
implements ObjectCodec<Optional<?>> {
    OptionalCodec() {
    }

    @Override
    public Class<Optional<?>> getEncodedClass() {
        return Optional.class;
    }

    @Override
    public void serialize(SerializationContext context, Optional<?> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeBoolNoTag(obj.isPresent());
        if (obj.isPresent()) {
            context.serialize(obj.get(), codedOut);
        }
    }

    @Override
    public Optional<?> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        if (!codedIn.readBool()) {
            return Optional.absent();
        }
        return Optional.of(context.deserialize(codedIn));
    }
}

