/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessResult;

class ProcessResultImpl
implements ProcessResult {
    private final String mCommand;
    private final int mExitValue;
    private final Exception mFailure;

    ProcessResultImpl(String command, int exitValue) {
        this(command, exitValue, null);
    }

    ProcessResultImpl(String command, Exception failure) {
        this(command, -1, failure);
    }

    ProcessResultImpl(String command, int exitValue, Exception failure) {
        this.mCommand = command;
        this.mExitValue = exitValue;
        this.mFailure = failure;
    }

    @Override
    public ProcessResult assertNormalExitValue() throws ProcessException {
        if (this.mExitValue != 0) {
            throw new ProcessException(String.format("Return code %d for process '%s'", this.mExitValue, this.mCommand));
        }
        return this;
    }

    @Override
    public int getExitValue() {
        return this.mExitValue;
    }

    @Override
    public ProcessResult rethrowFailure() throws ProcessException {
        if (this.mFailure != null) {
            throw new ProcessException("", this.mFailure);
        }
        return this;
    }
}

