/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Retention;
import javax.annotation.Nullable;

@BugPattern(name="InjectScopeOrQualifierAnnotationRetention", summary="Scoping and qualifier annotations must have runtime retention.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ScopeOrQualifierAnnotationRetention
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String RETENTION_ANNOTATION = "java.lang.annotation.Retention";
    private static final Matcher<ClassTree> SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation((String)"javax.inject.Scope"), Matchers.hasAnnotation((String)"com.google.inject.BindingAnnotation"), Matchers.hasAnnotation((String)"javax.inject.Qualifier")})});

    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER.matches((Tree)classTree, state)) {
            Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
            if (ElementPredicates.hasSourceRetention(classSymbol)) {
                return this.describe(classTree, state, (Retention)ASTHelpers.getAnnotation((Symbol)classSymbol, Retention.class));
            }
            if (!state.isAndroidCompatible() && ElementPredicates.doesNotHaveRuntimeRetention(classSymbol)) {
                ClassTree outer = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
                if (outer != null && InjectMatchers.IS_DAGGER_COMPONENT_OR_MODULE.matches((Tree)outer, state)) {
                    return Description.NO_MATCH;
                }
                return this.describe(classTree, state, (Retention)ASTHelpers.getAnnotation((Symbol)classSymbol, Retention.class));
            }
        }
        return Description.NO_MATCH;
    }

    private Description describe(ClassTree classTree, VisitorState state, @Nullable Retention retention) {
        if (retention == null) {
            return this.describeMatch(classTree, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").prefixWith((Tree)classTree, "@Retention(RUNTIME)\n").build());
        }
        AnnotationTree retentionNode = null;
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol((Tree)annotationTree).equals(state.getSymbolFromString(RETENTION_ANNOTATION))) continue;
            retentionNode = annotationTree;
        }
        return this.describeMatch(retentionNode, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").replace(retentionNode, "@Retention(RUNTIME)").build());
    }
}

