/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.util.concurrent.AtomicLongMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class AtomicLongMapSubject
extends Subject<AtomicLongMapSubject, AtomicLongMap<?>> {
    private final AtomicLongMap<?> actual;

    AtomicLongMapSubject(FailureMetadata metadata, @NullableDecl AtomicLongMap<?> map) {
        super(metadata, map);
        this.actual = map;
    }

    @Override
    @Deprecated
    public void isEqualTo(@NullableDecl Object other) {
        super.isEqualTo(other);
    }

    @Override
    @Deprecated
    public void isNotEqualTo(@NullableDecl Object other) {
        super.isNotEqualTo(other);
    }

    public void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public void hasSum(long expectedSum) {
        this.check("sum()", new Object[0]).that(this.actual.sum()).isEqualTo(expectedSum);
    }

    public void containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        this.check("asMap().keySet()", new Object[0]).that(this.actual.asMap().keySet()).contains(key);
    }

    public void doesNotContainKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        this.check("asMap().keySet()", new Object[0]).that(this.actual.asMap().keySet()).doesNotContain(key);
    }

    public void containsEntry(Object key, long value) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        long actualValue = this.actual.get(key);
        if (actualValue != value) {
            this.failWithActual("expected to contain entry", Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public void doesNotContainEntry(Object key, long value) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        long actualValue = this.actual.get(key);
        if (actualValue == value) {
            this.failWithActual("expected not to contain entry", Maps.immutableEntry((Object)key, (Object)value));
        }
    }
}

