/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Preconditions;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.Unifier;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;

public abstract class TemplateMatch {
    private final JCTree location;
    private final Unifier unifier;

    public TemplateMatch(JCTree location, Unifier unifier) {
        this.location = (JCTree)Preconditions.checkNotNull((Object)location);
        this.unifier = (Unifier)Preconditions.checkNotNull((Object)unifier);
    }

    public JCTree getLocation() {
        return this.location;
    }

    public Unifier getUnifier() {
        return this.unifier;
    }

    public Inliner createInliner() {
        return this.unifier.createInliner();
    }

    public String getRange(JCTree.JCCompilationUnit unit) {
        try {
            CharSequence sequence = unit.getSourceFile().getCharContent(true);
            return sequence.subSequence(this.location.getStartPosition(), this.location.getEndPosition(unit.endPositions)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

