/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.Modifier;

@BugPattern(name="MethodCanBeStatic", altNames={"static-method"}, summary="A private method that does not reference the enclosing instance can be static", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class MethodCanBeStatic
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (sym.isStatic() || sym.isConstructor() || sym.getModifiers().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (!sym.isPrivate()) {
            return Description.NO_MATCH;
        }
        switch (sym.owner.enclClass().getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!sym.owner.enclClass().hasOuterInstance()) break;
                return Description.NO_MATCH;
            }
            case LOCAL: 
            case ANONYMOUS: {
                return Description.NO_MATCH;
            }
        }
        if (CanBeStaticAnalyzer.referencesOuter(tree, sym, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)sym.owner.enclClass().type, (Type)state.getSymtab().serializableType, (VisitorState)state)) {
            switch (((Name)sym.getSimpleName()).toString()) {
                case "readObject": {
                    if (((List)sym.getParameters()).size() != 1 || !ASTHelpers.isSameType((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)sym.getParameters())).type, (Type)state.getTypeFromString("java.io.ObjectInputStream"), (VisitorState)state)) break;
                    return Description.NO_MATCH;
                }
                case "writeObject": {
                    if (((List)sym.getParameters()).size() != 1 || !ASTHelpers.isSameType((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)sym.getParameters())).type, (Type)state.getTypeFromString("java.io.ObjectOutputStream"), (VisitorState)state)) break;
                    return Description.NO_MATCH;
                }
                case "readObjectNoData": 
                case "readResolve": 
                case "writeReplace": {
                    if (((List)sym.getParameters()).size() != 0) break;
                    return Description.NO_MATCH;
                }
            }
        }
        return this.describeMatch(tree.getModifiers(), SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).map(f -> this.fixQualifiers(state, sym, (SuggestedFix)f)));
    }

    private SuggestedFix fixQualifiers(VisitorState state, final Symbol.MethodSymbol sym, SuggestedFix f) {
        final SuggestedFix.Builder builder = SuggestedFix.builder().merge(f);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.fixQualifier(tree, tree.getExpression());
                return (Void)super.visitMemberSelect(tree, unused);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                this.fixQualifier(tree, tree.getQualifierExpression());
                return (Void)super.visitMemberReference(tree, unused);
            }

            private void fixQualifier(Tree tree, ExpressionTree qualifierExpression) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    builder.replace((Tree)qualifierExpression, sym.owner.enclClass().getSimpleName().toString());
                }
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return builder.build();
    }
}

