/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ErrorProneScanner;
import com.google.errorprone.scanner.ScannerSupplier;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class ScannerSupplierImpl
extends ScannerSupplier
implements Serializable {
    private final ImmutableBiMap<String, BugCheckerInfo> checks;
    private final ImmutableMap<String, BugPattern.SeverityLevel> severities;
    private final ImmutableSet<String> disabled;
    private final ErrorProneFlags flags;

    ScannerSupplierImpl(ImmutableBiMap<String, BugCheckerInfo> checks, ImmutableMap<String, BugPattern.SeverityLevel> severities, ImmutableSet<String> disabled, ErrorProneFlags flags) {
        Preconditions.checkArgument((boolean)Sets.difference((Set)severities.keySet(), (Set)checks.keySet()).isEmpty(), (Object)"enabledChecks must be a subset of allChecks");
        Preconditions.checkArgument((boolean)Sets.difference(disabled, (Set)checks.keySet()).isEmpty(), (Object)"disabled must be a subset of allChecks");
        this.checks = checks;
        this.severities = severities;
        this.disabled = disabled;
        this.flags = flags;
    }

    private BugChecker instantiateChecker(BugCheckerInfo checker) {
        Optional<Constructor> flagsConstructor = Arrays.stream(checker.checkerClass().getConstructors()).filter((? super T c) -> Arrays.equals(c.getParameterTypes(), new Class[]{ErrorProneFlags.class})).findFirst();
        if (flagsConstructor.isPresent()) {
            try {
                return (BugChecker)flagsConstructor.get().newInstance(this.getFlags());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            return checker.checkerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError("Could not instantiate BugChecker.", e);
        }
    }

    public ErrorProneScanner get() {
        return new ErrorProneScanner((Iterable)this.getEnabledChecks().stream().map(this::instantiateChecker).collect(ImmutableSet.toImmutableSet()), (Map<String, BugPattern.SeverityLevel>)this.severities);
    }

    @Override
    public ImmutableBiMap<String, BugCheckerInfo> getAllChecks() {
        return this.checks;
    }

    @Override
    public ImmutableMap<String, BugPattern.SeverityLevel> severities() {
        return this.severities;
    }

    @Override
    protected ImmutableSet<String> disabled() {
        return this.disabled;
    }

    @Override
    public ImmutableSet<BugCheckerInfo> getEnabledChecks() {
        return (ImmutableSet)this.getAllChecks().values().stream().filter((? super T input) -> !this.disabled.contains((Object)input.canonicalName())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ErrorProneFlags getFlags() {
        return this.flags;
    }

    public String toString() {
        return (String)Iterables.getFirst((Iterable)this.getAllChecks().keySet(), null);
    }
}

