/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.errorprone.util.MoreAnnotations;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.dataflow.analysis.AbstractValue;

public enum Nullness implements AbstractValue<Nullness>
{
    NULLABLE("Nullable"),
    NULL("Null"),
    NONNULL("Non-null"),
    BOTTOM("Bottom");

    private final String displayName;
    private static final Predicate<String> ANNOTATION_RELEVANT_TO_NULLNESS;
    private static final Predicate<String> NULLABLE_ANNOTATION;

    private Nullness(String displayName) {
        this.displayName = displayName;
    }

    public Nullness leastUpperBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == BOTTOM) {
            return other;
        }
        if (other == BOTTOM) {
            return this;
        }
        return NULLABLE;
    }

    public Nullness greatestLowerBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == NULLABLE) {
            return other;
        }
        if (other == NULLABLE) {
            return this;
        }
        return BOTTOM;
    }

    public Nullness deducedValueWhenNotEqual() {
        switch (this) {
            case NULLABLE: {
                return NULLABLE;
            }
            case NONNULL: {
                return NULLABLE;
            }
            case NULL: {
                return NONNULL;
            }
            case BOTTOM: {
                return BOTTOM;
            }
        }
        throw new AssertionError((Object)("Inverse of " + (Object)((Object)this) + " not defined"));
    }

    private static Optional<Nullness> fromAnnotationStream(Stream<String> annotations) {
        return annotations.filter(ANNOTATION_RELEVANT_TO_NULLNESS).map(annot -> NULLABLE_ANNOTATION.test((String)annot) ? NULLABLE : NONNULL).reduce(Nullness::greatestLowerBound);
    }

    public static Optional<Nullness> fromAnnotations(Collection<String> annotations) {
        return Nullness.fromAnnotationStream(annotations.stream());
    }

    public static Optional<Nullness> fromAnnotationsOn(Symbol sym) {
        return Nullness.fromAnnotationStream(MoreAnnotations.getDeclarationAndTypeAttributes(sym).map(Object::toString));
    }

    public String toString() {
        return this.displayName;
    }

    static {
        ANNOTATION_RELEVANT_TO_NULLNESS = Pattern.compile(".*\\.(Nullable(Decl)?|NotNull|Nonnull|NonNull)$").asPredicate();
        NULLABLE_ANNOTATION = Pattern.compile(".*\\.Nullable(Decl)?$").asPredicate();
    }
}

