/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import java.util.List;

public class NextStatement<T extends StatementTree>
implements Matcher<T> {
    private Matcher<StatementTree> matcher;

    public NextStatement(Matcher<StatementTree> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T statement, VisitorState state) {
        List<? extends StatementTree> blockStatements = ((BlockTree)state.findEnclosing(BlockTree.class)).getStatements();
        int statementIndex = blockStatements.indexOf(statement);
        if (statementIndex == -1) {
            return false;
        }
        StatementTree nextStmt = null;
        if (++statementIndex < blockStatements.size()) {
            nextStmt = blockStatements.get(statementIndex);
        }
        return this.matcher.matches(nextStmt, state);
    }
}

