/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.client.PortFileInaccessibleException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.concurrent.Semaphore;

public class PortFile {
    private static final int magicNr = 4468;
    private String filename;
    private File file;
    private File stopFile;
    private RandomAccessFile rwfile;
    private FileChannel channel;
    private FileLock lock;
    private Semaphore lockSem = new Semaphore(1);
    private boolean containsPortInfo;
    private int serverPort;
    private long serverCookie;
    private int myServerPort;
    private long myServerCookie;

    public PortFile(String fn) {
        this.filename = fn;
        this.file = new File(this.filename);
        this.stopFile = new File(this.filename + ".stop");
        this.containsPortInfo = false;
        this.lock = null;
    }

    private void initializeChannel() throws PortFileInaccessibleException {
        try {
            this.rwfile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new PortFileInaccessibleException(e);
        }
        this.channel = this.rwfile.getChannel();
    }

    public void lock() throws IOException, InterruptedException {
        if (this.channel == null) {
            this.initializeChannel();
        }
        this.lockSem.acquire();
        this.lock = this.channel.lock();
    }

    public void getValues() {
        this.containsPortInfo = false;
        if (this.lock == null) {
            return;
        }
        try {
            if (this.rwfile.length() > 0L) {
                this.rwfile.seek(0L);
                int nr = this.rwfile.readInt();
                this.serverPort = this.rwfile.readInt();
                this.serverCookie = this.rwfile.readLong();
                this.containsPortInfo = nr == 4468;
            }
        }
        catch (IOException e) {
            this.containsPortInfo = false;
        }
    }

    public boolean containsPortInfo() {
        return this.containsPortInfo;
    }

    public int getPort() {
        Assert.check(this.containsPortInfo);
        return this.serverPort;
    }

    public long getCookie() {
        Assert.check(this.containsPortInfo);
        return this.serverCookie;
    }

    public void setValues(int port, long cookie) throws IOException {
        Assert.check(this.lock != null);
        this.rwfile.seek(0L);
        this.rwfile.writeInt(4468);
        this.rwfile.writeInt(port);
        this.rwfile.writeLong(cookie);
        this.myServerPort = port;
        this.myServerCookie = cookie;
    }

    public void delete() throws IOException, InterruptedException {
        this.rwfile.close();
        this.file.delete();
        for (int i = 0; i < 10 && this.file.exists(); ++i) {
            Thread.sleep(1000L);
        }
        if (this.file.exists()) {
            throw new IOException("Failed to delete file.");
        }
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean markedForStop() throws IOException {
        if (this.stopFile.exists()) {
            try {
                this.stopFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void unlock() throws IOException {
        if (this.lock == null) {
            return;
        }
        this.lock.release();
        this.lock = null;
        this.lockSem.release();
    }

    public void waitForValidValues() throws IOException, InterruptedException {
        int MS_BETWEEN_ATTEMPTS = 500;
        long startTime = System.currentTimeMillis();
        long timeout = startTime + this.getServerStartupTimeoutSeconds() * 1000L;
        while (true) {
            Log.debug("Looking for valid port file values...");
            if (this.exists()) {
                this.lock();
                this.getValues();
                this.unlock();
            }
            if (this.containsPortInfo) {
                Log.debug("Valid port file values found after " + (System.currentTimeMillis() - startTime) + " ms");
                return;
            }
            if (System.currentTimeMillis() > timeout) break;
            Thread.sleep(500L);
        }
        throw new IOException("No port file values materialized. Giving up after " + (System.currentTimeMillis() - startTime) + " ms");
    }

    /*
     * Loose catch block
     */
    public boolean stillMyValues() throws IOException, FileNotFoundException, InterruptedException {
        while (true) {
            try {
                this.lock();
                this.getValues();
                this.unlock();
                if (this.containsPortInfo) {
                    return this.serverPort == this.myServerPort && this.serverCookie == this.myServerCookie;
                }
                return false;
            }
            catch (FileLockInterruptionException e) {
                continue;
            }
            break;
        }
        catch (ClosedChannelException e) {
            return false;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    private long getServerStartupTimeoutSeconds() {
        String str = System.getProperty("serverStartupTimeout");
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 60L;
    }
}

