/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.CompileProperties;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CleanProperties
implements Transformer {
    @Override
    public void setExtra(String e) {
    }

    @Override
    public void setExtra(Options a) {
    }

    @Override
    public boolean transform(CompilationService sjavac, Map<String, Set<URI>> pkgSrcs, Set<URI> visibleSrcs, Map<String, Set<String>> oldPackageDependencies, URI destRoot, Map<String, Set<URI>> packageArtifacts, Map<String, Map<String, Set<String>>> packageDependencies, Map<String, Map<String, Set<String>>> packageCpDependencies, Map<String, PubApi> packagePublicApis, Map<String, PubApi> dependencyPublicApis, int debugLevel, boolean incremental, int numCores) {
        boolean rc = true;
        for (String pkgName : pkgSrcs.keySet()) {
            String pkgNameF = pkgName.replace('.', File.separatorChar);
            for (URI u : pkgSrcs.get(pkgName)) {
                File src = new File(u);
                boolean r = this.clean(pkgName, pkgNameF, src, new File(destRoot), debugLevel, packageArtifacts);
                if (r) continue;
                rc = false;
            }
        }
        return rc;
    }

    boolean clean(String pkgName, String pkgNameF, File src, File destRoot, int debugLevel, Map<String, Set<URI>> packageArtifacts) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(src));
        }
        catch (IOException e) {
            Log.error("Error reading file " + src.getPath());
            return false;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Object object : p.keySet()) {
            sortedKeys.add((String)object);
        }
        Collections.sort(sortedKeys);
        StringBuilder data = new StringBuilder();
        for (String key : sortedKeys) {
            data.append(CompileProperties.escape(key)).append(":").append(CompileProperties.escape((String)p.get(key))).append("\n");
        }
        String string = destRoot.getPath() + File.separator + pkgNameF + File.separator + src.getName();
        File dest = new File(string);
        if (!dest.getParentFile().isDirectory() && !dest.getParentFile().mkdirs()) {
            Log.error("Could not create the directory " + dest.getParentFile().getPath());
            return false;
        }
        Set<URI> as = packageArtifacts.get(pkgName);
        if (as == null) {
            as = new HashSet<URI>();
            packageArtifacts.put(pkgName, as);
        }
        as.add(dest.toURI());
        if (dest.exists() && dest.lastModified() > src.lastModified()) {
            return true;
        }
        Log.info("Cleaning property file " + pkgNameF + File.separator + src.getName());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));){
            writer.write(data.toString());
        }
        catch (IOException e) {
            Log.error("Could not write file " + dest.getPath());
            return false;
        }
        return true;
    }
}

