/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;

public interface TypeBoundClass
extends HeaderBoundClass {
    public Type.ClassTy superClassType();

    public ImmutableList<Type.ClassTy> interfaceTypes();

    public ImmutableMap<TyVarSymbol, TyVarInfo> typeParameterTypes();

    public ImmutableList<FieldInfo> fields();

    public ImmutableList<MethodInfo> methods();

    public AnnotationMetadata annotationMetadata();

    public ImmutableList<AnnoInfo> annotations();

    public static class ParamInfo {
        private final Type type;
        private final String name;
        private final int access;
        private final ImmutableList<AnnoInfo> annotations;

        public ParamInfo(Type type, String name, ImmutableList<AnnoInfo> annotations, int access) {
            this.type = type;
            this.name = name;
            this.access = access;
            this.annotations = annotations;
        }

        public Type type() {
            return this.type;
        }

        public boolean synthetic() {
            return (this.access & 0x9000) != 0;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        public String name() {
            return this.name;
        }

        public int access() {
            return this.access;
        }
    }

    public static class MethodInfo {
        private final MethodSymbol sym;
        private final ImmutableMap<TyVarSymbol, TyVarInfo> tyParams;
        private final Type returnType;
        private final ImmutableList<ParamInfo> parameters;
        private final ImmutableList<Type> exceptions;
        private final int access;
        private final Const defaultValue;
        private final Tree.MethDecl decl;
        private final ImmutableList<AnnoInfo> annotations;
        private final ParamInfo receiver;

        public MethodInfo(MethodSymbol sym, ImmutableMap<TyVarSymbol, TyVarInfo> tyParams, Type returnType, ImmutableList<ParamInfo> parameters, ImmutableList<Type> exceptions, int access, Const defaultValue, Tree.MethDecl decl, ImmutableList<AnnoInfo> annotations, ParamInfo receiver) {
            this.sym = sym;
            this.tyParams = tyParams;
            this.returnType = returnType;
            this.parameters = parameters;
            this.exceptions = exceptions;
            this.access = access;
            this.defaultValue = defaultValue;
            this.decl = decl;
            this.annotations = annotations;
            this.receiver = receiver;
        }

        public MethodSymbol sym() {
            return this.sym;
        }

        public String name() {
            return this.sym.name();
        }

        public ImmutableMap<TyVarSymbol, TyVarInfo> tyParams() {
            return this.tyParams;
        }

        public Type returnType() {
            return this.returnType;
        }

        public ImmutableList<ParamInfo> parameters() {
            return this.parameters;
        }

        public ImmutableList<Type> exceptions() {
            return this.exceptions;
        }

        public int access() {
            return this.access;
        }

        public Const defaultValue() {
            return this.defaultValue;
        }

        public Tree.MethDecl decl() {
            return this.decl;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        public ParamInfo receiver() {
            return this.receiver;
        }
    }

    public static class FieldInfo {
        private final FieldSymbol sym;
        private final Type type;
        private final int access;
        private final ImmutableList<AnnoInfo> annotations;
        private final Tree.VarDecl decl;
        private final Const.Value value;

        public FieldInfo(FieldSymbol sym, Type type, int access, ImmutableList<AnnoInfo> annotations, Tree.VarDecl decl, Const.Value value) {
            this.sym = sym;
            this.type = type;
            this.access = access;
            this.annotations = annotations;
            this.decl = decl;
            this.value = value;
        }

        public FieldSymbol sym() {
            return this.sym;
        }

        public String name() {
            return this.sym.name();
        }

        public Type type() {
            return this.type;
        }

        public int access() {
            return this.access;
        }

        public Tree.VarDecl decl() {
            return this.decl;
        }

        public Const.Value value() {
            return this.value;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }

    public static class TyVarInfo {
        private final Type superClassBound;
        private final ImmutableList<Type> interfaceBounds;
        private final ImmutableList<AnnoInfo> annotations;

        public TyVarInfo(Type superClassBound, ImmutableList<Type> interfaceBounds, ImmutableList<AnnoInfo> annotations) {
            this.superClassBound = superClassBound;
            this.interfaceBounds = interfaceBounds;
            this.annotations = annotations;
        }

        public Type superClassBound() {
            return this.superClassBound;
        }

        public ImmutableList<Type> interfaceBounds() {
            return this.interfaceBounds;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }
}

