/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.SubContext;
import com.google.errorprone.refaster.AutoValue_RefasterRule;
import com.google.errorprone.refaster.RefasterScanner;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.TemplateMatch;
import com.google.errorprone.refaster.UTypeVar;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.tools.JavaFileManager;

@AutoValue
public abstract class RefasterRule<M extends TemplateMatch, T extends Template<M>>
implements CodeTransformer,
Serializable {
    static final Context.Key<ImmutableList<UTypeVar>> RULE_TYPE_VARS = new Context.Key();

    public static RefasterRule<?, ?> create(String qualifiedTemplateClass, Collection<? extends Template<?>> beforeTemplates, Collection<? extends Template<?>> afterTemplates) {
        return RefasterRule.create(qualifiedTemplateClass, (Iterable<UTypeVar>)ImmutableList.of(), beforeTemplates, afterTemplates, (ImmutableClassToInstanceMap<Annotation>)ImmutableClassToInstanceMap.builder().build());
    }

    public static RefasterRule<?, ?> create(String qualifiedTemplateClass, Iterable<UTypeVar> typeVariables, Collection<? extends Template<?>> beforeTemplates, Collection<? extends Template<?>> afterTemplates, ImmutableClassToInstanceMap<Annotation> annotations) {
        Preconditions.checkState((!beforeTemplates.isEmpty() ? 1 : 0) != 0, (String)"No @BeforeTemplate was found in the specified class: %s", (Object)qualifiedTemplateClass);
        Class<?> templateType = beforeTemplates.iterator().next().getClass();
        for (Template<?> beforeTemplate : beforeTemplates) {
            Preconditions.checkState((boolean)beforeTemplate.getClass().equals(templateType), (String)"Expected all templates to be of type %s but found template of type %s in %s", templateType, beforeTemplate.getClass(), (Object)qualifiedTemplateClass);
        }
        for (Template<?> afterTemplate : afterTemplates) {
            Preconditions.checkState((boolean)afterTemplate.getClass().equals(templateType), (String)"Expected all templates to be of type %s but found template of type %s in %s", templateType, afterTemplate.getClass(), (Object)qualifiedTemplateClass);
        }
        AutoValue_RefasterRule result = new AutoValue_RefasterRule(qualifiedTemplateClass, (ImmutableList<UTypeVar>)ImmutableList.copyOf(typeVariables), ImmutableList.copyOf(beforeTemplates), ImmutableList.copyOf(afterTemplates), annotations);
        return result;
    }

    RefasterRule() {
    }

    abstract String qualifiedTemplateClass();

    abstract ImmutableList<UTypeVar> typeVariables();

    abstract ImmutableList<T> beforeTemplates();

    @Nullable
    abstract ImmutableList<T> afterTemplates();

    public abstract ImmutableClassToInstanceMap<Annotation> annotations();

    public void apply(TreePath path, Context context, DescriptionListener listener) {
        RefasterScanner.create(this, listener).scan(path, this.prepareContext(context, (JCTree.JCCompilationUnit)path.getCompilationUnit()));
    }

    boolean rejectMatchesWithComments() {
        return true;
    }

    private Context prepareContext(Context baseContext, JCTree.JCCompilationUnit compilationUnit) {
        SubContext context = new SubContext(baseContext);
        if (context.get(JavaFileManager.class) == null) {
            JavacFileManager.preRegister((Context)context);
        }
        context.put(JCTree.JCCompilationUnit.class, compilationUnit);
        context.put(Symbol.PackageSymbol.class, compilationUnit.packge);
        context.put(RULE_TYPE_VARS, this.typeVariables());
        return context;
    }

    @VisibleForTesting
    static String fromSecondLevel(String qualifiedTemplateClass) {
        List path = Splitter.on((char)'.').splitToList((CharSequence)qualifiedTemplateClass);
        for (int topLevel = 0; topLevel < path.size() - 1; ++topLevel) {
            if (!Ascii.isUpperCase((char)((String)path.get(topLevel)).charAt(0))) continue;
            return Joiner.on((char)'_').join(path.subList(topLevel + 1, path.size()));
        }
        return (String)Iterables.getLast((Iterable)path);
    }

    public String toString() {
        return RefasterRule.fromSecondLevel(this.qualifiedTemplateClass());
    }
}

