/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.model.Const;
import java.util.List;

interface Attribute {
    public static final Attribute DEPRECATED = new Attribute(){

        @Override
        public Kind kind() {
            return Kind.DEPRECATED;
        }
    };

    public Kind kind();

    public static class Module
    implements Attribute {
        private final ClassFile.ModuleInfo module;

        public Module(ClassFile.ModuleInfo module) {
            this.module = module;
        }

        @Override
        public Kind kind() {
            return Kind.MODULE;
        }

        public ClassFile.ModuleInfo module() {
            return this.module;
        }
    }

    public static class MethodParameters
    implements Attribute {
        private final ImmutableList<ClassFile.MethodInfo.ParameterInfo> parameters;

        public MethodParameters(ImmutableList<ClassFile.MethodInfo.ParameterInfo> parameters) {
            this.parameters = parameters;
        }

        public ImmutableList<ClassFile.MethodInfo.ParameterInfo> parameters() {
            return this.parameters;
        }

        @Override
        public Kind kind() {
            return Kind.METHOD_PARAMETERS;
        }
    }

    public static class RuntimeVisibleTypeAnnotations
    implements TypeAnnotations {
        final ImmutableList<ClassFile.TypeAnnotationInfo> annotations;

        public RuntimeVisibleTypeAnnotations(ImmutableList<ClassFile.TypeAnnotationInfo> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_VISIBLE_TYPE_ANNOTATIONS;
        }

        @Override
        public ImmutableList<ClassFile.TypeAnnotationInfo> annotations() {
            return this.annotations;
        }
    }

    public static class RuntimeInvisibleTypeAnnotations
    implements TypeAnnotations {
        final ImmutableList<ClassFile.TypeAnnotationInfo> annotations;

        public RuntimeInvisibleTypeAnnotations(ImmutableList<ClassFile.TypeAnnotationInfo> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_INVISIBLE_TYPE_ANNOTATIONS;
        }

        @Override
        public ImmutableList<ClassFile.TypeAnnotationInfo> annotations() {
            return this.annotations;
        }
    }

    public static interface TypeAnnotations
    extends Attribute {
        public ImmutableList<ClassFile.TypeAnnotationInfo> annotations();
    }

    public static class RuntimeInvisibleParameterAnnotations
    implements ParameterAnnotations {
        final List<List<ClassFile.AnnotationInfo>> annotations;

        @Override
        public List<List<ClassFile.AnnotationInfo>> annotations() {
            return this.annotations;
        }

        public RuntimeInvisibleParameterAnnotations(List<List<ClassFile.AnnotationInfo>> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS;
        }
    }

    public static class RuntimeVisibleParameterAnnotations
    implements ParameterAnnotations {
        final List<List<ClassFile.AnnotationInfo>> annotations;

        @Override
        public List<List<ClassFile.AnnotationInfo>> annotations() {
            return this.annotations;
        }

        public RuntimeVisibleParameterAnnotations(List<List<ClassFile.AnnotationInfo>> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS;
        }
    }

    public static interface ParameterAnnotations
    extends Attribute {
        public List<List<ClassFile.AnnotationInfo>> annotations();
    }

    public static class AnnotationDefault
    implements Attribute {
        private final ClassFile.AnnotationInfo.ElementValue value;

        public AnnotationDefault(ClassFile.AnnotationInfo.ElementValue value) {
            this.value = value;
        }

        @Override
        public Kind kind() {
            return Kind.ANNOTATION_DEFAULT;
        }

        public ClassFile.AnnotationInfo.ElementValue value() {
            return this.value;
        }
    }

    public static class ConstantValue
    implements Attribute {
        final Const.Value value;

        public ConstantValue(Const.Value value) {
            this.value = value;
        }

        @Override
        public Kind kind() {
            return Kind.CONSTANT_VALUE;
        }
    }

    public static class RuntimeInvisibleAnnotations
    implements Annotations {
        List<ClassFile.AnnotationInfo> annotations;

        public RuntimeInvisibleAnnotations(List<ClassFile.AnnotationInfo> annotations) {
            this.annotations = annotations;
        }

        @Override
        public List<ClassFile.AnnotationInfo> annotations() {
            return this.annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_INVISIBLE_ANNOTATIONS;
        }
    }

    public static class RuntimeVisibleAnnotations
    implements Annotations {
        List<ClassFile.AnnotationInfo> annotations;

        public RuntimeVisibleAnnotations(List<ClassFile.AnnotationInfo> annotations) {
            this.annotations = annotations;
        }

        @Override
        public List<ClassFile.AnnotationInfo> annotations() {
            return this.annotations;
        }

        @Override
        public Kind kind() {
            return Kind.RUNTIME_VISIBLE_ANNOTATIONS;
        }
    }

    public static interface Annotations
    extends Attribute {
        public List<ClassFile.AnnotationInfo> annotations();
    }

    public static class ExceptionsAttribute
    implements Attribute {
        final List<String> exceptions;

        public ExceptionsAttribute(List<String> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public Kind kind() {
            return Kind.EXCEPTIONS;
        }
    }

    public static class Signature
    implements Attribute {
        final String signature;

        public Signature(String signature) {
            this.signature = signature;
        }

        @Override
        public Kind kind() {
            return Kind.SIGNATURE;
        }
    }

    public static class InnerClasses
    implements Attribute {
        final List<ClassFile.InnerClass> inners;

        public InnerClasses(List<ClassFile.InnerClass> inners) {
            this.inners = inners;
        }

        @Override
        public Kind kind() {
            return Kind.INNER_CLASSES;
        }
    }

    public static enum Kind {
        SIGNATURE("Signature"),
        EXCEPTIONS("Exceptions"),
        INNER_CLASSES("InnerClasses"),
        CONSTANT_VALUE("ConstantValue"),
        RUNTIME_VISIBLE_ANNOTATIONS("RuntimeVisibleAnnotations"),
        RUNTIME_INVISIBLE_ANNOTATIONS("RuntimeInvisibleAnnotations"),
        ANNOTATION_DEFAULT("AnnotationDefault"),
        RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS("RuntimeVisibleParameterAnnotations"),
        RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS("RuntimeInvisibleParameterAnnotations"),
        DEPRECATED("Deprecated"),
        RUNTIME_VISIBLE_TYPE_ANNOTATIONS("RuntimeVisibleTypeAnnotations"),
        RUNTIME_INVISIBLE_TYPE_ANNOTATIONS("RuntimeInvisibleTypeAnnotations"),
        METHOD_PARAMETERS("MethodParameters"),
        MODULE("Module");

        private final String signature;

        private Kind(String signature) {
            this.signature = signature;
        }

        public String signature() {
            return this.signature;
        }
    }
}

