/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.auto.common;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$SuperficialValidation;
import autovalue.shaded.com.google$.common.base.$Ascii;
import autovalue.shaded.com.google$.common.base.$Function;
import autovalue.shaded.com.google$.common.base.$Optional;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.common.base.$Predicates;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$ImmutableSetMultimap;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$LinkedHashMultimap;
import autovalue.shaded.com.google$.common.collect.$Multimaps;
import autovalue.shaded.com.google$.common.collect.$SetMultimap;
import autovalue.shaded.com.google$.common.collect.$Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;

public abstract class $BasicAnnotationProcessor
extends AbstractProcessor {
    private final Set<ElementName> deferredElementNames = new LinkedHashSet<ElementName>();
    private final $SetMultimap<ProcessingStep, ElementName> elementsDeferredBySteps = $LinkedHashMultimap.create();
    private Elements elements;
    private Messager messager;
    private $ImmutableList<? extends ProcessingStep> steps;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.steps = $ImmutableList.copyOf(this.initSteps());
    }

    protected abstract Iterable<? extends ProcessingStep> initSteps();

    @Deprecated
    protected void postProcess() {
    }

    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.postProcess();
        }
    }

    private $ImmutableSet<? extends Class<? extends Annotation>> getSupportedAnnotationClasses() {
        $Preconditions.checkState(this.steps != null);
        $ImmutableSet.Builder builder = $ImmutableSet.builder();
        for (ProcessingStep processingStep : this.steps) {
            builder.addAll(processingStep.annotations());
        }
        return builder.build();
    }

    public final $ImmutableSet<String> getSupportedAnnotationTypes() {
        $ImmutableSet.Builder builder = $ImmutableSet.builder();
        for (Class clazz : this.getSupportedAnnotationClasses()) {
            builder.add(clazz.getCanonicalName());
        }
        return builder.build();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        $Preconditions.checkState(this.elements != null);
        $Preconditions.checkState(this.messager != null);
        $Preconditions.checkState(this.steps != null);
        $ImmutableMap<String, $Optional<? extends Element>> deferredElements = this.deferredElements();
        this.deferredElementNames.clear();
        if (roundEnv.processingOver()) {
            this.postRound(roundEnv);
            this.reportMissingElements(deferredElements, this.elementsDeferredBySteps.values());
            return false;
        }
        this.process(this.validElements(deferredElements, roundEnv));
        this.postRound(roundEnv);
        return false;
    }

    private $ImmutableMap<String, $Optional<? extends Element>> deferredElements() {
        $ImmutableMap.Builder<String, $Optional<? extends Element>> deferredElements = $ImmutableMap.builder();
        for (ElementName elementName : this.deferredElementNames) {
            deferredElements.put(elementName.name(), elementName.getElement(this.elements));
        }
        return deferredElements.build();
    }

    private void reportMissingElements(Map<String, ? extends $Optional<? extends Element>> missingElements, Collection<ElementName> missingElementNames) {
        if (!missingElementNames.isEmpty()) {
            $ImmutableMap.Builder<String, $Optional<? extends Element>> allMissingElements = $ImmutableMap.builder();
            allMissingElements.putAll(missingElements);
            for (ElementName elementName : missingElementNames) {
                if (missingElements.containsKey(elementName.name())) continue;
                allMissingElements.put(elementName.name(), elementName.getElement(this.elements));
            }
            missingElements = allMissingElements.build();
        }
        for (Map.Entry<String, ? extends $Optional<? extends Element>> missingElementEntry : missingElements.entrySet()) {
            $Optional<? extends Element> $Optional = missingElementEntry.getValue();
            if ($Optional.isPresent()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage("this " + $Ascii.toLowerCase($Optional.get().getKind().name())), $Optional.get());
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage(missingElementEntry.getKey()));
        }
    }

    private String processingErrorMessage(String target) {
        return String.format("[%s:MiscError] %s was unable to process %s because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", this.getClass().getSimpleName(), this.getClass().getCanonicalName(), target);
    }

    private $ImmutableSetMultimap<Class<? extends Annotation>, Element> validElements($ImmutableMap<String, $Optional<? extends Element>> deferredElements, RoundEnvironment roundEnv) {
        $ImmutableSetMultimap.Builder<Class<? extends Annotation>, Element> deferredElementsByAnnotationBuilder = $ImmutableSetMultimap.builder();
        for (Map.Entry deferredTypeElementEntry : deferredElements.entrySet()) {
            $Optional deferredElement = ($Optional)deferredTypeElementEntry.getValue();
            if (deferredElement.isPresent()) {
                $BasicAnnotationProcessor.findAnnotatedElements((Element)deferredElement.get(), this.getSupportedAnnotationClasses(), deferredElementsByAnnotationBuilder);
                continue;
            }
            this.deferredElementNames.add(ElementName.forTypeName((String)deferredTypeElementEntry.getKey()));
        }
        $ImmutableMultimap deferredElementsByAnnotation = deferredElementsByAnnotationBuilder.build();
        $ImmutableSetMultimap.Builder validElements = $ImmutableSetMultimap.builder();
        LinkedHashSet<ElementName> validElementNames = new LinkedHashSet<ElementName>();
        for (Class clazz : this.getSupportedAnnotationClasses()) {
            TypeElement annotationType = this.elements.getTypeElement(clazz.getCanonicalName());
            $ImmutableSet elementsAnnotatedWith = annotationType == null ? $ImmutableSet.of() : roundEnv.getElementsAnnotatedWith(annotationType);
            for (Element annotatedElement : $Sets.union(elementsAnnotatedWith, (($ImmutableSetMultimap)deferredElementsByAnnotation).get(clazz))) {
                boolean validEnclosingType;
                if (annotatedElement.getKind().equals((Object)ElementKind.PACKAGE)) {
                    boolean validPackage;
                    PackageElement annotatedPackageElement = (PackageElement)annotatedElement;
                    ElementName annotatedPackageName = ElementName.forPackageName(annotatedPackageElement.getQualifiedName().toString());
                    boolean bl = validPackage = validElementNames.contains(annotatedPackageName) || !this.deferredElementNames.contains(annotatedPackageName) && $SuperficialValidation.validateElement(annotatedPackageElement);
                    if (validPackage) {
                        validElements.put(clazz, annotatedPackageElement);
                        validElementNames.add(annotatedPackageName);
                        continue;
                    }
                    this.deferredElementNames.add(annotatedPackageName);
                    continue;
                }
                TypeElement enclosingType = $BasicAnnotationProcessor.getEnclosingType(annotatedElement);
                ElementName enclosingTypeName = ElementName.forTypeName(enclosingType.getQualifiedName().toString());
                boolean bl = validEnclosingType = validElementNames.contains(enclosingTypeName) || !this.deferredElementNames.contains(enclosingTypeName) && $SuperficialValidation.validateElement(enclosingType);
                if (validEnclosingType) {
                    validElements.put(clazz, annotatedElement);
                    validElementNames.add(enclosingTypeName);
                    continue;
                }
                this.deferredElementNames.add(enclosingTypeName);
            }
        }
        return validElements.build();
    }

    private void process($ImmutableSetMultimap<Class<? extends Annotation>, Element> validElements) {
        for (ProcessingStep processingStep : this.steps) {
            $ImmutableMultimap stepElements = (($ImmutableSetMultimap.Builder)(($ImmutableSetMultimap.Builder)new $ImmutableSetMultimap.Builder().putAll(this.indexByAnnotation((Set<ElementName>)this.elementsDeferredBySteps.get((Object)processingStep)))).putAll($Multimaps.filterKeys(validElements, $Predicates.in(processingStep.annotations())))).build();
            if (stepElements.isEmpty()) {
                this.elementsDeferredBySteps.removeAll(processingStep);
                continue;
            }
            Set<? extends Element> rejectedElements = processingStep.process(($SetMultimap<Class<? extends Annotation>, Element>)((Object)stepElements));
            this.elementsDeferredBySteps.replaceValues((Object)processingStep, $Iterables.transform(rejectedElements, new $Function<Element, ElementName>(){

                @Override
                public ElementName apply(Element element) {
                    return ElementName.forAnnotatedElement(element);
                }
            }));
        }
    }

    private $ImmutableSetMultimap<Class<? extends Annotation>, Element> indexByAnnotation(Set<ElementName> annotatedElements) {
        $ImmutableSet<? extends Class<? extends Annotation>> supportedAnnotationClasses = this.getSupportedAnnotationClasses();
        $ImmutableSetMultimap.Builder<Class<? extends Annotation>, Element> deferredElements = $ImmutableSetMultimap.builder();
        for (ElementName elementName : annotatedElements) {
            $Optional<? extends Element> element = elementName.getElement(this.elements);
            if (!element.isPresent()) continue;
            $BasicAnnotationProcessor.findAnnotatedElements(element.get(), supportedAnnotationClasses, deferredElements);
        }
        return deferredElements.build();
    }

    private static void findAnnotatedElements(Element element, $ImmutableSet<? extends Class<? extends Annotation>> annotationClasses, $ImmutableSetMultimap.Builder<Class<? extends Annotation>, Element> annotatedElements) {
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind().isClass() || element2.getKind().isInterface()) continue;
            $BasicAnnotationProcessor.findAnnotatedElements(element2, annotationClasses, annotatedElements);
        }
        if (element instanceof ExecutableElement) {
            for (Element element3 : ((ExecutableElement)element).getParameters()) {
                $BasicAnnotationProcessor.findAnnotatedElements(element3, annotationClasses, annotatedElements);
            }
        }
        for (Class clazz : annotationClasses) {
            if (!$MoreElements.isAnnotationPresent(element, clazz)) continue;
            annotatedElements.put((Object)clazz, (Object)element);
        }
    }

    private static TypeElement getEnclosingType(Element element) {
        return element.accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                return e.getEnclosingElement().accept(this, p);
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitPackage(PackageElement e, Void p) {
                throw new IllegalArgumentException();
            }
        }, null);
    }

    private static final class ElementName {
        private final Kind kind;
        private final String name;

        private ElementName(Kind kind, String name) {
            this.kind = $Preconditions.checkNotNull(kind);
            this.name = $Preconditions.checkNotNull(name);
        }

        static ElementName forPackageName(String packageName) {
            return new ElementName(Kind.PACKAGE_NAME, packageName);
        }

        static ElementName forTypeName(String typeName) {
            return new ElementName(Kind.TYPE_NAME, typeName);
        }

        static ElementName forAnnotatedElement(Element element) {
            return element.getKind() == ElementKind.PACKAGE ? ElementName.forPackageName(((PackageElement)element).getQualifiedName().toString()) : ElementName.forTypeName($BasicAnnotationProcessor.getEnclosingType(element).getQualifiedName().toString());
        }

        String name() {
            return this.name;
        }

        $Optional<? extends Element> getElement(Elements elements) {
            return $Optional.fromNullable(this.kind == Kind.PACKAGE_NAME ? elements.getPackageElement(this.name) : elements.getTypeElement(this.name));
        }

        public boolean equals(Object object) {
            if (!(object instanceof ElementName)) {
                return false;
            }
            ElementName that = (ElementName)object;
            return this.kind == that.kind && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name});
        }

        private static enum Kind {
            PACKAGE_NAME,
            TYPE_NAME;

        }
    }

    public static interface ProcessingStep {
        public Set<? extends Class<? extends Annotation>> annotations();

        public Set<? extends Element> process($SetMultimap<Class<? extends Annotation>, Element> var1);
    }
}

