/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class SortedSetSubject
extends IterableSubject {
    private final NavigableSet<?> actualAsNavigableSet;

    SortedSetSubject(FailureMetadata metadata, SortedSet<?> set) {
        super(metadata, (Iterable<?>)set);
        this.actualAsNavigableSet = set == null ? null : SortedSetAsNavigableSet.wrapIfNecessary(set);
    }

    @Override
    public SortedSetSubject named(String format, Object ... args) {
        super.named(format, args);
        return this;
    }

    public void hasFirstElement(@NullableDecl Object element) {
        if (this.actualAsNavigableSet().isEmpty()) {
            this.fail("has first element", element);
            return;
        }
        if (!Objects.equal(this.actualAsNavigableSet().first(), (Object)element)) {
            if (this.actualAsNavigableSet().contains(element)) {
                this.failWithRawMessage("Not true that %s has first element <%s>. It does contain this element, but the first element is <%s>", this.actualAsString(), element, this.actualAsNavigableSet().first());
                return;
            }
            this.failWithRawMessage("Not true that %s has first element <%s>. It does not contain this element, and the first element is <%s>", this.actualAsString(), element, this.actualAsNavigableSet().first());
        }
    }

    public void hasLastElement(@NullableDecl Object element) {
        if (this.actualAsNavigableSet().isEmpty()) {
            this.fail("has last element", element);
            return;
        }
        if (!Objects.equal(this.actualAsNavigableSet().last(), (Object)element)) {
            if (this.actualAsNavigableSet().contains(element)) {
                this.failWithRawMessage("Not true that %s has last element <%s>. It does contain this element, but the last element is <%s>", this.actualAsString(), element, this.actualAsNavigableSet().last());
                return;
            }
            this.failWithRawMessage("Not true that %s has last element <%s>. It does not contain this element, and the last element is <%s>", this.actualAsString(), element, this.actualAsNavigableSet().last());
        }
    }

    private NavigableSet<?> actualAsNavigableSet() {
        return this.actualAsNavigableSet;
    }

    private static class SortedSetAsNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements NavigableSet<E> {
        private final SortedSet<E> delegate;

        static <E> NavigableSet<E> wrapIfNecessary(SortedSet<E> set) {
            if (set instanceof NavigableSet) {
                return (NavigableSet)set;
            }
            return new SortedSetAsNavigableSet<E>(set);
        }

        SortedSetAsNavigableSet(SortedSet<E> delegate) {
            this.delegate = (SortedSet)Preconditions.checkNotNull(delegate);
        }

        protected SortedSet<E> delegate() {
            return this.delegate;
        }

        @Override
        public E ceiling(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> descendingIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E floor(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E higher(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E lower(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            throw new UnsupportedOperationException();
        }
    }
}

