/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;

class FileManagerUtils {
    private FileManagerUtils() {
    }

    static Iterable<Path> asPaths(final Iterable<? extends File> files) {
        return () -> new Iterator<Path>(){
            Iterator iter;
            {
                this.iter = files.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return ((File)this.iter.next()).toPath();
            }
        };
    }

    static Iterable<File> asFiles(final Iterable<? extends Path> paths) {
        return () -> new Iterator<File>(){
            Iterator iter;
            {
                this.iter = paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                Path p = (Path)this.iter.next();
                try {
                    return p.toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException(p.toString(), e);
                }
            }
        };
    }
}

