/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public static final Context.Key<PrintWriter> errKey = new Context.Key();
    private final Map<WriterKind, PrintWriter> writers;
    protected int MaxErrors;
    protected int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean suppressNotes;
    public boolean dumpOnError;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    public boolean compressedOutput;
    private JavacMessages messages;
    private DiagnosticHandler diagnosticHandler;
    public int nerrors = 0;
    public int nwarnings = 0;
    protected Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    protected Set<Pair<JavaFileObject, String>> recordedSourceLevelErrors = new HashSet<Pair<JavaFileObject, String>>();
    private static boolean useRawMessages = false;

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public static void preRegister(Context context, PrintWriter w) {
        context.put(Log.class, c -> new Log(c, w));
    }

    protected Log(Context context) {
        this(context, Log.initWriters(context));
    }

    private static Map<WriterKind, PrintWriter> initWriters(Context context) {
        PrintWriter out = context.get(outKey);
        PrintWriter err = context.get(errKey);
        if (out == null && err == null) {
            out = new PrintWriter(System.out, true);
            err = new PrintWriter(System.err, true);
            return Log.initWriters(out, err);
        }
        if (out == null || err == null) {
            PrintWriter pw = out != null ? out : err;
            return Log.initWriters(pw, pw);
        }
        return Log.initWriters(out, err);
    }

    protected Log(Context context, PrintWriter writer) {
        this(context, Log.initWriters(writer, writer));
    }

    protected Log(Context context, PrintWriter out, PrintWriter err) {
        this(context, Log.initWriters(out, err));
    }

    private static Map<WriterKind, PrintWriter> initWriters(PrintWriter out, PrintWriter err) {
        EnumMap<WriterKind, PrintWriter> writers = new EnumMap<WriterKind, PrintWriter>(WriterKind.class);
        writers.put(WriterKind.ERROR, err);
        writers.put(WriterKind.WARNING, err);
        writers.put(WriterKind.NOTICE, err);
        writers.put(WriterKind.STDOUT, out);
        writers.put(WriterKind.STDERR, err);
        return writers;
    }

    @Deprecated
    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        this(context, Log.initWriters(errWriter, warnWriter, noticeWriter));
    }

    @Deprecated
    private static Map<WriterKind, PrintWriter> initWriters(PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        EnumMap<WriterKind, PrintWriter> writers = new EnumMap<WriterKind, PrintWriter>(WriterKind.class);
        writers.put(WriterKind.ERROR, errWriter);
        writers.put(WriterKind.WARNING, warnWriter);
        writers.put(WriterKind.NOTICE, noticeWriter);
        writers.put(WriterKind.STDOUT, noticeWriter);
        writers.put(WriterKind.STDERR, errWriter);
        return writers;
    }

    private Log(Context context, Map<WriterKind, PrintWriter> writers) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener dl;
        context.put(logKey, this);
        this.writers = writers;
        this.diagListener = dl = context.get(DiagnosticListener.class);
        this.diagnosticHandler = new DefaultDiagnosticHandler();
        this.messages = JavacMessages.instance(context);
        this.messages.add("com.sun.tools.javac.resources.javac");
        Options options = Options.instance(context);
        this.initOptions(options);
        options.addListener(() -> this.initOptions(options));
    }

    private void initOptions(Options options) {
        this.dumpOnError = options.isSet(Option.DOE);
        this.promptOnError = options.isSet(Option.PROMPT);
        this.emitWarnings = options.isUnset(Option.XLINT_CUSTOM, "none");
        this.suppressNotes = options.isSet("suppressNotes");
        this.MaxErrors = this.getIntOption(options, Option.XMAXERRS, this.getDefaultMaxErrors());
        this.MaxWarnings = this.getIntOption(options, Option.XMAXWARNS, this.getDefaultMaxWarnings());
        boolean rawDiagnostics = options.isSet("rawDiagnostics");
        this.diagFormatter = rawDiagnostics ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        String ek = options.get("expectKeys");
        if (ek != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(ek.split(", *")));
        }
    }

    private int getIntOption(Options options, Option option, int defaultValue) {
        String s = options.get(option);
        try {
            if (s != null) {
                int n = Integer.parseInt(s);
                return n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    protected int getDefaultMaxErrors() {
        return 100;
    }

    protected int getDefaultMaxWarnings() {
        return 100;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject name, EndPosTable endPosTable) {
        Assert.checkNonNull(name);
        this.getSource(name).setEndPosTable(endPosTable);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagFormatter) {
        this.diagFormatter = diagFormatter;
    }

    public PrintWriter getWriter(WriterKind kind) {
        return this.writers.get((Object)kind);
    }

    public void setWriter(WriterKind kind, PrintWriter pw) {
        Assert.checkNonNull(pw);
        this.writers.put(kind, pw);
    }

    public void setWriters(PrintWriter pw) {
        Assert.checkNonNull(pw);
        for (WriterKind k : WriterKind.values()) {
            this.writers.put(k, pw);
        }
    }

    public void popDiagnosticHandler(DiagnosticHandler h) {
        Assert.check(this.diagnosticHandler == h);
        this.diagnosticHandler = h.prev;
    }

    public void flush() {
        for (PrintWriter pw : this.writers.values()) {
            pw.flush();
        }
    }

    public void flush(WriterKind kind) {
        this.getWriter(kind).flush();
    }

    protected boolean shouldReport(JavaFileObject file, int pos) {
        boolean shouldReport;
        if (file == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> coords = new Pair<JavaFileObject, Integer>(file, pos);
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    private boolean shouldReport(JCDiagnostic d) {
        boolean shouldReport;
        JavaFileObject file = d.getSource();
        if (file == null) {
            return true;
        }
        if (!this.shouldReport(file, d.getIntPosition())) {
            return false;
        }
        if (!d.isFlagSet(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL)) {
            return true;
        }
        Pair<JavaFileObject, String> coords = new Pair<JavaFileObject, String>(file, d.getCode());
        boolean bl = shouldReport = !this.recordedSourceLevelErrors.contains(coords);
        if (shouldReport) {
            this.recordedSourceLevelErrors.add(coords);
        }
        return shouldReport;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(this.localize("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int pos, PrintWriter writer) {
        String line;
        String string = line = this.source == null ? null : this.source.getLine(pos);
        if (line == null) {
            return;
        }
        int col = this.source.getColumnNumber(pos, false);
        Log.printRawLines(writer, line);
        for (int i = 0; i < col - 1; ++i) {
            writer.print(line.charAt(i) == '\t' ? "\t" : " ");
        }
        writer.println("^");
        writer.flush();
    }

    public void printNewline() {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        noticeWriter.println();
    }

    public void printNewline(WriterKind wk) {
        this.getWriter(wk).println();
    }

    public void printLines(String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize(key, args));
    }

    public void printLines(PrefixKind pk, String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize(pk, key, args));
    }

    public void printLines(WriterKind wk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(key, args));
    }

    public void printLines(WriterKind wk, PrefixKind pk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(pk, key, args));
    }

    public void printRawLines(String msg) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, msg);
    }

    public void printRawLines(WriterKind kind, String msg) {
        Log.printRawLines(this.getWriter(kind), msg);
    }

    public static void printRawLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    public void printVerbose(String key, Object ... args) {
        PrintWriter noticeWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(noticeWriter, this.localize("verbose." + key, args));
    }

    @Override
    protected void directError(String key, Object ... args) {
        PrintWriter errWriter = this.writers.get((Object)WriterKind.ERROR);
        Log.printRawLines(errWriter, this.localize(key, args));
        errWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.writeDiagnostic(this.diags.warning(null, this.source, pos, key, args));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        this.diagnosticHandler.report(diagnostic);
    }

    protected void writeDiagnostic(JCDiagnostic diag) {
        if (this.diagListener != null) {
            this.diagListener.report(diag);
            return;
        }
        PrintWriter writer = this.getWriterForDiagnosticType(diag.getType());
        Log.printRawLines(writer, this.diagFormatter.format(diag, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (diag.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.writers.get((Object)WriterKind.NOTICE);
            }
            case WARNING: {
                return this.writers.get((Object)WriterKind.WARNING);
            }
            case ERROR: {
                return this.writers.get((Object)WriterKind.ERROR);
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String key, Object ... args) {
        return JavacMessages.getDefaultLocalizedString(PrefixKind.COMPILER_MISC.key(key), args);
    }

    public String localize(String key, Object ... args) {
        return this.localize(PrefixKind.COMPILER_MISC, key, args);
    }

    public String localize(JCDiagnostic.DiagnosticInfo diagInfo) {
        if (useRawMessages) {
            return diagInfo.key();
        }
        return this.messages.getLocalizedString(diagInfo.key(), diagInfo.args);
    }

    public String localize(PrefixKind pk, String key, Object ... args) {
        if (useRawMessages) {
            return pk.key(key);
        }
        return this.messages.getLocalizedString(pk.key(key), args);
    }

    private void printRawDiag(PrintWriter pw, String prefix, int pos, String msg) {
        if (this.source == null || pos == -1) {
            Log.printRawLines(pw, prefix + msg);
        } else {
            int line = this.source.getLineNumber(pos);
            JavaFileObject file = this.source.getFile();
            if (file != null) {
                Log.printRawLines(pw, file.getName() + ":" + line + ": " + msg);
            }
            this.printErrLine(pos, pw);
        }
        pw.flush();
    }

    public void rawError(int pos, String msg) {
        PrintWriter errWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), pos)) {
            this.printRawDiag(errWriter, "error: ", pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        PrintWriter warnWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawDiag(warnWriter, "warning: ", pos, msg);
        }
        this.prompt();
        ++this.nwarnings;
        warnWriter.flush();
    }

    public static String format(String fmt, Object ... args) {
        return String.format((Locale)null, fmt, args);
    }

    private class DefaultDiagnosticHandler
    extends DiagnosticHandler {
        private DefaultDiagnosticHandler() {
        }

        @Override
        public void report(JCDiagnostic diagnostic) {
            if (Log.this.expectDiagKeys != null) {
                Log.this.expectDiagKeys.remove(diagnostic.getCode());
            }
            switch (diagnostic.getType()) {
                case FRAGMENT: {
                    throw new IllegalArgumentException();
                }
                case NOTE: {
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory() || Log.this.suppressNotes) break;
                    Log.this.writeDiagnostic(diagnostic);
                    break;
                }
                case WARNING: {
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory() || Log.this.nwarnings >= Log.this.MaxWarnings) break;
                    Log.this.writeDiagnostic(diagnostic);
                    ++Log.this.nwarnings;
                    break;
                }
                case ERROR: {
                    if (Log.this.nerrors >= Log.this.MaxErrors || !diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.MULTIPLE) && !Log.this.shouldReport(diagnostic)) break;
                    Log.this.writeDiagnostic(diagnostic);
                    ++Log.this.nerrors;
                }
            }
            if (diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.COMPRESSED)) {
                Log.this.compressedOutput = true;
            }
        }
    }

    public static enum WriterKind {
        NOTICE,
        WARNING,
        ERROR,
        STDOUT,
        STDERR;

    }

    public static class DeferredDiagnosticHandler
    extends DiagnosticHandler {
        private Queue<JCDiagnostic> deferred = new ListBuffer<JCDiagnostic>();
        private final Filter<JCDiagnostic> filter;

        public DeferredDiagnosticHandler(Log log) {
            this(log, null);
        }

        public DeferredDiagnosticHandler(Log log, Filter<JCDiagnostic> filter) {
            this.filter = filter;
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic diag) {
            if (!diag.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) && (this.filter == null || this.filter.accepts(diag))) {
                this.deferred.add(diag);
            } else {
                this.prev.report(diag);
            }
        }

        public Queue<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics(EnumSet.allOf(Diagnostic.Kind.class));
        }

        public void reportDeferredDiagnostics(Set<Diagnostic.Kind> kinds) {
            JCDiagnostic d;
            while ((d = this.deferred.poll()) != null) {
                if (!kinds.contains((Object)d.getKind())) continue;
                this.prev.report(d);
            }
            this.deferred = null;
        }
    }

    public static class DiscardDiagnosticHandler
    extends DiagnosticHandler {
        public DiscardDiagnosticHandler(Log log) {
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic diag) {
        }
    }

    public static abstract class DiagnosticHandler {
        protected DiagnosticHandler prev;

        protected void install(Log log) {
            this.prev = log.diagnosticHandler;
            log.diagnosticHandler = this;
        }

        public abstract void report(JCDiagnostic var1);
    }

    public static enum PrefixKind {
        JAVAC("javac."),
        COMPILER_MISC("compiler.misc.");

        final String value;

        private PrefixKind(String v) {
            this.value = v;
        }

        public String key(String k) {
            return this.value + k;
        }
    }
}

