/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class MemberEnter
extends JCTree.Visitor {
    protected static final Context.Key<MemberEnter> memberEnterKey = new Context.Key();
    private final Enter enter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final Annotate annotate;
    private final Types types;
    private final DeferredLintHandler deferredLintHandler;
    protected Env<AttrContext> env;

    public static MemberEnter instance(Context context) {
        MemberEnter instance = context.get(memberEnterKey);
        if (instance == null) {
            instance = new MemberEnter(context);
        }
        return instance;
    }

    protected MemberEnter(Context context) {
        context.put(memberEnterKey, this);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
    }

    Type signature(Symbol.MethodSymbol msym, List<JCTree.JCTypeParameter> typarams, List<JCTree.JCVariableDecl> params, JCTree res, JCTree.JCVariableDecl recvparam, List<JCTree.JCExpression> thrown, Env<AttrContext> env) {
        Type recvtype;
        Type.JCVoidType restype;
        List<Type> tvars = this.enter.classEnter(typarams, env);
        this.attr.attribTypeVariables(typarams, env);
        ListBuffer<Type> argbuf = new ListBuffer<Type>();
        List<JCTree.JCVariableDecl> l = params;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            argbuf.append(((JCTree.JCVariableDecl)l.head).vartype.type);
            l = l.tail;
        }
        Type type = restype = res == null ? this.syms.voidType : this.attr.attribType(res, env);
        if (recvparam != null) {
            this.memberEnter(recvparam, env);
            recvtype = recvparam.vartype.type;
        } else {
            recvtype = null;
        }
        ListBuffer<Type> thrownbuf = new ListBuffer<Type>();
        List<JCTree.JCExpression> l2 = thrown;
        while (l2.nonEmpty()) {
            Type exc = this.attr.attribType((JCTree)l2.head, env);
            if (!exc.hasTag(TypeTag.TYPEVAR)) {
                exc = this.chk.checkClassType(((JCTree.JCExpression)l2.head).pos(), exc);
            } else if (exc.tsym.owner == msym) {
                exc.tsym.flags_field |= 0x800000000000L;
            }
            thrownbuf.append(exc);
            l2 = l2.tail;
        }
        Type.MethodType mtype = new Type.MethodType(argbuf.toList(), restype, thrownbuf.toList(), this.syms.methodClass);
        mtype.recvtype = recvtype;
        return tvars.isEmpty() ? mtype : new Type.ForAll(tvars, (Type)mtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(JCTree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    void memberEnter(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(0L, tree.name, null, enclScope.owner);
        m.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, m, tree);
        tree.sym = m;
        if ((tree.mods.flags & 0x80000000000L) != 0L) {
            m.enclClass().flags_field |= 0x80000000000L;
        }
        Env<AttrContext> localEnv = this.methodEnv(tree, this.env);
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        try {
            m.type = this.signature(m, tree.typarams, tree.params, tree.restype, tree.recvparam, tree.thrown, localEnv);
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
        }
        if (this.types.isSignaturePolymorphic(m)) {
            m.flags_field |= 0x400000000000L;
        }
        ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
        JCTree.JCVariableDecl lastParam = null;
        List<JCTree.JCVariableDecl> l = tree.params;
        while (l.nonEmpty()) {
            JCTree.JCVariableDecl param = lastParam = (JCTree.JCVariableDecl)l.head;
            params.append(Assert.checkNonNull(param.sym));
            l = l.tail;
        }
        m.params = params.toList();
        if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
            m.flags_field |= 0x400000000L;
        }
        ((AttrContext)localEnv.info).scope.leave();
        if (this.chk.checkUnique(tree.pos(), m, enclScope)) {
            enclScope.enter(m);
        }
        this.annotate.annotateLater(tree.mods.annotations, localEnv, m, tree.pos());
        this.annotate.queueScanTreeAndTypeAnnotate(tree, localEnv, m, tree.pos());
        if (tree.defaultValue != null) {
            m.defaultValue = this.annotate.unfinishedDefaultValue();
            this.annotate.annotateDefaultValueLater(tree.defaultValue, localEnv, m, tree.pos());
        }
    }

    Env<AttrContext> methodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(tree.sym)));
        localEnv.enclMethod = tree;
        if (tree.sym.type != null) {
            AttrContext attrContext = (AttrContext)localEnv.info;
            Attr attr = this.attr;
            Objects.requireNonNull(attr);
            attrContext.returnResult = new Attr.ResultInfo(attr, Kinds.KindSelector.VAL, tree.sym.type.getReturnType());
        }
        if ((tree.mods.flags & 8L) != 0L) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Env<AttrContext> localEnv = this.env;
        if ((tree.mods.flags & 8L) != 0L || (((AttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup());
            ++((AttrContext)localEnv.info).staticLevel;
        }
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        try {
            if (TreeInfo.isEnumInit(tree)) {
                this.attr.attribIdentAsEnumType(localEnv, (JCTree.JCIdent)tree.vartype);
            } else {
                this.attr.attribType((JCTree)tree.vartype, localEnv);
                if (TreeInfo.isReceiverParam(tree)) {
                    this.checkReceiver(tree, localEnv);
                }
            }
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
        }
        if ((tree.mods.flags & 0x400000000L) != 0L) {
            Type.ArrayType atype = (Type.ArrayType)tree.vartype.type;
            tree.vartype.type = atype.makeVarargs();
        }
        Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
        Symbol.VarSymbol v = new Symbol.VarSymbol(0L, tree.name, tree.vartype.type, enclScope.owner);
        v.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, v, tree);
        tree.sym = v;
        if (tree.init != null) {
            v.flags_field |= 0x40000L;
            if ((v.flags_field & 0x10L) != 0L && this.needsLazyConstValue(tree.init)) {
                Env<AttrContext> initEnv = this.getInitEnv(tree, this.env);
                ((AttrContext)initEnv.info).enclVar = v;
                v.setLazyConstValue(this.initEnv(tree, initEnv), this.attr, tree);
            }
        }
        if (this.chk.checkUnique(tree.pos(), v, enclScope)) {
            this.chk.checkTransparentVar(tree.pos(), v, enclScope);
            enclScope.enter(v);
        }
        this.annotate.annotateLater(tree.mods.annotations, localEnv, v, tree.pos());
        this.annotate.queueScanTreeAndTypeAnnotate(tree.vartype, localEnv, v, tree.pos());
        v.pos = tree.pos;
    }

    void checkType(JCTree tree, Type type, String diag) {
        if (!tree.type.isErroneous() && !this.types.isSameType(tree.type, type)) {
            this.log.error(tree, diag, type, tree.type);
        }
    }

    void checkReceiver(JCTree.JCVariableDecl tree, Env<AttrContext> localEnv) {
        this.attr.attribExpr(tree.nameexpr, localEnv);
        Symbol.MethodSymbol m = localEnv.enclMethod.sym;
        if (m.isConstructor()) {
            Type outertype = m.owner.owner.type;
            if (outertype.hasTag(TypeTag.METHOD)) {
                outertype = m.owner.owner.owner.type;
            }
            if (outertype.hasTag(TypeTag.CLASS)) {
                this.checkType(tree.vartype, outertype, "incorrect.constructor.receiver.type");
                this.checkType(tree.nameexpr, outertype, "incorrect.constructor.receiver.name");
            } else {
                this.log.error(tree, "receiver.parameter.not.applicable.constructor.toplevel.class", new Object[0]);
            }
        } else {
            this.checkType(tree.vartype, m.owner.type, "incorrect.receiver.type");
            this.checkType(tree.nameexpr, m.owner.type, "incorrect.receiver.name");
        }
    }

    public boolean needsLazyConstValue(JCTree tree) {
        InitTreeVisitor initTreeVisitor = new InitTreeVisitor();
        tree.accept(initTreeVisitor);
        return initTreeVisitor.result;
    }

    Env<AttrContext> initEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dupto(new AttrContextEnv((JCTree)tree, ((AttrContext)env.info).dup()));
        if (tree.sym.owner.kind == Kinds.Kind.TYP) {
            ((AttrContext)localEnv.info).scope = ((AttrContext)env.info).scope.dupUnshared(tree.sym);
        }
        if ((tree.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L && env.enclMethod == null) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    @Override
    public void visitTree(JCTree tree) {
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        if (tree.errs != null) {
            this.memberEnter(tree.errs, this.env);
        }
    }

    public Env<AttrContext> getMethodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        Env<AttrContext> mEnv = this.methodEnv(tree, env);
        ((AttrContext)mEnv.info).lint = ((AttrContext)mEnv.info).lint.augment(tree.sym);
        List<JCTree> l = tree.typarams;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCTypeParameter)l.head).type.tsym);
            l = l.tail;
        }
        l = tree.params;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCVariableDecl)l.head).sym);
            l = l.tail;
        }
        return mEnv;
    }

    public Env<AttrContext> getInitEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        Env<AttrContext> iEnv = this.initEnv(tree, env);
        return iEnv;
    }

    static class InitTreeVisitor
    extends JCTree.Visitor {
        private static final Set<JCTree.Tag> ALLOWED_OPERATORS = EnumSet.of(JCTree.Tag.POS, new JCTree.Tag[]{JCTree.Tag.NEG, JCTree.Tag.NOT, JCTree.Tag.COMPL, JCTree.Tag.PLUS, JCTree.Tag.MINUS, JCTree.Tag.MUL, JCTree.Tag.DIV, JCTree.Tag.MOD, JCTree.Tag.SL, JCTree.Tag.SR, JCTree.Tag.USR, JCTree.Tag.LT, JCTree.Tag.LE, JCTree.Tag.GT, JCTree.Tag.GE, JCTree.Tag.EQ, JCTree.Tag.NE, JCTree.Tag.BITAND, JCTree.Tag.BITXOR, JCTree.Tag.BITOR, JCTree.Tag.AND, JCTree.Tag.OR});
        boolean result = true;

        InitTreeVisitor() {
        }

        @Override
        public void visitTree(JCTree tree) {
            this.result = false;
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral that) {
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary that) {
            if (!ALLOWED_OPERATORS.contains((Object)that.getTag())) {
                this.result = false;
                return;
            }
            that.arg.accept(this);
        }

        @Override
        public void visitBinary(JCTree.JCBinary that) {
            if (!ALLOWED_OPERATORS.contains((Object)that.getTag())) {
                this.result = false;
                return;
            }
            that.lhs.accept(this);
            that.rhs.accept(this);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            tree.cond.accept(this);
            tree.truepart.accept(this);
            tree.falsepart.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitIdent(JCTree.JCIdent that) {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            tree.selected.accept(this);
        }
    }
}

