/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.GraphMatching;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class IterableSubject
extends Subject<IterableSubject, Iterable<?>> {
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected IterableSubject(FailureMetadata metadata, @NullableDecl Iterable<?> iterable) {
        super(metadata, iterable);
    }

    @Override
    protected String actualCustomStringRepresentation() {
        if (this.actual() != null) {
            String objectToString = ((Iterable)this.actual()).getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this.actual()));
            if (((Iterable)this.actual()).toString().equals(objectToString)) {
                return Iterables.toString((Iterable)((Iterable)this.actual()));
            }
        }
        return super.actualCustomStringRepresentation();
    }

    public final void isEmpty() {
        if (!Iterables.isEmpty((Iterable)((Iterable)this.actual()))) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (Iterables.isEmpty((Iterable)((Iterable)this.actual()))) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = Iterables.size((Iterable)((Iterable)this.actual()));
        this.check("size()", new Object[0]).that(actualSize).isEqualTo(expectedSize);
    }

    public final void contains(@NullableDecl Object element) {
        if (!Iterables.contains((Iterable)((Iterable)this.actual()), (Object)element)) {
            ArrayList elementList = Lists.newArrayList((Object[])new Object[]{element});
            if (SubjectUtils.hasMatchingToStringPair((Iterable)this.actual(), elementList)) {
                this.failWithoutActual(Fact.fact("expected to contain", element), Fact.fact("an instance of", SubjectUtils.objectToTypeName(element)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString((Iterable)this.actual(), elementList))), this.fullContents());
            } else {
                this.failWithActual("expected to contain", element);
            }
        }
    }

    public final void doesNotContain(@NullableDecl Object element) {
        if (Iterables.contains((Iterable)((Iterable)this.actual()), (Object)element)) {
            this.failWithActual("expected not to contain", element);
        }
    }

    public final void containsNoDuplicates() {
        ArrayList duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create((Iterable)((Iterable)this.actual())).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to contain duplicates"), Fact.fact("but contained", duplicates), this.fullContents());
        }
    }

    public final void containsAnyOf(@NullableDecl Object first, @NullableDecl Object second, Object ... rest) {
        this.containsAnyIn(SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsAnyIn(Iterable<?> expected) {
        Collection actual = SubjectUtils.iterableToCollection((Iterable)this.actual());
        for (Object item : expected) {
            if (!actual.contains(item)) continue;
            return;
        }
        if (SubjectUtils.hasMatchingToStringPair(actual, expected)) {
            this.failWithoutActual(Fact.fact("expected to contain any of", SubjectUtils.countDuplicatesAndAddTypeInfo(expected)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString((Iterable)this.actual(), expected))), this.fullContents());
        } else {
            this.failWithActual("expected to contain any of", expected);
        }
    }

    public final void containsAnyIn(Object[] expected) {
        this.containsAnyIn(Arrays.asList(expected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAllOf(@NullableDecl Object firstExpected, @NullableDecl Object secondExpected, Object ... restOfExpected) {
        return this.containsAllIn(SubjectUtils.accumulate(firstExpected, secondExpected, restOfExpected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAllIn(Iterable<?> expectedIterable) {
        LinkedList actual = Lists.newLinkedList((Iterable)((Iterable)this.actual()));
        final Collection<?> expected = SubjectUtils.iterableToCollection(expectedIterable);
        ArrayList missing = Lists.newArrayList();
        ArrayList actualNotInOrder = Lists.newArrayList();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            return this.failAllIn(expected, missing);
        }
        return ordered ? IN_ORDER : new Ordered(){

            @Override
            public void inOrder() {
                IterableSubject.this.failWithActual(Fact.simpleFact("required elements were all found, but order was wrong"), Fact.fact("expected order for required elements", expected));
            }
        };
    }

    private Ordered failAllIn(Collection<?> expected, Collection<?> missingRawObjects) {
        List<Object> nearMissRawObjects = SubjectUtils.retainMatchingToString((Iterable)this.actual(), missingRawObjects);
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "though it did contain", nearMissRawObjects));
        facts.add((Object)Fact.fact("expected to contain at least", expected));
        facts.add((Object)this.butWas());
        this.failWithoutActual((Iterable<Fact>)facts.build());
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    public final Ordered containsAllIn(Object[] expected) {
        return this.containsAllIn(Arrays.asList(expected));
    }

    private static void moveElements(List<?> input, Collection<Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(Object ... varargs) {
        ArrayList expected = varargs == null ? Lists.newArrayList((Object[])new Object[]{null}) : Arrays.asList(varargs);
        return this.containsExactlyElementsIn(expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactlyElementsIn(expected, false);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(Object[] expected) {
        return this.containsExactlyElementsIn(Arrays.asList(expected));
    }

    private Ordered containsExactlyElementsIn(final Iterable<?> required, boolean addElementsInWarning) {
        Iterator actualIter = ((Iterable)this.actual()).iterator();
        Iterator<?> requiredIter = required.iterator();
        if (!requiredIter.hasNext()) {
            if (actualIter.hasNext()) {
                this.isEmpty();
                return ALREADY_FAILED;
            }
            return IN_ORDER;
        }
        boolean isFirst = true;
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (!Objects.equal(actualElement, requiredElement = requiredIter.next())) {
                if (isFirst && !actualIter.hasNext() && !requiredIter.hasNext()) {
                    this.checkNoNeedToDisplayBothValues("onlyElement()", new Object[0]).that(actualElement).failEqualityCheckForEqualsWithoutDescription(requiredElement);
                    return ALREADY_FAILED;
                }
                ArrayList missing = Lists.newArrayList();
                missing.add(requiredElement);
                Iterators.addAll((Collection)missing, requiredIter);
                ArrayList extra = Lists.newArrayList();
                if (!missing.remove(actualElement)) {
                    extra.add(actualElement);
                }
                while (actualIter.hasNext()) {
                    Object item = actualIter.next();
                    if (missing.remove(item)) continue;
                    extra.add(item);
                }
                if (missing.isEmpty() && extra.isEmpty()) {
                    return new Ordered(){

                        @Override
                        public void inOrder() {
                            IterableSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("expected", required));
                        }
                    };
                }
                return this.failExactly(required, addElementsInWarning, missing, extra);
            }
            isFirst = false;
        }
        if (actualIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, (Collection<?>)ImmutableList.of(), Lists.newArrayList(actualIter));
        }
        if (requiredIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, Lists.newArrayList(requiredIter), (Collection<?>)ImmutableList.of());
        }
        return IN_ORDER;
    }

    private Ordered failExactly(Iterable<?> required, boolean addElementsInWarning, Collection<?> missingRawObjects, Collection<?> extraRawObjects) {
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "unexpected", extraRawObjects));
        facts.add((Object)Fact.fact("expected", required));
        facts.add((Object)this.butWas());
        if (addElementsInWarning) {
            facts.add((Object)Fact.simpleFact("Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?"));
        }
        this.failWithoutActual((Iterable<Fact>)facts.build());
        return ALREADY_FAILED;
    }

    private static ImmutableList<Fact> makeElementFactsForBoth(String firstKey, Collection<?> firstCollection, String secondKey, Collection<?> secondCollection) {
        boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(firstCollection, secondCollection);
        SubjectUtils.DuplicateGroupedAndTyped first = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(firstCollection, addTypeInfo);
        SubjectUtils.DuplicateGroupedAndTyped second = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(secondCollection, addTypeInfo);
        ElementFactGrouping grouping = IterableSubject.pickGrouping(first.entrySet(), second.entrySet());
        ImmutableList.Builder facts = ImmutableList.builder();
        ImmutableList<Fact> firstFacts = IterableSubject.makeElementFacts(firstKey, first, grouping);
        ImmutableList<Fact> secondFacts = IterableSubject.makeElementFacts(secondKey, second, grouping);
        facts.addAll(firstFacts);
        if (firstFacts.size() > 1 && secondFacts.size() > 1) {
            facts.add((Object)Fact.simpleFact(""));
        }
        facts.addAll(secondFacts);
        facts.add((Object)Fact.simpleFact("---"));
        return facts.build();
    }

    private static ImmutableList<Fact> makeElementFacts(String label, SubjectUtils.DuplicateGroupedAndTyped elements, ElementFactGrouping grouping) {
        if (elements.isEmpty()) {
            return ImmutableList.of();
        }
        if (grouping == ElementFactGrouping.ALL_IN_ONE_FACT) {
            return ImmutableList.of((Object)Fact.fact(IterableSubject.keyToGoWithElementsString(label, elements), elements));
        }
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.add((Object)Fact.simpleFact(IterableSubject.keyToServeAsHeader(label, elements)));
        int n = 1;
        for (Multiset.Entry<?> entry : elements.entrySet()) {
            int count = entry.getCount();
            Object item = entry.getElement();
            facts.add((Object)Fact.fact(IterableSubject.numberString(n, count), item));
            n += count;
        }
        return facts.build();
    }

    private static String keyToGoWithElementsString(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        return Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{label, elements.totalCopies()});
    }

    private static String keyToServeAsHeader(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        String key = IterableSubject.keyToGoWithElementsString(label, elements);
        if (elements.homogeneousTypeToDisplay.isPresent()) {
            key = key + " (" + (String)elements.homogeneousTypeToDisplay.get() + ")";
        }
        return key;
    }

    private static String numberString(int n, int count) {
        return count == 1 ? Strings.lenientFormat((String)"#%s", (Object[])new Object[]{n}) : Strings.lenientFormat((String)"#%s [%s copies]", (Object[])new Object[]{n, count});
    }

    private static ElementFactGrouping pickGrouping(Iterable<Multiset.Entry<?>> first, Iterable<Multiset.Entry<?>> second) {
        if (IterableSubject.anyHasMultiple(first, second) && IterableSubject.anyContainsCommaOrNewline(first, second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (IterableSubject.hasMultiple(first) && IterableSubject.containsEmptyOrLong(first)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (IterableSubject.hasMultiple(second) && IterableSubject.containsEmptyOrLong(second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        return ElementFactGrouping.ALL_IN_ONE_FACT;
    }

    private static boolean anyContainsCommaOrNewline(Iterable<Multiset.Entry<?>> ... lists) {
        for (Multiset.Entry entry : Iterables.concat((Iterable[])lists)) {
            String s = String.valueOf(entry.getElement());
            if (!s.contains("\n") && !s.contains(",")) continue;
            return true;
        }
        return false;
    }

    private static boolean anyHasMultiple(Iterable<Multiset.Entry<?>> ... lists) {
        for (Iterable<Multiset.Entry<?>> list : lists) {
            if (!IterableSubject.hasMultiple(list)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMultiple(Iterable<Multiset.Entry<?>> list) {
        return IterableSubject.totalCount(list) > 1;
    }

    private static boolean containsEmptyOrLong(Iterable<Multiset.Entry<?>> entries) {
        int totalLength = 0;
        for (Multiset.Entry<?> entry : entries) {
            String s = SubjectUtils.entryString(entry);
            if (s.isEmpty()) {
                return true;
            }
            totalLength += s.length();
        }
        return totalLength > 200;
    }

    private static int totalCount(Iterable<Multiset.Entry<?>> entries) {
        int totalCount = 0;
        for (Multiset.Entry<?> entry : entries) {
            totalCount += entry.getCount();
        }
        return totalCount;
    }

    public final void containsNoneOf(@NullableDecl Object firstExcluded, @NullableDecl Object secondExcluded, Object ... restOfExcluded) {
        this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
    }

    public final void containsNoneIn(Iterable<?> excluded) {
        Collection actual = SubjectUtils.iterableToCollection((Iterable)this.actual());
        ArrayList present = new ArrayList();
        for (Object item : Sets.newLinkedHashSet(excluded)) {
            if (!actual.contains(item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)), Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(present)), this.fullContents());
        }
    }

    public final void containsNoneIn(Object[] excluded) {
        this.containsNoneIn(Arrays.asList(excluded));
    }

    public final void isStrictlyOrdered() {
        this.isStrictlyOrdered((Comparator<?>)Ordering.natural());
    }

    public final void isStrictlyOrdered(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be strictly ordered", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) < 0;
            }
        });
    }

    public final void isOrdered() {
        this.isOrdered((Comparator<?>)Ordering.natural());
    }

    public final void isOrdered(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be ordered", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) <= 0;
            }
        });
    }

    private void pairwiseCheck(String expectedFact, PairwiseChecker checker) {
        Iterator iterator = ((Iterable)this.actual()).iterator();
        if (iterator.hasNext()) {
            Object prev = iterator.next();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!checker.check(prev, next)) {
                    this.failWithoutActual(Fact.simpleFact(expectedFact), Fact.fact("but contained", prev), Fact.fact("followed by", next), this.fullContents());
                    return;
                }
                prev = next;
            }
        }
    }

    @Override
    @Deprecated
    public void isNoneOf(@NullableDecl Object first, @NullableDecl Object second, Object ... rest) {
        super.isNoneOf(first, second, rest);
    }

    @Override
    @Deprecated
    public void isNotIn(Iterable<?> iterable) {
        if (Iterables.contains(iterable, this.actual())) {
            this.failWithActual("expected not to be any of", iterable);
        }
        ArrayList nonIterables = new ArrayList();
        for (Object element : iterable) {
            if (element instanceof Iterable) continue;
            nonIterables.add(element);
        }
        if (!nonIterables.isEmpty()) {
            this.failWithRawMessage("The actual value is an Iterable, and you've written a test that compares it to some objects that are not Iterables. Did you instead mean to check whether its *contents* match any of the *contents* of the given values? If so, call containsNoneOf(...)/containsNoneIn(...) instead. Non-iterables: %s", nonIterables);
        }
    }

    private Fact fullContents() {
        return Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall());
    }

    public <A, E> UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence<A, E>(this, correspondence);
    }

    public static class UsingCorrespondence<A, E> {
        private final IterableSubject subject;
        private final Correspondence<? super A, ? super E> correspondence;
        private final Optional<Pairer> pairer;

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence) {
            this.subject = (IterableSubject)Preconditions.checkNotNull((Object)subject);
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.absent();
        }

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence, Pairer pairer) {
            this.subject = (IterableSubject)Preconditions.checkNotNull((Object)subject);
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.of((Object)pairer);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super E, ? extends Object> keyFunction) {
            Function<? super E, ? extends Object> actualKeyFunction = keyFunction;
            return this.displayingDiffsPairedBy(actualKeyFunction, keyFunction);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super A, ? extends Object> actualKeyFunction, Function<? super E, ? extends Object> expectedKeyFunction) {
            return new UsingCorrespondence<A, E>(this.subject, this.correspondence, new Pairer(actualKeyFunction, expectedKeyFunction));
        }

        public void contains(@NullableDecl E expected) {
            List keyMatches;
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.compare(actual, expected)) continue;
                return;
            }
            if (this.pairer.isPresent() && !(keyMatches = ((Pairer)this.pairer.get()).pairOne(expected, this.getCastActual())).isEmpty()) {
                this.subject.failWithRawMessage("Not true that %s contains exactly one element that %s <%s>. It did contain the following elements with the correct key: <%s>", this.subject.actualAsString(), this.correspondence, expected, this.formatExtras(expected, keyMatches));
                return;
            }
            this.subject.fail("contains at least one element that " + this.correspondence, (Object)expected);
        }

        public void doesNotContain(@NullableDecl E excluded) {
            ArrayList<A> matchingElements = new ArrayList<A>();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.compare(actual, excluded)) continue;
                matchingElements.add(actual);
            }
            if (!matchingElements.isEmpty()) {
                this.subject.failWithRawMessage("%s should not have contained an element that %s <%s>. It contained the following such elements: <%s>", this.subject.actualAsString(), this.correspondence, excluded, matchingElements);
            }
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsExactly(E ... expected) {
            return this.containsExactlyElementsIn(expected == null ? Lists.newArrayList((Object[])new Object[]{null}) : Arrays.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (expectedList.isEmpty()) {
                if (actualList.isEmpty()) {
                    return IN_ORDER;
                }
                this.subject.isEmpty();
                return ALREADY_FAILED;
            }
            if (this.correspondInOrderExactly(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList);
            if (this.failIfCandidateMappingHasMissingOrExtra(actualList, expectedList, candidateMapping)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping((ImmutableMultimap<Integer, Integer>)candidateMapping);
            if (this.failIfOneToOneMappingHasMissingOrExtra((List<? extends A>)actualList, (List<? extends E>)expectedList, (BiMap<Integer, Integer>)maximalOneToOneMapping)) {
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    UsingCorrespondence.this.subject.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("comparing contents by testing that each element " + UsingCorrespondence.this.correspondence + " an expected value"), Fact.fact("expected", expected));
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(E[] expected) {
            return this.containsExactlyElementsIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderExactly(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            while (actual.hasNext() && expected.hasNext()) {
                E expectedElement;
                A actualElement = actual.next();
                if (this.correspondence.compare(actualElement, expectedElement = expected.next())) continue;
                return false;
            }
            return !actual.hasNext() && !expected.hasNext();
        }

        private ImmutableSetMultimap<Integer, Integer> findCandidateMapping(List<? extends A> actual, List<? extends E> expected) {
            ImmutableSetMultimap.Builder mapping = ImmutableSetMultimap.builder();
            for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
                for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
                    if (!this.correspondence.compare(actual.get(actualIndex), expected.get(expectedIndex))) continue;
                    mapping.put((Object)actualIndex, (Object)expectedIndex);
                }
            }
            return mapping.build();
        }

        private boolean failIfCandidateMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping) {
            List<A> extra = this.findNotIndexed(actual, (Set<Integer>)mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, (Set<Integer>)mapping.inverse().keySet());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithRawMessage("Not true that %s contains exactly one element that %s each element of <%s>. It %s", this.subject.actualAsString(), this.correspondence, expected, this.describeMissingOrExtra(missing, extra));
                return true;
            }
            return false;
        }

        private String describeMissingOrExtra(List<? extends E> missing, List<? extends A> extra) {
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(missing, extra);
                if (pairing != null) {
                    return this.describeMissingOrExtraWithPairing(pairing);
                }
                return this.describeMissingOrExtraWithoutPairing(this.correspondence.toString(), missing, extra) + ". (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)";
            }
            if (missing.size() == 1 && extra.size() >= 1) {
                return Strings.lenientFormat((String)"is missing an element that %s <%s> and has unexpected elements <%s>", (Object[])new Object[]{this.correspondence, missing.get(0), this.formatExtras(missing.get(0), extra)});
            }
            return this.describeMissingOrExtraWithoutPairing(this.correspondence.toString(), missing, extra);
        }

        private String describeMissingOrExtraWithoutPairing(String verb, List<? extends E> missing, List<? extends A> extra) {
            ArrayList messages = Lists.newArrayList();
            if (!missing.isEmpty()) {
                messages.add(Strings.lenientFormat((String)"is missing an element that %s %s", (Object[])new Object[]{verb, this.formatMissing(missing)}));
            }
            if (!extra.isEmpty()) {
                messages.add(Strings.lenientFormat((String)"has unexpected elements <%s>", (Object[])new Object[]{extra}));
            }
            return Joiner.on((String)" and ").join((Iterable)messages);
        }

        private String describeMissingOrExtraWithPairing(Pairing pairing) {
            ArrayList messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat((String)"is missing an element that corresponds to <%s> and has unexpected elements <%s> with key %s", (Object[])new Object[]{missing, this.formatExtras(missing, extras), key}));
            }
            if (!pairing.unpairedActualValues.isEmpty() || !pairing.unpairedExpectedValues.isEmpty()) {
                messages.add(this.describeMissingOrExtraWithoutPairing("corresponds to", pairing.unpairedExpectedValues, pairing.unpairedActualValues) + " without matching keys");
            }
            if (messages.size() > 1) {
                messages.set(messages.size() - 1, "and " + (String)messages.get(messages.size() - 1));
            }
            return Joiner.on((String)", ").join((Iterable)messages);
        }

        private List<String> formatExtras(E missing, List<? extends A> extras) {
            ArrayList<String> extrasFormatted = new ArrayList<String>();
            for (A extra : extras) {
                String diff = this.correspondence.formatDiff(extra, missing);
                if (diff != null) {
                    extrasFormatted.add(Strings.lenientFormat((String)"%s (diff: %s)", (Object[])new Object[]{extra, diff}));
                    continue;
                }
                extrasFormatted.add(extra.toString());
            }
            return extrasFormatted;
        }

        private <T> List<T> findNotIndexed(List<T> list, Set<Integer> indexes) {
            if (indexes.size() == list.size()) {
                return ImmutableList.of();
            }
            ArrayList notIndexed = Lists.newArrayList();
            for (int index = 0; index < list.size(); ++index) {
                if (indexes.contains(index)) continue;
                notIndexed.add(list.get(index));
            }
            return notIndexed;
        }

        private String formatMissing(List<?> missing) {
            if (missing.size() == 1) {
                return "<" + missing.get(0) + ">";
            }
            return "each of <" + missing + ">";
        }

        private ImmutableBiMap<Integer, Integer> findMaximalOneToOneMapping(ImmutableMultimap<Integer, Integer> edges) {
            return GraphMatching.maximumCardinalityBipartiteMatching(edges);
        }

        private boolean failIfOneToOneMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithRawMessage("Not true that %s contains exactly one element that %s each element of <%s>. It contains at least one element that matches each expected element, and every element it contains matches at least one expected element, but there was no 1:1 mapping between all the actual and expected elements. Using the most complete 1:1 mapping (or one such mapping, if there is a tie), it %s", this.subject.actualAsString(), this.correspondence, expected, this.describeMissingOrExtra(missing, extra));
                return true;
            }
            return false;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsAllOf(@NullableDecl E first, @NullableDecl E second, E ... rest) {
            return this.containsAllIn(SubjectUtils.accumulate(first, second, rest));
        }

        @CanIgnoreReturnValue
        public Ordered containsAllIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (this.correspondInOrderAllIn(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList);
            if (this.failIfCandidateMappingHasMissing(actualList, expectedList, candidateMapping)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping((ImmutableMultimap<Integer, Integer>)candidateMapping);
            if (this.failIfOneToOneMappingHasMissing((List<? extends A>)actualList, (List<? extends E>)expectedList, (BiMap<Integer, Integer>)maximalOneToOneMapping)) {
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    UsingCorrespondence.this.subject.failWithActual(Fact.simpleFact("required elements were all found, but order was wrong"), Fact.simpleFact("comparing contents by testing that each element " + UsingCorrespondence.this.correspondence + " an expected value"), Fact.fact("expected order for required elements", expected));
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsAllIn(E[] expected) {
            return this.containsAllIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderAllIn(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            while (expected.hasNext()) {
                E expectedElement = expected.next();
                if (this.findCorresponding(actual, expectedElement)) continue;
                return false;
            }
            return true;
        }

        private boolean findCorresponding(Iterator<? extends A> actual, E expectedElement) {
            while (actual.hasNext()) {
                A actualElement = actual.next();
                if (!this.correspondence.compare(actualElement, expectedElement)) continue;
                return true;
            }
            return false;
        }

        private boolean failIfCandidateMappingHasMissing(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping) {
            List<E> missing = this.findNotIndexed(expected, (Set<Integer>)mapping.inverse().keySet());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, (Set<Integer>)mapping.keySet());
                this.subject.failWithRawMessage("Not true that %s contains at least one element that %s each element of <%s>. It %s", this.subject.actualAsString(), this.correspondence, expected, this.describeMissing(missing, extra));
                return true;
            }
            return false;
        }

        private String describeMissing(List<? extends E> missing, List<? extends A> extra) {
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(missing, extra);
                if (pairing != null) {
                    return this.describeMissingWithPairing(pairing);
                }
                return this.describeMissingWithoutPairing(this.correspondence.toString(), missing) + ". (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)";
            }
            return this.describeMissingWithoutPairing(this.correspondence.toString(), missing);
        }

        private String describeMissingWithoutPairing(String verb, List<? extends E> missing) {
            return Strings.lenientFormat((String)"is missing an element that %s %s", (Object[])new Object[]{verb, this.formatMissing(missing)});
        }

        private String describeMissingWithPairing(Pairing pairing) {
            ArrayList messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat((String)"is missing an element that corresponds to <%s> (but did have elements <%s> with matching key %s)", (Object[])new Object[]{missing, this.formatExtras(missing, extras), key}));
            }
            if (!pairing.unpairedExpectedValues.isEmpty()) {
                messages.add(this.describeMissingWithoutPairing("corresponds to", pairing.unpairedExpectedValues) + " (without matching keys)");
            }
            if (messages.size() > 1) {
                messages.set(messages.size() - 1, "and " + (String)messages.get(messages.size() - 1));
            }
            return Joiner.on((String)", ").join((Iterable)messages);
        }

        private boolean failIfOneToOneMappingHasMissing(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping) {
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                this.subject.failWithRawMessage("Not true that %s contains at least one element that %s each element of <%s>. It contains at least one element that matches each expected element, but there was no 1:1 mapping between all the expected elements and any subset of the actual elements. Using the most complete 1:1 mapping (or one such mapping, if there is a tie), it %s", this.subject.actualAsString(), this.correspondence, expected, this.describeMissing(missing, extra));
                return true;
            }
            return false;
        }

        @SafeVarargs
        public final void containsAnyOf(@NullableDecl E first, @NullableDecl E second, E ... rest) {
            this.containsAny(Strings.lenientFormat((String)"contains at least one element that %s any of", (Object[])new Object[]{this.correspondence}), SubjectUtils.accumulate(first, second, rest));
        }

        public void containsAnyIn(Iterable<? extends E> expected) {
            this.containsAny(Strings.lenientFormat((String)"contains at least one element that %s any element in", (Object[])new Object[]{this.correspondence}), expected);
        }

        public void containsAnyIn(E[] expected) {
            this.containsAnyIn(Arrays.asList(expected));
        }

        private void containsAny(String failVerb, Iterable<? extends E> expected) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            for (E expectedItem : expected) {
                for (A actualItem : actual) {
                    if (!this.correspondence.compare(actualItem, expectedItem)) continue;
                    return;
                }
            }
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(SubjectUtils.iterableToList(expected), SubjectUtils.iterableToList(actual));
                if (pairing != null) {
                    if (!pairing.pairedKeysToExpectedValues.isEmpty()) {
                        this.subject.failWithRawMessage("Not true that %s %s <%s>. It contains the following values that match by key: %s", this.subject.actualAsString(), failVerb, expected, this.describeAnyMatchesByKey(pairing));
                    } else {
                        this.subject.failWithRawMessage("Not true that %s %s <%s>. It does not contain any matches by key, either", this.subject.actualAsString(), failVerb, expected);
                    }
                } else {
                    this.subject.failWithRawMessage("Not true that %s %s <%s>. (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)", this.subject.actualAsString(), failVerb, expected);
                }
            } else {
                this.subject.fail(failVerb, (Object)expected);
            }
        }

        private String describeAnyMatchesByKey(Pairing pairing) {
            ArrayList messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object expected = pairing.pairedKeysToExpectedValues.get(key);
                List got = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat((String)"with key %s, would have accepted %s, but got %s", (Object[])new Object[]{key, expected, this.formatExtras(expected, got)}));
            }
            return Joiner.on((String)"; ").join((Iterable)messages);
        }

        @SafeVarargs
        public final void containsNoneOf(@NullableDecl E firstExcluded, @NullableDecl E secondExcluded, E ... restOfExcluded) {
            this.containsNone("any of", SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
        }

        public void containsNoneIn(Iterable<? extends E> excluded) {
            this.containsNone("any element in", excluded);
        }

        public void containsNoneIn(E[] excluded) {
            this.containsNoneIn(Arrays.asList(excluded));
        }

        private void containsNone(String excludedPrefix, Iterable<? extends E> excluded) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            LinkedListMultimap present = LinkedListMultimap.create();
            for (Object excludedItem : Sets.newLinkedHashSet(excluded)) {
                for (A actualItem : actual) {
                    if (!this.correspondence.compare(actualItem, excludedItem)) continue;
                    present.put(excludedItem, actualItem);
                }
            }
            if (!present.isEmpty()) {
                StringBuilder presentDescription = new StringBuilder();
                for (Object excludedItem : present.keySet()) {
                    List actualItems;
                    if (presentDescription.length() > 0) {
                        presentDescription.append(", ");
                    }
                    if ((actualItems = present.get(excludedItem)).size() == 1) {
                        presentDescription.append(actualItems.get(0)).append(" which corresponds to ").append(excludedItem);
                        continue;
                    }
                    presentDescription.append(actualItems).append(" which all correspond to ").append(excludedItem);
                }
                this.subject.failWithRawMessage("Not true that %s contains no element that %s %s <%s>. It contains <[%s]>", this.subject.actualAsString(), this.correspondence, excludedPrefix, excluded, presentDescription);
            }
        }

        private Iterable<A> getCastActual() {
            return (Iterable)this.subject.actual();
        }

        private final class Pairing {
            private final Map<Object, E> pairedKeysToExpectedValues = new LinkedHashMap();
            private final ListMultimap<Object, A> pairedKeysToActualValues = LinkedListMultimap.create();
            private final List<E> unpairedExpectedValues = Lists.newArrayList();
            private final List<A> unpairedActualValues = Lists.newArrayList();

            private Pairing() {
            }
        }

        private final class Pairer {
            private final Function<? super A, ?> actualKeyFunction;
            private final Function<? super E, ?> expectedKeyFunction;

            Pairer(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
                this.actualKeyFunction = actualKeyFunction;
                this.expectedKeyFunction = expectedKeyFunction;
            }

            @NullableDecl
            Pairing pair(List<? extends E> expectedValues, List<? extends A> actualValues) {
                Object key;
                Pairing pairing = new Pairing();
                for (Object expected : expectedValues) {
                    key = this.expectedKeyFunction.apply(expected);
                    if (key == null) continue;
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        return null;
                    }
                    pairing.pairedKeysToExpectedValues.put(key, expected);
                }
                for (Object actual : actualValues) {
                    key = this.actualKeyFunction.apply(actual);
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        pairing.pairedKeysToActualValues.put(key, actual);
                        continue;
                    }
                    pairing.unpairedActualValues.add(actual);
                }
                for (Object expected : expectedValues) {
                    key = this.expectedKeyFunction.apply(expected);
                    if (pairing.pairedKeysToActualValues.containsKey(key)) continue;
                    pairing.unpairedExpectedValues.add(expected);
                    pairing.pairedKeysToExpectedValues.remove(key);
                }
                return pairing;
            }

            List<A> pairOne(E expectedValue, Iterable<? extends A> actualValues) {
                Object key = this.expectedKeyFunction.apply(expectedValue);
                ArrayList matches = new ArrayList();
                if (key != null) {
                    for (Object actual : actualValues) {
                        if (!key.equals(this.actualKeyFunction.apply(actual))) continue;
                        matches.add(actual);
                    }
                }
                return matches;
            }
        }
    }

    private static interface PairwiseChecker {
        public boolean check(Object var1, Object var2);
    }

    static enum ElementFactGrouping {
        ALL_IN_ONE_FACT,
        FACT_PER_ELEMENT;

    }
}

