/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.errorprone.fixes.Replacement;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Replacements {
    private static final Comparator<Range<Integer>> DESCENDING = new Comparator<Range<Integer>>(){

        @Override
        public int compare(Range<Integer> o1, Range<Integer> o2) {
            return ComparisonChain.start().compare((Object)o1.lowerEndpoint(), (Object)o2.lowerEndpoint(), (Comparator)Ordering.natural().reverse()).compare((Object)o1.upperEndpoint(), (Object)o2.upperEndpoint(), (Comparator)Ordering.natural().reverse()).result();
        }
    };
    private final TreeMap<Range<Integer>, Replacement> replacements = new TreeMap(DESCENDING);
    private final RangeMap<Integer, Replacement> overlaps = TreeRangeMap.create();
    private final TreeSet<Integer> zeroLengthRanges = new TreeSet();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Replacements add(Replacement replacement) {
        if (this.replacements.containsKey(replacement.range())) {
            Replacement existing = this.replacements.get(replacement.range());
            if (!existing.equals(replacement)) {
                if (!replacement.range().isEmpty()) throw new IllegalArgumentException(String.format("%s conflicts with existing replacement %s", replacement, existing));
                replacement = Replacement.create(existing.startPosition(), existing.endPosition(), existing.replaceWith() + replacement.replaceWith());
            }
        } else {
            this.checkOverlaps(replacement);
        }
        this.replacements.put(replacement.range(), replacement);
        return this;
    }

    private void checkOverlaps(Replacement replacement) {
        Range<Integer> replacementRange = replacement.range();
        Collection overlap = this.overlaps.subRangeMap(replacementRange).asMapOfRanges().values();
        Preconditions.checkArgument((boolean)overlap.isEmpty(), (String)"%s overlaps with existing replacements: %s", (Object)replacement, (Object)Joiner.on((String)", ").join(overlap));
        NavigableSet<Integer> containedZeroLengthRangeStarts = this.zeroLengthRanges.subSet((Integer)replacementRange.lowerEndpoint(), false, (Integer)replacementRange.upperEndpoint(), false);
        Preconditions.checkArgument((boolean)containedZeroLengthRangeStarts.isEmpty(), (String)"%s overlaps with existing zero-length replacements: %s", (Object)replacement, (Object)Joiner.on((String)", ").join(containedZeroLengthRangeStarts));
        this.overlaps.put(replacementRange, (Object)replacement);
        if (replacementRange.isEmpty()) {
            this.zeroLengthRanges.add((Integer)replacementRange.lowerEndpoint());
        }
    }

    public Set<Replacement> descending() {
        return new LinkedHashSet<Replacement>(this.replacements.values());
    }

    public boolean isEmpty() {
        return this.replacements.isEmpty();
    }
}

