/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.SourceFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class FsFileDestination
implements FileDestination {
    private final Path rootPath;

    public FsFileDestination(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void writeFile(SourceFile update) throws IOException {
        Path targetPath = this.rootPath.resolve(update.getPath());
        Files.write(targetPath, update.getSourceText().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public void flush() throws IOException {
    }
}

