/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class ByteStringCodec
implements ObjectCodec<ByteString> {
    @Override
    public Class<? extends ByteString> getEncodedClass() {
        return ByteString.class;
    }

    @Override
    public void serialize(SerializationContext context, ByteString obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeByteArrayNoTag(obj.toByteArray());
    }

    @Override
    public ByteString deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        return ByteString.copyFrom((byte[])codedIn.readByteArray());
    }
}

