/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.WriteQueue;

class CancelClientStreamCommand
extends WriteQueue.AbstractQueuedCommand {
    private final NettyClientStream.TransportState stream;
    private final Status reason;

    CancelClientStreamCommand(NettyClientStream.TransportState stream, Status reason) {
        this.stream = (NettyClientStream.TransportState)Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull((Object)reason, (Object)"reason");
        Preconditions.checkArgument((!reason.isOk() ? 1 : 0) != 0, (Object)"Should not cancel with OK status");
        this.reason = reason;
    }

    NettyClientStream.TransportState stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }
}

