/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.predicates;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.type.Any;
import com.google.errorprone.predicates.type.Array;
import com.google.errorprone.predicates.type.DescendantOf;
import com.google.errorprone.predicates.type.DescendantOfAny;
import com.google.errorprone.predicates.type.Exact;
import com.google.errorprone.predicates.type.ExactAny;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.tools.javac.code.Type;

public final class TypePredicates {
    private static final Function<String, Supplier<Type>> GET_TYPE = new Function<String, Supplier<Type>>(){

        public Supplier<Type> apply(String input) {
            return Suppliers.typeFromString(input);
        }
    };

    public static TypePredicate isArray() {
        return Array.INSTANCE;
    }

    public static TypePredicate anyType() {
        return Any.INSTANCE;
    }

    public static TypePredicate isExactType(String type) {
        return TypePredicates.isExactType(Suppliers.typeFromString(type));
    }

    public static TypePredicate isExactType(Supplier<Type> type) {
        return new Exact(type);
    }

    public static TypePredicate isExactTypeAny(Iterable<String> types) {
        return new ExactAny(Iterables.transform(types, GET_TYPE));
    }

    public static TypePredicate isDescendantOf(Supplier<Type> type) {
        return new DescendantOf(type);
    }

    public static TypePredicate isDescendantOfAny(Iterable<String> types) {
        return new DescendantOfAny(Iterables.transform(types, GET_TYPE));
    }

    public static TypePredicate isDescendantOf(String type) {
        return TypePredicates.isDescendantOf(Suppliers.typeFromString(type));
    }
}

