/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByUtils_GuardedByValidationResult;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.Optional;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class GuardedByUtils {
    static String getGuardValue(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return null;
        }
        return sym.getRawAttributes().stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("GuardedBy")).findFirst().flatMap(a -> Optional.ofNullable(a.member(state.getName("value"))).flatMap(v -> GuardedByUtils.asString(v))).orElse(null);
    }

    private static Optional<String> asString(Attribute v) {
        return Optional.ofNullable(v.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            public String visitString(String s, Void aVoid) {
                return s;
            }
        }, null));
    }

    public static JCTree.JCExpression parseString(String guardedByString, Context context) {
        JCTree.JCExpression exp;
        JavacParser parser = ParserFactory.instance(context).newParser(guardedByString, false, true, false);
        try {
            exp = parser.parseExpression();
        }
        catch (Throwable e) {
            throw new IllegalGuardedBy(e.getMessage());
        }
        int len = parser.getEndPos(exp) - exp.getStartPosition();
        if (len != guardedByString.length()) {
            throw new IllegalGuardedBy("Didn't parse entire string.");
        }
        return exp;
    }

    public static GuardedByValidationResult isGuardedByValid(Tree tree, VisitorState state) {
        boolean staticGuard;
        String guard = GuardedByUtils.getGuardValue(tree, state);
        if (guard == null) {
            return GuardedByValidationResult.ok();
        }
        Optional<GuardedByExpression> boundGuard = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, state));
        if (!boundGuard.isPresent()) {
            return GuardedByValidationResult.invalid("could not resolve guard");
        }
        Symbol treeSym = ASTHelpers.getSymbol((Tree)tree);
        if (treeSym == null) {
            return GuardedByValidationResult.ok();
        }
        boolean bl = staticGuard = boundGuard.get().kind() == GuardedByExpression.Kind.CLASS_LITERAL || boundGuard.get().sym() != null && boundGuard.get().sym().isStatic();
        if (treeSym.isStatic() && !staticGuard) {
            return GuardedByValidationResult.invalid("static member guarded by instance");
        }
        return GuardedByValidationResult.ok();
    }

    public static Symbol bindGuardedByString(Tree tree, String guard, VisitorState visitorState) {
        Optional<GuardedByExpression> bound = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, visitorState));
        if (!bound.isPresent()) {
            return null;
        }
        return bound.get().sym();
    }

    @AutoValue
    static abstract class GuardedByValidationResult {
        GuardedByValidationResult() {
        }

        abstract String message();

        abstract Boolean isValid();

        static GuardedByValidationResult invalid(String message) {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult(message, false);
        }

        static GuardedByValidationResult ok() {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult("", true);
        }
    }
}

