/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Comments;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

@BugPattern(name="BooleanParameter", summary="Use parameter comments to document ambiguous literals", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class BooleanParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> BLACKLIST = ImmutableSet.of((Object)"value");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() < 2) {
            return Description.NO_MATCH;
        }
        if (arguments.stream().noneMatch(a -> a.getKind() == Tree.Kind.BOOLEAN_LITERAL)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (NamedParameterComment.containsSyntheticParameterName(sym)) {
            return Description.NO_MATCH;
        }
        int start = ((JCTree)((Object)tree)).getStartPosition();
        int end = state.getEndPosition((Tree)Iterables.getLast(tree.getArguments()));
        String source = state.getSourceCode().subSequence(start, end).toString();
        ArrayDeque tokens = new ArrayDeque(ErrorProneTokens.getTokens((String)source, (Context)state.context));
        Streams.forEachPair(sym.getParameters().stream(), arguments.stream(), (p, c) -> this.checkParameter((Symbol.VarSymbol)p, (ExpressionTree)c, start, tokens, state));
        return Description.NO_MATCH;
    }

    private void checkParameter(Symbol.VarSymbol paramSym, ExpressionTree a, int start, Deque<ErrorProneToken> tokens, VisitorState state) {
        if (a.getKind() != Tree.Kind.BOOLEAN_LITERAL) {
            return;
        }
        String name = ((Name)paramSym.getSimpleName()).toString();
        if (name.length() < 2) {
            return;
        }
        if (BLACKLIST.contains((Object)name)) {
            return;
        }
        while (!tokens.isEmpty() && start + tokens.peekFirst().pos() < ((JCTree)((Object)a)).getStartPosition()) {
            tokens.removeFirst();
        }
        if (tokens.isEmpty()) {
            return;
        }
        Range argRange = Range.closedOpen((Comparable)Integer.valueOf(((JCTree)((Object)a)).getStartPosition()), (Comparable)Integer.valueOf(state.getEndPosition((Tree)a)));
        if (!argRange.contains((Comparable)Integer.valueOf(start + tokens.peekFirst().pos()))) {
            return;
        }
        if (BooleanParameter.hasParameterComment(tokens.removeFirst())) {
            return;
        }
        state.reportMatch(this.describeMatch(a, (Fix)SuggestedFix.prefixWith((Tree)a, (String)String.format("/* %s= */", paramSym.getSimpleName()))));
    }

    private static boolean hasParameterComment(ErrorProneToken token) {
        return token.comments().stream().filter(c -> c.getStyle() == Tokens.Comment.CommentStyle.BLOCK).anyMatch(c -> NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((Tokens.Comment)c)).matches());
    }
}

