/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.FieldMaskUtil;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;

public class JsonFormat {
    private static final Logger logger = Logger.getLogger(JsonFormat.class.getName());

    private JsonFormat() {
    }

    public static Printer printer() {
        return new Printer(TypeRegistry.getEmptyTypeRegistry(), false, Collections.emptySet(), false, false);
    }

    public static Parser parser() {
        return new Parser(TypeRegistry.getEmptyTypeRegistry(), false, 100);
    }

    private static String unsignedToString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    private static String getTypeName(String string) throws InvalidProtocolBufferException {
        String[] stringArray = string.split("/");
        if (stringArray.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + string);
        }
        return stringArray[stringArray.length - 1];
    }

    private static class ParserImpl {
        private final TypeRegistry registry;
        private final JsonParser jsonParser;
        private final boolean ignoringUnknownFields;
        private final int recursionLimit;
        private int currentDepth;
        private static final Map<String, WellKnownTypeParser> wellKnownTypeParsers = ParserImpl.buildWellKnownTypeParsers();
        private final Map<Descriptors.Descriptor, Map<String, Descriptors.FieldDescriptor>> fieldNameMaps = new HashMap<Descriptors.Descriptor, Map<String, Descriptors.FieldDescriptor>>();
        private static final BigInteger MAX_UINT64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        private static final double EPSILON = 1.0E-6;
        private static final BigDecimal MORE_THAN_ONE = new BigDecimal(String.valueOf(1.000001));
        private static final BigDecimal MAX_DOUBLE = new BigDecimal(String.valueOf(Double.MAX_VALUE)).multiply(MORE_THAN_ONE);
        private static final BigDecimal MIN_DOUBLE = new BigDecimal(String.valueOf(-1.7976931348623157E308)).multiply(MORE_THAN_ONE);

        ParserImpl(TypeRegistry typeRegistry, boolean bl, int n) {
            this.registry = typeRegistry;
            this.ignoringUnknownFields = bl;
            this.jsonParser = new JsonParser();
            this.recursionLimit = n;
            this.currentDepth = 0;
        }

        void merge(Reader reader, Message.Builder builder) throws IOException {
            try {
                JsonReader jsonReader = new JsonReader(reader);
                jsonReader.setLenient(false);
                this.merge(this.jsonParser.parse(jsonReader), builder);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (JsonIOException jsonIOException) {
                if (jsonIOException.getCause() instanceof IOException) {
                    throw (IOException)jsonIOException.getCause();
                }
                throw new InvalidProtocolBufferException(jsonIOException.getMessage());
            }
            catch (Exception exception) {
                throw new InvalidProtocolBufferException(exception.getMessage());
            }
        }

        void merge(String string, Message.Builder builder) throws InvalidProtocolBufferException {
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
                jsonReader.setLenient(false);
                this.merge(this.jsonParser.parse(jsonReader), builder);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (Exception exception) {
                throw new InvalidProtocolBufferException(exception.getMessage());
            }
        }

        private static Map<String, WellKnownTypeParser> buildWellKnownTypeParsers() {
            HashMap<String, WellKnownTypeParser> hashMap = new HashMap<String, WellKnownTypeParser>();
            hashMap.put(Any.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeAny(jsonElement, builder);
                }
            });
            WellKnownTypeParser wellKnownTypeParser = new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeWrapper(jsonElement, builder);
                }
            };
            hashMap.put(BoolValue.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(Int32Value.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(UInt32Value.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(Int64Value.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(UInt64Value.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(StringValue.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(BytesValue.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(FloatValue.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(DoubleValue.getDescriptor().getFullName(), wellKnownTypeParser);
            hashMap.put(Timestamp.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeTimestamp(jsonElement, builder);
                }
            });
            hashMap.put(Duration.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeDuration(jsonElement, builder);
                }
            });
            hashMap.put(FieldMask.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeFieldMask(jsonElement, builder);
                }
            });
            hashMap.put(Struct.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeStruct(jsonElement, builder);
                }
            });
            hashMap.put(ListValue.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeListValue(jsonElement, builder);
                }
            });
            hashMap.put(Value.getDescriptor().getFullName(), new WellKnownTypeParser(){

                @Override
                public void merge(ParserImpl parserImpl, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
                    parserImpl.mergeValue(jsonElement, builder);
                }
            });
            return hashMap;
        }

        private void merge(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            WellKnownTypeParser wellKnownTypeParser = wellKnownTypeParsers.get(builder.getDescriptorForType().getFullName());
            if (wellKnownTypeParser != null) {
                wellKnownTypeParser.merge(this, jsonElement, builder);
                return;
            }
            this.mergeMessage(jsonElement, builder, false);
        }

        private Map<String, Descriptors.FieldDescriptor> getFieldNameMap(Descriptors.Descriptor descriptor) {
            if (!this.fieldNameMaps.containsKey(descriptor)) {
                HashMap<String, Descriptors.FieldDescriptor> hashMap = new HashMap<String, Descriptors.FieldDescriptor>();
                for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                    hashMap.put(fieldDescriptor.getName(), fieldDescriptor);
                    hashMap.put(fieldDescriptor.getJsonName(), fieldDescriptor);
                }
                this.fieldNameMaps.put(descriptor, hashMap);
                return hashMap;
            }
            return this.fieldNameMaps.get(descriptor);
        }

        private void mergeMessage(JsonElement jsonElement, Message.Builder builder, boolean bl) throws InvalidProtocolBufferException {
            if (!(jsonElement instanceof JsonObject)) {
                throw new InvalidProtocolBufferException("Expect message object but got: " + jsonElement);
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            Map<String, Descriptors.FieldDescriptor> map = this.getFieldNameMap(builder.getDescriptorForType());
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (bl && ((String)entry.getKey()).equals("@type")) continue;
                Descriptors.FieldDescriptor fieldDescriptor = map.get(entry.getKey());
                if (fieldDescriptor == null) {
                    if (this.ignoringUnknownFields) continue;
                    throw new InvalidProtocolBufferException("Cannot find field: " + (String)entry.getKey() + " in message " + builder.getDescriptorForType().getFullName());
                }
                this.mergeField(fieldDescriptor, (JsonElement)entry.getValue(), builder);
            }
        }

        private void mergeAny(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("type_url");
            Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("value");
            if (fieldDescriptor == null || fieldDescriptor2 == null || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.STRING || fieldDescriptor2.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
                throw new InvalidProtocolBufferException("Invalid Any type.");
            }
            if (!(jsonElement instanceof JsonObject)) {
                throw new InvalidProtocolBufferException("Expect message object but got: " + jsonElement);
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            if (jsonObject.entrySet().isEmpty()) {
                return;
            }
            JsonElement jsonElement2 = jsonObject.get("@type");
            if (jsonElement2 == null) {
                throw new InvalidProtocolBufferException("Missing type url when parsing: " + jsonElement);
            }
            String string = jsonElement2.getAsString();
            Descriptors.Descriptor descriptor2 = this.registry.find(JsonFormat.getTypeName(string));
            if (descriptor2 == null) {
                throw new InvalidProtocolBufferException("Cannot resolve type: " + string);
            }
            builder.setField(fieldDescriptor, (Object)string);
            DynamicMessage.Builder builder2 = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)descriptor2).newBuilderForType();
            WellKnownTypeParser wellKnownTypeParser = wellKnownTypeParsers.get(descriptor2.getFullName());
            if (wellKnownTypeParser != null) {
                JsonElement jsonElement3 = jsonObject.get("value");
                if (jsonElement3 != null) {
                    wellKnownTypeParser.merge(this, jsonElement3, (Message.Builder)builder2);
                }
            } else {
                this.mergeMessage(jsonElement, (Message.Builder)builder2, true);
            }
            builder.setField(fieldDescriptor2, (Object)builder2.build().toByteString());
        }

        private void mergeFieldMask(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            FieldMask fieldMask = FieldMaskUtil.fromJsonString(jsonElement.getAsString());
            builder.mergeFrom(fieldMask.toByteString());
        }

        private void mergeTimestamp(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            try {
                Timestamp timestamp = Timestamps.parse(jsonElement.getAsString());
                builder.mergeFrom(timestamp.toByteString());
            }
            catch (ParseException parseException) {
                throw new InvalidProtocolBufferException("Failed to parse timestamp: " + jsonElement);
            }
        }

        private void mergeDuration(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            try {
                Duration duration = Durations.parse(jsonElement.getAsString());
                builder.mergeFrom(duration.toByteString());
            }
            catch (ParseException parseException) {
                throw new InvalidProtocolBufferException("Failed to parse duration: " + jsonElement);
            }
        }

        private void mergeStruct(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("fields");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid Struct type.");
            }
            this.mergeMapField(fieldDescriptor, jsonElement, builder);
        }

        private void mergeListValue(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("values");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid ListValue type.");
            }
            this.mergeRepeatedField(fieldDescriptor, jsonElement, builder);
        }

        private void mergeValue(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                if (jsonPrimitive.isBoolean()) {
                    builder.setField(descriptor.findFieldByName("bool_value"), (Object)jsonPrimitive.getAsBoolean());
                } else if (jsonPrimitive.isNumber()) {
                    builder.setField(descriptor.findFieldByName("number_value"), (Object)jsonPrimitive.getAsDouble());
                } else {
                    builder.setField(descriptor.findFieldByName("string_value"), (Object)jsonPrimitive.getAsString());
                }
            } else if (jsonElement instanceof JsonObject) {
                Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("struct_value");
                Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                this.merge(jsonElement, builder2);
                builder.setField(fieldDescriptor, (Object)builder2.build());
            } else if (jsonElement instanceof JsonArray) {
                Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("list_value");
                Message.Builder builder3 = builder.newBuilderForField(fieldDescriptor);
                this.merge(jsonElement, builder3);
                builder.setField(fieldDescriptor, (Object)builder3.build());
            } else if (jsonElement instanceof JsonNull) {
                builder.setField(descriptor.findFieldByName("null_value"), (Object)NullValue.NULL_VALUE.getValueDescriptor());
            } else {
                throw new IllegalStateException("Unexpected json data: " + jsonElement);
            }
        }

        private void mergeWrapper(JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("value");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid wrapper type: " + descriptor.getFullName());
            }
            builder.setField(fieldDescriptor, this.parseFieldValue(fieldDescriptor, jsonElement, builder));
        }

        private void mergeField(Descriptors.FieldDescriptor fieldDescriptor, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            if (fieldDescriptor.isRepeated()) {
                if (builder.getRepeatedFieldCount(fieldDescriptor) > 0) {
                    throw new InvalidProtocolBufferException("Field " + fieldDescriptor.getFullName() + " has already been set.");
                }
            } else {
                if (builder.hasField(fieldDescriptor)) {
                    throw new InvalidProtocolBufferException("Field " + fieldDescriptor.getFullName() + " has already been set.");
                }
                if (fieldDescriptor.getContainingOneof() != null && builder.getOneofFieldDescriptor(fieldDescriptor.getContainingOneof()) != null) {
                    Descriptors.FieldDescriptor fieldDescriptor2 = builder.getOneofFieldDescriptor(fieldDescriptor.getContainingOneof());
                    throw new InvalidProtocolBufferException("Cannot set field " + fieldDescriptor.getFullName() + " because another field " + fieldDescriptor2.getFullName() + " belonging to the same oneof has already been set ");
                }
            }
            if (fieldDescriptor.isRepeated() && jsonElement instanceof JsonNull) {
                return;
            }
            if (fieldDescriptor.isMapField()) {
                this.mergeMapField(fieldDescriptor, jsonElement, builder);
            } else if (fieldDescriptor.isRepeated()) {
                this.mergeRepeatedField(fieldDescriptor, jsonElement, builder);
            } else {
                Object object = this.parseFieldValue(fieldDescriptor, jsonElement, builder);
                if (object != null) {
                    builder.setField(fieldDescriptor, object);
                }
            }
        }

        private void mergeMapField(Descriptors.FieldDescriptor fieldDescriptor, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            if (!(jsonElement instanceof JsonObject)) {
                throw new InvalidProtocolBufferException("Expect a map object but found: " + jsonElement);
            }
            Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
            Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("key");
            Descriptors.FieldDescriptor fieldDescriptor3 = descriptor.findFieldByName("value");
            if (fieldDescriptor2 == null || fieldDescriptor3 == null) {
                throw new InvalidProtocolBufferException("Invalid map field: " + fieldDescriptor.getFullName());
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            for (Map.Entry entry : jsonObject.entrySet()) {
                Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                Object object = this.parseFieldValue(fieldDescriptor2, (JsonElement)new JsonPrimitive((String)entry.getKey()), builder2);
                Object object2 = this.parseFieldValue(fieldDescriptor3, (JsonElement)entry.getValue(), builder2);
                if (object2 == null) {
                    throw new InvalidProtocolBufferException("Map value cannot be null.");
                }
                builder2.setField(fieldDescriptor2, object);
                builder2.setField(fieldDescriptor3, object2);
                builder.addRepeatedField(fieldDescriptor, (Object)builder2.build());
            }
        }

        private void mergeRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            if (!(jsonElement instanceof JsonArray)) {
                throw new InvalidProtocolBufferException("Expect an array but found: " + jsonElement);
            }
            JsonArray jsonArray = (JsonArray)jsonElement;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = this.parseFieldValue(fieldDescriptor, jsonArray.get(i), builder);
                if (object == null) {
                    throw new InvalidProtocolBufferException("Repeated field elements cannot be null");
                }
                builder.addRepeatedField(fieldDescriptor, object);
            }
        }

        private int parseInt32(JsonElement jsonElement) throws InvalidProtocolBufferException {
            try {
                return Integer.parseInt(jsonElement.getAsString());
            }
            catch (Exception exception) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(jsonElement.getAsString());
                    return bigDecimal.intValueExact();
                }
                catch (Exception exception2) {
                    throw new InvalidProtocolBufferException("Not an int32 value: " + jsonElement);
                }
            }
        }

        private long parseInt64(JsonElement jsonElement) throws InvalidProtocolBufferException {
            try {
                return Long.parseLong(jsonElement.getAsString());
            }
            catch (Exception exception) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(jsonElement.getAsString());
                    return bigDecimal.longValueExact();
                }
                catch (Exception exception2) {
                    throw new InvalidProtocolBufferException("Not an int64 value: " + jsonElement);
                }
            }
        }

        private int parseUint32(JsonElement jsonElement) throws InvalidProtocolBufferException {
            try {
                long l = Long.parseLong(jsonElement.getAsString());
                if (l < 0L || l > 0xFFFFFFFFL) {
                    throw new InvalidProtocolBufferException("Out of range uint32 value: " + jsonElement);
                }
                return (int)l;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (Exception exception) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(jsonElement.getAsString());
                    BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                    if (bigInteger.signum() < 0 || bigInteger.compareTo(new BigInteger("FFFFFFFF", 16)) > 0) {
                        throw new InvalidProtocolBufferException("Out of range uint32 value: " + jsonElement);
                    }
                    return bigInteger.intValue();
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw invalidProtocolBufferException;
                }
                catch (Exception exception2) {
                    throw new InvalidProtocolBufferException("Not an uint32 value: " + jsonElement);
                }
            }
        }

        private long parseUint64(JsonElement jsonElement) throws InvalidProtocolBufferException {
            try {
                BigDecimal bigDecimal = new BigDecimal(jsonElement.getAsString());
                BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(MAX_UINT64) > 0) {
                    throw new InvalidProtocolBufferException("Out of range uint64 value: " + jsonElement);
                }
                return bigInteger.longValue();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (Exception exception) {
                throw new InvalidProtocolBufferException("Not an uint64 value: " + jsonElement);
            }
        }

        private boolean parseBool(JsonElement jsonElement) throws InvalidProtocolBufferException {
            if (jsonElement.getAsString().equals("true")) {
                return true;
            }
            if (jsonElement.getAsString().equals("false")) {
                return false;
            }
            throw new InvalidProtocolBufferException("Invalid bool value: " + jsonElement);
        }

        private float parseFloat(JsonElement jsonElement) throws InvalidProtocolBufferException {
            if (jsonElement.getAsString().equals("NaN")) {
                return Float.NaN;
            }
            if (jsonElement.getAsString().equals("Infinity")) {
                return Float.POSITIVE_INFINITY;
            }
            if (jsonElement.getAsString().equals("-Infinity")) {
                return Float.NEGATIVE_INFINITY;
            }
            try {
                double d = Double.parseDouble(jsonElement.getAsString());
                if (d > 3.402826869208755E38 || d < -3.402826869208755E38) {
                    throw new InvalidProtocolBufferException("Out of range float value: " + jsonElement);
                }
                return (float)d;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (Exception exception) {
                throw new InvalidProtocolBufferException("Not a float value: " + jsonElement);
            }
        }

        private double parseDouble(JsonElement jsonElement) throws InvalidProtocolBufferException {
            if (jsonElement.getAsString().equals("NaN")) {
                return Double.NaN;
            }
            if (jsonElement.getAsString().equals("Infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (jsonElement.getAsString().equals("-Infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(jsonElement.getAsString());
                if (bigDecimal.compareTo(MAX_DOUBLE) > 0 || bigDecimal.compareTo(MIN_DOUBLE) < 0) {
                    throw new InvalidProtocolBufferException("Out of range double value: " + jsonElement);
                }
                return bigDecimal.doubleValue();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (Exception exception) {
                throw new InvalidProtocolBufferException("Not an double value: " + jsonElement);
            }
        }

        private String parseString(JsonElement jsonElement) {
            return jsonElement.getAsString();
        }

        private ByteString parseBytes(JsonElement jsonElement) throws InvalidProtocolBufferException {
            try {
                return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)jsonElement.getAsString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return ByteString.copyFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)jsonElement.getAsString()));
            }
        }

        private Descriptors.EnumValueDescriptor parseEnum(Descriptors.EnumDescriptor enumDescriptor, JsonElement jsonElement) throws InvalidProtocolBufferException {
            String string = jsonElement.getAsString();
            Descriptors.EnumValueDescriptor enumValueDescriptor = enumDescriptor.findValueByName(string);
            if (enumValueDescriptor == null) {
                try {
                    int n = this.parseInt32(jsonElement);
                    enumValueDescriptor = enumDescriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3 ? enumDescriptor.findValueByNumberCreatingIfUnknown(n) : enumDescriptor.findValueByNumber(n);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    // empty catch block
                }
                if (enumValueDescriptor == null) {
                    throw new InvalidProtocolBufferException("Invalid enum value: " + string + " for enum type: " + enumDescriptor.getFullName());
                }
            }
            return enumValueDescriptor;
        }

        private Object parseFieldValue(Descriptors.FieldDescriptor fieldDescriptor, JsonElement jsonElement, Message.Builder builder) throws InvalidProtocolBufferException {
            if (jsonElement instanceof JsonNull) {
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && fieldDescriptor.getMessageType().getFullName().equals(Value.getDescriptor().getFullName())) {
                    Value value = Value.newBuilder().setNullValueValue(0).build();
                    return builder.newBuilderForField(fieldDescriptor).mergeFrom(value.toByteString()).build();
                }
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && fieldDescriptor.getEnumType().getFullName().equals(NullValue.getDescriptor().getFullName())) {
                    return fieldDescriptor.getEnumType().findValueByNumber(0);
                }
                return null;
            }
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    return this.parseInt32(jsonElement);
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    return this.parseInt64(jsonElement);
                }
                case BOOL: {
                    return this.parseBool(jsonElement);
                }
                case FLOAT: {
                    return Float.valueOf(this.parseFloat(jsonElement));
                }
                case DOUBLE: {
                    return this.parseDouble(jsonElement);
                }
                case UINT32: 
                case FIXED32: {
                    return this.parseUint32(jsonElement);
                }
                case UINT64: 
                case FIXED64: {
                    return this.parseUint64(jsonElement);
                }
                case STRING: {
                    return this.parseString(jsonElement);
                }
                case BYTES: {
                    return this.parseBytes(jsonElement);
                }
                case ENUM: {
                    return this.parseEnum(fieldDescriptor.getEnumType(), jsonElement);
                }
                case MESSAGE: 
                case GROUP: {
                    if (this.currentDepth >= this.recursionLimit) {
                        throw new InvalidProtocolBufferException("Hit recursion limit.");
                    }
                    ++this.currentDepth;
                    Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                    this.merge(jsonElement, builder2);
                    --this.currentDepth;
                    return builder2.build();
                }
            }
            throw new InvalidProtocolBufferException("Invalid field type: " + fieldDescriptor.getType());
        }

        private static interface WellKnownTypeParser {
            public void merge(ParserImpl var1, JsonElement var2, Message.Builder var3) throws InvalidProtocolBufferException;
        }
    }

    private static final class PrinterImpl {
        private final TypeRegistry registry;
        private final boolean alwaysOutputDefaultValueFields;
        private final Set<Descriptors.FieldDescriptor> includingDefaultValueFields;
        private final boolean preservingProtoFieldNames;
        private final TextGenerator generator;
        private final Gson gson;
        private final CharSequence blankOrSpace;
        private final CharSequence blankOrNewLine;
        private static final Map<String, WellKnownTypePrinter> wellKnownTypePrinters = PrinterImpl.buildWellKnownTypePrinters();

        PrinterImpl(TypeRegistry typeRegistry, boolean bl, Set<Descriptors.FieldDescriptor> set, boolean bl2, Appendable appendable, boolean bl3) {
            this.registry = typeRegistry;
            this.alwaysOutputDefaultValueFields = bl;
            this.includingDefaultValueFields = set;
            this.preservingProtoFieldNames = bl2;
            this.gson = GsonHolder.DEFAULT_GSON;
            if (bl3) {
                this.generator = new CompactTextGenerator(appendable);
                this.blankOrSpace = "";
                this.blankOrNewLine = "";
            } else {
                this.generator = new PrettyTextGenerator(appendable);
                this.blankOrSpace = " ";
                this.blankOrNewLine = "\n";
            }
        }

        void print(MessageOrBuilder messageOrBuilder) throws IOException {
            WellKnownTypePrinter wellKnownTypePrinter = wellKnownTypePrinters.get(messageOrBuilder.getDescriptorForType().getFullName());
            if (wellKnownTypePrinter != null) {
                wellKnownTypePrinter.print(this, messageOrBuilder);
                return;
            }
            this.print(messageOrBuilder, null);
        }

        private static Map<String, WellKnownTypePrinter> buildWellKnownTypePrinters() {
            HashMap<String, WellKnownTypePrinter> hashMap = new HashMap<String, WellKnownTypePrinter>();
            hashMap.put(Any.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printAny(messageOrBuilder);
                }
            });
            WellKnownTypePrinter wellKnownTypePrinter = new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printWrapper(messageOrBuilder);
                }
            };
            hashMap.put(BoolValue.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(Int32Value.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(UInt32Value.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(Int64Value.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(UInt64Value.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(StringValue.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(BytesValue.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(FloatValue.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(DoubleValue.getDescriptor().getFullName(), wellKnownTypePrinter);
            hashMap.put(Timestamp.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printTimestamp(messageOrBuilder);
                }
            });
            hashMap.put(Duration.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printDuration(messageOrBuilder);
                }
            });
            hashMap.put(FieldMask.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printFieldMask(messageOrBuilder);
                }
            });
            hashMap.put(Struct.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printStruct(messageOrBuilder);
                }
            });
            hashMap.put(Value.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printValue(messageOrBuilder);
                }
            });
            hashMap.put(ListValue.getDescriptor().getFullName(), new WellKnownTypePrinter(){

                @Override
                public void print(PrinterImpl printerImpl, MessageOrBuilder messageOrBuilder) throws IOException {
                    printerImpl.printListValue(messageOrBuilder);
                }
            });
            return hashMap;
        }

        private void printAny(MessageOrBuilder messageOrBuilder) throws IOException {
            if (Any.getDefaultInstance().equals((Object)messageOrBuilder)) {
                this.generator.print("{}");
                return;
            }
            Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("type_url");
            Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("value");
            if (fieldDescriptor == null || fieldDescriptor2 == null || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.STRING || fieldDescriptor2.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
                throw new InvalidProtocolBufferException("Invalid Any type.");
            }
            String string = (String)messageOrBuilder.getField(fieldDescriptor);
            String string2 = JsonFormat.getTypeName(string);
            Descriptors.Descriptor descriptor2 = this.registry.find(string2);
            if (descriptor2 == null) {
                throw new InvalidProtocolBufferException("Cannot find type for url: " + string);
            }
            ByteString byteString = (ByteString)messageOrBuilder.getField(fieldDescriptor2);
            Message message = (Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)descriptor2).getParserForType().parseFrom(byteString);
            WellKnownTypePrinter wellKnownTypePrinter = wellKnownTypePrinters.get(string2);
            if (wellKnownTypePrinter != null) {
                this.generator.print("{" + this.blankOrNewLine);
                this.generator.indent();
                this.generator.print("\"@type\":" + this.blankOrSpace + this.gson.toJson((Object)string) + "," + this.blankOrNewLine);
                this.generator.print("\"value\":" + this.blankOrSpace);
                wellKnownTypePrinter.print(this, (MessageOrBuilder)message);
                this.generator.print(this.blankOrNewLine);
                this.generator.outdent();
                this.generator.print("}");
            } else {
                this.print((MessageOrBuilder)message, string);
            }
        }

        private void printWrapper(MessageOrBuilder messageOrBuilder) throws IOException {
            Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("value");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid Wrapper type.");
            }
            this.printSingleFieldValue(fieldDescriptor, messageOrBuilder.getField(fieldDescriptor));
        }

        private ByteString toByteString(MessageOrBuilder messageOrBuilder) {
            if (messageOrBuilder instanceof Message) {
                return ((Message)messageOrBuilder).toByteString();
            }
            return ((Message.Builder)messageOrBuilder).build().toByteString();
        }

        private void printTimestamp(MessageOrBuilder messageOrBuilder) throws IOException {
            Timestamp timestamp = Timestamp.parseFrom((ByteString)this.toByteString(messageOrBuilder));
            this.generator.print("\"" + Timestamps.toString(timestamp) + "\"");
        }

        private void printDuration(MessageOrBuilder messageOrBuilder) throws IOException {
            Duration duration = Duration.parseFrom((ByteString)this.toByteString(messageOrBuilder));
            this.generator.print("\"" + Durations.toString(duration) + "\"");
        }

        private void printFieldMask(MessageOrBuilder messageOrBuilder) throws IOException {
            FieldMask fieldMask = FieldMask.parseFrom((ByteString)this.toByteString(messageOrBuilder));
            this.generator.print("\"" + FieldMaskUtil.toJsonString(fieldMask) + "\"");
        }

        private void printStruct(MessageOrBuilder messageOrBuilder) throws IOException {
            Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("fields");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid Struct type.");
            }
            this.printMapFieldValue(fieldDescriptor, messageOrBuilder.getField(fieldDescriptor));
        }

        private void printValue(MessageOrBuilder messageOrBuilder) throws IOException {
            Map map = messageOrBuilder.getAllFields();
            if (map.isEmpty()) {
                this.generator.print("null");
                return;
            }
            if (map.size() != 1) {
                throw new InvalidProtocolBufferException("Invalid Value type.");
            }
            for (Map.Entry entry : map.entrySet()) {
                this.printSingleFieldValue((Descriptors.FieldDescriptor)entry.getKey(), entry.getValue());
            }
        }

        private void printListValue(MessageOrBuilder messageOrBuilder) throws IOException {
            Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("values");
            if (fieldDescriptor == null) {
                throw new InvalidProtocolBufferException("Invalid ListValue type.");
            }
            this.printRepeatedFieldValue(fieldDescriptor, messageOrBuilder.getField(fieldDescriptor));
        }

        private void print(MessageOrBuilder messageOrBuilder, String string) throws IOException {
            this.generator.print("{" + this.blankOrNewLine);
            this.generator.indent();
            boolean bl = false;
            if (string != null) {
                this.generator.print("\"@type\":" + this.blankOrSpace + this.gson.toJson((Object)string));
                bl = true;
            }
            Map<Descriptors.FieldDescriptor, Object> map = null;
            if (this.alwaysOutputDefaultValueFields || !this.includingDefaultValueFields.isEmpty()) {
                map = new TreeMap(messageOrBuilder.getAllFields());
                for (Descriptors.FieldDescriptor fieldDescriptor : messageOrBuilder.getDescriptorForType().getFields()) {
                    Descriptors.OneofDescriptor oneofDescriptor;
                    if (fieldDescriptor.isOptional() && (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !messageOrBuilder.hasField(fieldDescriptor) || (oneofDescriptor = fieldDescriptor.getContainingOneof()) != null && !messageOrBuilder.hasField(fieldDescriptor)) || map.containsKey(fieldDescriptor) || !this.alwaysOutputDefaultValueFields && !this.includingDefaultValueFields.contains(fieldDescriptor)) continue;
                    map.put(fieldDescriptor, messageOrBuilder.getField(fieldDescriptor));
                }
            } else {
                map = messageOrBuilder.getAllFields();
            }
            for (Map.Entry entry : map.entrySet()) {
                if (bl) {
                    this.generator.print("," + this.blankOrNewLine);
                } else {
                    bl = true;
                }
                this.printField((Descriptors.FieldDescriptor)entry.getKey(), entry.getValue());
            }
            if (bl) {
                this.generator.print(this.blankOrNewLine);
            }
            this.generator.outdent();
            this.generator.print("}");
        }

        private void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
            if (this.preservingProtoFieldNames) {
                this.generator.print("\"" + fieldDescriptor.getName() + "\":" + this.blankOrSpace);
            } else {
                this.generator.print("\"" + fieldDescriptor.getJsonName() + "\":" + this.blankOrSpace);
            }
            if (fieldDescriptor.isMapField()) {
                this.printMapFieldValue(fieldDescriptor, object);
            } else if (fieldDescriptor.isRepeated()) {
                this.printRepeatedFieldValue(fieldDescriptor, object);
            } else {
                this.printSingleFieldValue(fieldDescriptor, object);
            }
        }

        private void printRepeatedFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
            this.generator.print("[");
            boolean bl = false;
            for (Object e : (List)object) {
                if (bl) {
                    this.generator.print("," + this.blankOrSpace);
                } else {
                    bl = true;
                }
                this.printSingleFieldValue(fieldDescriptor, e);
            }
            this.generator.print("]");
        }

        private void printMapFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
            Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
            Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("key");
            Descriptors.FieldDescriptor fieldDescriptor3 = descriptor.findFieldByName("value");
            if (fieldDescriptor2 == null || fieldDescriptor3 == null) {
                throw new InvalidProtocolBufferException("Invalid map field.");
            }
            this.generator.print("{" + this.blankOrNewLine);
            this.generator.indent();
            boolean bl = false;
            for (Object e : (List)object) {
                Message message = (Message)e;
                Object object2 = message.getField(fieldDescriptor2);
                Object object3 = message.getField(fieldDescriptor3);
                if (bl) {
                    this.generator.print("," + this.blankOrNewLine);
                } else {
                    bl = true;
                }
                this.printSingleFieldValue(fieldDescriptor2, object2, true);
                this.generator.print(":" + this.blankOrSpace);
                this.printSingleFieldValue(fieldDescriptor3, object3);
            }
            if (bl) {
                this.generator.print(this.blankOrNewLine);
            }
            this.generator.outdent();
            this.generator.print("}");
        }

        private void printSingleFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
            this.printSingleFieldValue(fieldDescriptor, object, false);
        }

        private void printSingleFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, boolean bl) throws IOException {
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    if (bl) {
                        this.generator.print("\"");
                    }
                    this.generator.print(((Integer)object).toString());
                    if (!bl) break;
                    this.generator.print("\"");
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    this.generator.print("\"" + ((Long)object).toString() + "\"");
                    break;
                }
                case BOOL: {
                    if (bl) {
                        this.generator.print("\"");
                    }
                    if (((Boolean)object).booleanValue()) {
                        this.generator.print("true");
                    } else {
                        this.generator.print("false");
                    }
                    if (!bl) break;
                    this.generator.print("\"");
                    break;
                }
                case FLOAT: {
                    Float f = (Float)object;
                    if (f.isNaN()) {
                        this.generator.print("\"NaN\"");
                        break;
                    }
                    if (f.isInfinite()) {
                        if (f.floatValue() < 0.0f) {
                            this.generator.print("\"-Infinity\"");
                            break;
                        }
                        this.generator.print("\"Infinity\"");
                        break;
                    }
                    if (bl) {
                        this.generator.print("\"");
                    }
                    this.generator.print(f.toString());
                    if (!bl) break;
                    this.generator.print("\"");
                    break;
                }
                case DOUBLE: {
                    Double d = (Double)object;
                    if (d.isNaN()) {
                        this.generator.print("\"NaN\"");
                        break;
                    }
                    if (d.isInfinite()) {
                        if (d < 0.0) {
                            this.generator.print("\"-Infinity\"");
                            break;
                        }
                        this.generator.print("\"Infinity\"");
                        break;
                    }
                    if (bl) {
                        this.generator.print("\"");
                    }
                    this.generator.print(d.toString());
                    if (!bl) break;
                    this.generator.print("\"");
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    if (bl) {
                        this.generator.print("\"");
                    }
                    this.generator.print(JsonFormat.unsignedToString((Integer)object));
                    if (!bl) break;
                    this.generator.print("\"");
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    this.generator.print("\"" + JsonFormat.unsignedToString((Long)object) + "\"");
                    break;
                }
                case STRING: {
                    this.generator.print(this.gson.toJson(object));
                    break;
                }
                case BYTES: {
                    this.generator.print("\"");
                    this.generator.print(BaseEncoding.base64().encode(((ByteString)object).toByteArray()));
                    this.generator.print("\"");
                    break;
                }
                case ENUM: {
                    if (fieldDescriptor.getEnumType().getFullName().equals("google.protobuf.NullValue")) {
                        if (bl) {
                            this.generator.print("\"");
                        }
                        this.generator.print("null");
                        if (!bl) break;
                        this.generator.print("\"");
                        break;
                    }
                    if (((Descriptors.EnumValueDescriptor)object).getIndex() == -1) {
                        this.generator.print(String.valueOf(((Descriptors.EnumValueDescriptor)object).getNumber()));
                        break;
                    }
                    this.generator.print("\"" + ((Descriptors.EnumValueDescriptor)object).getName() + "\"");
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((MessageOrBuilder)((Message)object));
                }
            }
        }

        private static interface WellKnownTypePrinter {
            public void print(PrinterImpl var1, MessageOrBuilder var2) throws IOException;
        }

        private static class GsonHolder {
            private static final Gson DEFAULT_GSON = new GsonBuilder().disableHtmlEscaping().create();

            private GsonHolder() {
            }
        }
    }

    private static final class PrettyTextGenerator
    implements TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private PrettyTextGenerator(Appendable appendable) {
            this.output = appendable;
        }

        @Override
        public void indent() {
            this.indent.append("  ");
        }

        @Override
        public void outdent() {
            int n = this.indent.length();
            if (n < 2) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(n - 2, n);
        }

        @Override
        public void print(CharSequence charSequence) throws IOException {
            int n = charSequence.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) != '\n') continue;
                this.write(charSequence.subSequence(n2, i + 1));
                n2 = i + 1;
                this.atStartOfLine = true;
            }
            this.write(charSequence.subSequence(n2, n));
        }

        private void write(CharSequence charSequence) throws IOException {
            if (charSequence.length() == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(charSequence);
        }
    }

    private static final class CompactTextGenerator
    implements TextGenerator {
        private final Appendable output;

        private CompactTextGenerator(Appendable appendable) {
            this.output = appendable;
        }

        @Override
        public void indent() {
        }

        @Override
        public void outdent() {
        }

        @Override
        public void print(CharSequence charSequence) throws IOException {
            this.output.append(charSequence);
        }
    }

    static interface TextGenerator {
        public void indent();

        public void outdent();

        public void print(CharSequence var1) throws IOException;
    }

    public static class TypeRegistry {
        private final Map<String, Descriptors.Descriptor> types;

        public static TypeRegistry getEmptyTypeRegistry() {
            return EmptyTypeRegistryHolder.EMPTY;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Descriptors.Descriptor find(String string) {
            return this.types.get(string);
        }

        private TypeRegistry(Map<String, Descriptors.Descriptor> map) {
            this.types = map;
        }

        public static class Builder {
            private final Set<String> files = new HashSet<String>();
            private Map<String, Descriptors.Descriptor> types = new HashMap<String, Descriptors.Descriptor>();

            private Builder() {
            }

            public Builder add(Descriptors.Descriptor descriptor) {
                if (this.types == null) {
                    throw new IllegalStateException("A TypeRegistry.Builer can only be used once.");
                }
                this.addFile(descriptor.getFile());
                return this;
            }

            public Builder add(Iterable<Descriptors.Descriptor> iterable) {
                if (this.types == null) {
                    throw new IllegalStateException("A TypeRegistry.Builer can only be used once.");
                }
                for (Descriptors.Descriptor descriptor : iterable) {
                    this.addFile(descriptor.getFile());
                }
                return this;
            }

            public TypeRegistry build() {
                TypeRegistry typeRegistry = new TypeRegistry(this.types);
                this.types = null;
                return typeRegistry;
            }

            private void addFile(Descriptors.FileDescriptor fileDescriptor) {
                if (!this.files.add(fileDescriptor.getFullName())) {
                    return;
                }
                for (Descriptors.FileDescriptor fileDescriptor2 : fileDescriptor.getDependencies()) {
                    this.addFile(fileDescriptor2);
                }
                for (Descriptors.FileDescriptor fileDescriptor2 : fileDescriptor.getMessageTypes()) {
                    this.addMessage((Descriptors.Descriptor)fileDescriptor2);
                }
            }

            private void addMessage(Descriptors.Descriptor descriptor) {
                for (Descriptors.Descriptor descriptor2 : descriptor.getNestedTypes()) {
                    this.addMessage(descriptor2);
                }
                if (this.types.containsKey(descriptor.getFullName())) {
                    logger.warning("Type " + descriptor.getFullName() + " is added multiple times.");
                    return;
                }
                this.types.put(descriptor.getFullName(), descriptor);
            }
        }

        private static class EmptyTypeRegistryHolder {
            private static final TypeRegistry EMPTY = new TypeRegistry(Collections.emptyMap());

            private EmptyTypeRegistryHolder() {
            }
        }
    }

    public static class Parser {
        private final TypeRegistry registry;
        private final boolean ignoringUnknownFields;
        private final int recursionLimit;
        private static final int DEFAULT_RECURSION_LIMIT = 100;

        private Parser(TypeRegistry typeRegistry, boolean bl, int n) {
            this.registry = typeRegistry;
            this.ignoringUnknownFields = bl;
            this.recursionLimit = n;
        }

        public Parser usingTypeRegistry(TypeRegistry typeRegistry) {
            if (this.registry != TypeRegistry.getEmptyTypeRegistry()) {
                throw new IllegalArgumentException("Only one registry is allowed.");
            }
            return new Parser(typeRegistry, this.ignoringUnknownFields, this.recursionLimit);
        }

        public Parser ignoringUnknownFields() {
            return new Parser(this.registry, true, this.recursionLimit);
        }

        public void merge(String string, Message.Builder builder) throws InvalidProtocolBufferException {
            new ParserImpl(this.registry, this.ignoringUnknownFields, this.recursionLimit).merge(string, builder);
        }

        public void merge(Reader reader, Message.Builder builder) throws IOException {
            new ParserImpl(this.registry, this.ignoringUnknownFields, this.recursionLimit).merge(reader, builder);
        }

        Parser usingRecursionLimit(int n) {
            return new Parser(this.registry, this.ignoringUnknownFields, n);
        }
    }

    public static class Printer {
        private final TypeRegistry registry;
        private boolean alwaysOutputDefaultValueFields;
        private Set<Descriptors.FieldDescriptor> includingDefaultValueFields;
        private final boolean preservingProtoFieldNames;
        private final boolean omittingInsignificantWhitespace;

        private Printer(TypeRegistry typeRegistry, boolean bl, Set<Descriptors.FieldDescriptor> set, boolean bl2, boolean bl3) {
            this.registry = typeRegistry;
            this.alwaysOutputDefaultValueFields = bl;
            this.includingDefaultValueFields = set;
            this.preservingProtoFieldNames = bl2;
            this.omittingInsignificantWhitespace = bl3;
        }

        public Printer usingTypeRegistry(TypeRegistry typeRegistry) {
            if (this.registry != TypeRegistry.getEmptyTypeRegistry()) {
                throw new IllegalArgumentException("Only one registry is allowed.");
            }
            return new Printer(typeRegistry, this.alwaysOutputDefaultValueFields, this.includingDefaultValueFields, this.preservingProtoFieldNames, this.omittingInsignificantWhitespace);
        }

        public Printer includingDefaultValueFields() {
            this.checkUnsetIncludingDefaultValueFields();
            return new Printer(this.registry, true, Collections.<Descriptors.FieldDescriptor>emptySet(), this.preservingProtoFieldNames, this.omittingInsignificantWhitespace);
        }

        public Printer includingDefaultValueFields(Set<Descriptors.FieldDescriptor> set) {
            Preconditions.checkArgument((null != set && !set.isEmpty() ? 1 : 0) != 0, (Object)"Non-empty Set must be supplied for includingDefaultValueFields.");
            this.checkUnsetIncludingDefaultValueFields();
            return new Printer(this.registry, false, set, this.preservingProtoFieldNames, this.omittingInsignificantWhitespace);
        }

        private void checkUnsetIncludingDefaultValueFields() {
            if (this.alwaysOutputDefaultValueFields || !this.includingDefaultValueFields.isEmpty()) {
                throw new IllegalStateException("JsonFormat includingDefaultValueFields has already been set.");
            }
        }

        public Printer preservingProtoFieldNames() {
            return new Printer(this.registry, this.alwaysOutputDefaultValueFields, this.includingDefaultValueFields, true, this.omittingInsignificantWhitespace);
        }

        public Printer omittingInsignificantWhitespace() {
            return new Printer(this.registry, this.alwaysOutputDefaultValueFields, this.includingDefaultValueFields, this.preservingProtoFieldNames, true);
        }

        public void appendTo(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
            new PrinterImpl(this.registry, this.alwaysOutputDefaultValueFields, this.includingDefaultValueFields, this.preservingProtoFieldNames, appendable, this.omittingInsignificantWhitespace).print(messageOrBuilder);
        }

        public String print(MessageOrBuilder messageOrBuilder) throws InvalidProtocolBufferException {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.appendTo(messageOrBuilder, stringBuilder);
                return stringBuilder.toString();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }
}

