/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import java.util.Arrays;

final class PartitionReplicaVersions {
    final int partitionId;
    final long[] versions = new long[6];

    PartitionReplicaVersions(int partitionId) {
        this.partitionId = partitionId;
    }

    long[] incrementAndGet(int backupCount) {
        int i = 0;
        while (i < backupCount) {
            int n = i++;
            this.versions[n] = this.versions[n] + 1L;
        }
        return this.versions;
    }

    long[] get() {
        return this.versions;
    }

    boolean isStale(long[] newVersions, int currentReplica) {
        int index = currentReplica - 1;
        long currentVersion = this.versions[index];
        long newVersion = newVersions[index];
        return currentVersion > newVersion;
    }

    boolean update(long[] newVersions, int currentReplica) {
        boolean valid;
        int index = currentReplica - 1;
        long currentVersion = this.versions[index];
        long nextVersion = newVersions[index];
        boolean bl = valid = currentVersion == nextVersion - 1L;
        if (valid) {
            this.set(newVersions, currentReplica);
            currentVersion = nextVersion;
        }
        return currentVersion >= nextVersion;
    }

    void set(long[] newVersions, int fromReplica) {
        int fromIndex = fromReplica - 1;
        int len = newVersions.length - fromIndex;
        System.arraycopy(newVersions, fromIndex, this.versions, fromIndex, len);
    }

    void clear() {
        for (int i = 0; i < this.versions.length; ++i) {
            this.versions[i] = 0L;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{partitionId=" + this.partitionId + ", versions=" + Arrays.toString(this.versions) + '}';
    }
}

