/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.map.impl.client.AbstractMapAddEntryListenerRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import java.io.IOException;

public class MapAddEntryListenerRequest
extends AbstractMapAddEntryListenerRequest {
    private Predicate predicate;

    public MapAddEntryListenerRequest() {
    }

    public MapAddEntryListenerRequest(String name, boolean includeValue, int listenerFlags) {
        super(name, includeValue, listenerFlags);
    }

    public MapAddEntryListenerRequest(String name, Data key, boolean includeValue, Predicate predicate, int listenerFlags) {
        super(name, key, includeValue, listenerFlags);
        this.predicate = predicate;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    protected Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("name", this.name);
        writer.writeBoolean("i", this.includeValue);
        writer.writeInt("lf", this.listenerFlags);
        boolean hasKey = this.key != null;
        writer.writeBoolean("key", hasKey);
        if (this.predicate == null) {
            writer.writeBoolean("pre", false);
            if (hasKey) {
                ObjectDataOutput out = writer.getRawDataOutput();
                out.writeData(this.key);
            }
        } else {
            writer.writeBoolean("pre", true);
            ObjectDataOutput out = writer.getRawDataOutput();
            out.writeObject(this.predicate);
            if (hasKey) {
                out.writeData(this.key);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("name");
        this.includeValue = reader.readBoolean("i");
        this.listenerFlags = reader.readInt("lf");
        boolean hasKey = reader.readBoolean("key");
        if (reader.readBoolean("pre")) {
            ObjectDataInput in = reader.getRawDataInput();
            this.predicate = (Predicate)in.readObject();
            if (hasKey) {
                this.key = in.readData();
            }
        } else if (hasKey) {
            ObjectDataInput in = reader.getRawDataInput();
            this.key = in.readData();
        }
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Object[] getParameters() {
        if (this.key == null && this.predicate == null) {
            return new Object[]{null, this.includeValue};
        }
        if (this.predicate == null) {
            return new Object[]{null, this.key, this.includeValue};
        }
        if (this.key == null) {
            return new Object[]{null, this.predicate, this.includeValue};
        }
        return new Object[]{null, this.predicate, this.key, this.includeValue};
    }
}

