/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MessageLite;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import com.google.protobuf.UninitializedMessageException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageLite<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
implements MessageLite {
    protected int memoizedHashCode = 0;

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(codedBuilder.getCodedOutput());
            return codedBuilder.build();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getSerializingExceptionMessage("ByteString"), iOException);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getSerializingExceptionMessage("byte array"), iOException);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        int n = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream outputStream) throws IOException {
        int n = this.getSerializedSize();
        int n2 = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(n) + n);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n2);
        codedOutputStream.writeRawVarint32(n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    private String getSerializingExceptionMessage(String string) {
        return "Serializing " + this.getClass().getName() + " to a " + string + " threw an IOException (should never happen).";
    }

    protected static void checkByteStringIsUtf8(ByteString byteString) throws IllegalArgumentException {
        if (!byteString.isValidUtf8()) {
            throw new IllegalArgumentException("Byte string is not UTF-8.");
        }
    }

    @Deprecated
    protected static <T> void addAll(Iterable<T> iterable, Collection<? super T> collection) {
        Builder.addAll(iterable, (List)collection);
    }

    protected static <T> void addAll(Iterable<T> iterable, List<? super T> list) {
        Builder.addAll(iterable, list);
    }

    public static abstract class Builder<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        public BuilderType mergeFrom(CodedInputStream codedInputStream) throws IOException {
            return (BuilderType)this.mergeFrom(codedInputStream, ExtensionRegistryLite.getEmptyRegistry());
        }

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

        public BuilderType mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
            }
        }

        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream, extensionRegistryLite);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
            }
        }

        public BuilderType mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(byArray, 0, byArray.length);
        }

        public BuilderType mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
            }
        }

        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(byArray, 0, byArray.length, extensionRegistryLite);
        }

        public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
                this.mergeFrom(codedInputStream, extensionRegistryLite);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
            }
        }

        public BuilderType mergeFrom(InputStream inputStream) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream, extensionRegistryLite);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                return false;
            }
            int n2 = CodedInputStream.readRawVarint32(n, inputStream);
            LimitedInputStream limitedInputStream = new LimitedInputStream(inputStream, n2);
            this.mergeFrom(limitedInputStream, extensionRegistryLite);
            return true;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            return this.mergeDelimitedFrom(inputStream, ExtensionRegistryLite.getEmptyRegistry());
        }

        public BuilderType mergeFrom(MessageLite messageLite) {
            if (!this.getDefaultInstanceForType().getClass().isInstance(messageLite)) {
                throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
            }
            return this.internalMergeFrom((AbstractMessageLite)messageLite);
        }

        protected abstract BuilderType internalMergeFrom(MessageType var1);

        private String getReadingExceptionMessage(String string) {
            return "Reading " + this.getClass().getName() + " from a " + string + " threw an IOException (should never happen).";
        }

        private static <T> void addAllCheckingNulls(Iterable<T> iterable, List<? super T> list) {
            if (list instanceof ArrayList && iterable instanceof Collection) {
                ((ArrayList)list).ensureCapacity(list.size() + ((Collection)iterable).size());
            }
            int n = list.size();
            for (T t : iterable) {
                if (t == null) {
                    String string = "Element at index " + (list.size() - n) + " is null.";
                    for (int i = list.size() - 1; i >= n; --i) {
                        list.remove(i);
                    }
                    throw new NullPointerException(string);
                }
                list.add(t);
            }
        }

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite messageLite) {
            return new UninitializedMessageException(messageLite);
        }

        @Deprecated
        protected static <T> void addAll(Iterable<T> iterable, Collection<? super T> collection) {
            Builder.addAll(iterable, (List)collection);
        }

        protected static <T> void addAll(Iterable<T> iterable, List<? super T> list) {
            Internal.checkNotNull(iterable);
            if (iterable instanceof LazyStringList) {
                List<?> list2 = ((LazyStringList)iterable).getUnderlyingElements();
                LazyStringList lazyStringList = (LazyStringList)list;
                int n = list.size();
                for (Object obj : list2) {
                    if (obj == null) {
                        String string = "Element at index " + (lazyStringList.size() - n) + " is null.";
                        for (int i = lazyStringList.size() - 1; i >= n; --i) {
                            lazyStringList.remove(i);
                        }
                        throw new NullPointerException(string);
                    }
                    if (obj instanceof ByteString) {
                        lazyStringList.add((ByteString)obj);
                        continue;
                    }
                    lazyStringList.add((String)obj);
                }
            } else if (iterable instanceof PrimitiveNonBoxingCollection) {
                list.addAll((Collection)iterable);
            } else {
                Builder.addAllCheckingNulls(iterable, list);
            }
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            LimitedInputStream(InputStream inputStream, int n) {
                super(inputStream);
                this.limit = n;
            }

            @Override
            public int available() throws IOException {
                return Math.min(super.available(), this.limit);
            }

            @Override
            public int read() throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n = super.read();
                if (n >= 0) {
                    --this.limit;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n3 = super.read(byArray, n, n2 = Math.min(n2, this.limit));
                if (n3 >= 0) {
                    this.limit -= n3;
                }
                return n3;
            }

            @Override
            public long skip(long l) throws IOException {
                long l2 = super.skip(Math.min(l, (long)this.limit));
                if (l2 >= 0L) {
                    this.limit = (int)((long)this.limit - l2);
                }
                return l2;
            }
        }
    }
}

