/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AtomicLongMapSubject;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.CustomSubjectBuilderFactory;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.SortedMapSubject;
import com.google.common.truth.SortedSetSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.util.concurrent.AtomicLongMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public class StandardSubjectBuilder {
    private final FailureMetadata metadataDoNotReferenceDirectly;

    public static StandardSubjectBuilder forCustomFailureStrategy(FailureStrategy failureStrategy) {
        return new StandardSubjectBuilder(FailureMetadata.forFailureStrategy(failureStrategy));
    }

    StandardSubjectBuilder(FailureMetadata metadata) {
        this.metadataDoNotReferenceDirectly = (FailureMetadata)Preconditions.checkNotNull((Object)metadata);
    }

    public final <ComparableT extends Comparable<?>> ComparableSubject<?, ComparableT> that(@Nullable ComparableT actual) {
        return new ComparableSubject(this.metadata(), actual){};
    }

    public final BigDecimalSubject that(@Nullable BigDecimal actual) {
        return new BigDecimalSubject(this.metadata(), actual);
    }

    public final Subject<DefaultSubject, Object> that(@Nullable Object actual) {
        return new DefaultSubject(this.metadata(), actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public final ClassSubject that(@Nullable Class<?> actual) {
        return new ClassSubject(this.metadata(), actual);
    }

    public final ThrowableSubject that(@Nullable Throwable actual) {
        return new ThrowableSubject(this.metadata(), actual);
    }

    public final LongSubject that(@Nullable Long actual) {
        return new LongSubject(this.metadata(), actual);
    }

    public final DoubleSubject that(@Nullable Double actual) {
        return new DoubleSubject(this.metadata(), actual);
    }

    public final FloatSubject that(@Nullable Float actual) {
        return new FloatSubject(this.metadata(), actual);
    }

    public final IntegerSubject that(@Nullable Integer actual) {
        return new IntegerSubject(this.metadata(), actual);
    }

    public final BooleanSubject that(@Nullable Boolean actual) {
        return new BooleanSubject(this.metadata(), actual);
    }

    public final StringSubject that(@Nullable String actual) {
        return new StringSubject(this.metadata(), actual);
    }

    public final IterableSubject that(@Nullable Iterable<?> actual) {
        return new IterableSubject(this.metadata(), actual);
    }

    public final SortedSetSubject that(@Nullable SortedSet<?> actual) {
        return new SortedSetSubject(this.metadata(), actual);
    }

    public final <T> ObjectArraySubject<T> that(@Nullable T[] actual) {
        return new ObjectArraySubject<T>(this.metadata(), actual);
    }

    public final PrimitiveBooleanArraySubject that(@Nullable boolean[] actual) {
        return new PrimitiveBooleanArraySubject(this.metadata(), actual);
    }

    public final PrimitiveShortArraySubject that(@Nullable short[] actual) {
        return new PrimitiveShortArraySubject(this.metadata(), actual);
    }

    public final PrimitiveIntArraySubject that(@Nullable int[] actual) {
        return new PrimitiveIntArraySubject(this.metadata(), actual);
    }

    public final PrimitiveLongArraySubject that(@Nullable long[] actual) {
        return new PrimitiveLongArraySubject(this.metadata(), actual);
    }

    public final PrimitiveCharArraySubject that(@Nullable char[] actual) {
        return new PrimitiveCharArraySubject(this.metadata(), actual);
    }

    public final PrimitiveByteArraySubject that(@Nullable byte[] actual) {
        return new PrimitiveByteArraySubject(this.metadata(), actual);
    }

    public final PrimitiveFloatArraySubject that(@Nullable float[] actual) {
        return new PrimitiveFloatArraySubject(this.metadata(), actual);
    }

    public final PrimitiveDoubleArraySubject that(@Nullable double[] actual) {
        return new PrimitiveDoubleArraySubject(this.metadata(), actual);
    }

    public final GuavaOptionalSubject that(@Nullable Optional<?> actual) {
        return new GuavaOptionalSubject(this.metadata(), actual);
    }

    public final MapSubject that(@Nullable Map<?, ?> actual) {
        return new MapSubject(this.metadata(), actual);
    }

    public final SortedMapSubject that(@Nullable SortedMap<?, ?> actual) {
        return new SortedMapSubject(this.metadata(), actual);
    }

    public final MultimapSubject that(@Nullable Multimap<?, ?> actual) {
        return new MultimapSubject(this.metadata(), actual);
    }

    public final ListMultimapSubject that(@Nullable ListMultimap<?, ?> actual) {
        return new ListMultimapSubject(this.metadata(), actual);
    }

    public final SetMultimapSubject that(@Nullable SetMultimap<?, ?> actual) {
        return new SetMultimapSubject(this.metadata(), actual);
    }

    public final MultisetSubject that(@Nullable Multiset<?> actual) {
        return new MultisetSubject(this.metadata(), actual);
    }

    public final TableSubject that(@Nullable Table<?, ?, ?> actual) {
        return new TableSubject(this.metadata(), actual);
    }

    public final AtomicLongMapSubject that(@Nullable AtomicLongMap<?> actual) {
        return new AtomicLongMapSubject(this.metadata(), actual);
    }

    public final StandardSubjectBuilder withMessage(@Nullable String messageToPrepend) {
        return this.withMessage("%s", messageToPrepend);
    }

    public final StandardSubjectBuilder withMessage(@Nullable String format, Object ... args) {
        return new StandardSubjectBuilder(this.metadata().withMessage(format, args));
    }

    @Deprecated
    public final <S extends Subject<S, A>, A> SimpleSubjectBuilder<S, A> about(SubjectFactory<S, A> factory) {
        return new SimpleSubjectBuilder<S, A>(this.metadata(), StandardSubjectBuilder.adapt(factory));
    }

    public final <S extends Subject<S, A>, A> SimpleSubjectBuilder<S, A> about(Subject.Factory<S, A> factory) {
        return new SimpleSubjectBuilder<S, A>(this.metadata(), factory);
    }

    @Deprecated
    public final <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT about(CustomSubjectBuilderFactory<CustomSubjectBuilderT> factory) {
        return factory.createSubjectBuilder(this.metadata().legacyStrategy());
    }

    public final <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT about(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return factory.createSubjectBuilder(this.metadata());
    }

    public final void fail() {
        this.metadata().legacyStrategy().fail("");
    }

    public final void fail(@Nullable String format, Object ... args) {
        this.metadata().legacyStrategy().fail(StringUtil.format(format, args));
    }

    private FailureMetadata metadata() {
        this.checkStatePreconditions();
        return this.metadataDoNotReferenceDirectly;
    }

    void checkStatePreconditions() {
    }

    private static <SubjectT extends Subject<SubjectT, ActualT>, ActualT> Subject.Factory<SubjectT, ActualT> adapt(final SubjectFactory<SubjectT, ActualT> subjectFactory) {
        return new Subject.Factory<SubjectT, ActualT>(){

            @Override
            public SubjectT createSubject(FailureMetadata metadata, ActualT actual) {
                return subjectFactory.getSubject(metadata.legacyStrategy(), actual);
            }
        };
    }
}

