/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MultimapSubject
extends Subject<MultimapSubject, Multimap<?, ?>> {
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    MultimapSubject(FailureMetadata metadata, @Nullable Multimap<?, ?> multimap) {
        super(metadata, multimap);
    }

    public void isEmpty() {
        if (!((Multimap)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Multimap)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = ((Multimap)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Multimap)this.actual()).containsKey(key)) {
            ArrayList keyList = Lists.newArrayList((Object[])new Object[]{key});
            if (SubjectUtils.hasMatchingToStringPair(((Multimap)this.actual()).keySet(), keyList)) {
                this.failWithRawMessage("Not true that %s contains key <%s (%s)>. However, it does contain keys <%s>.", this.actualAsString(), key, SubjectUtils.objectToTypeName(key), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(((Multimap)this.actual()).keySet(), keyList)));
            } else {
                this.fail("contains key", key);
            }
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Multimap)this.actual()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        if (!((Multimap)this.actual()).containsEntry(key, value)) {
            Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
            ImmutableList entryList = ImmutableList.of((Object)entry);
            if (SubjectUtils.hasMatchingToStringPair(((Multimap)this.actual()).entries(), entryList)) {
                this.failWithRawMessage("Not true that %s contains entry <%s (%s)>. However, it does contain entries <%s>", this.actualAsString(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(((Multimap)this.actual()).entries(), entryList)));
            } else if (((Multimap)this.actual()).containsKey(key)) {
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, it has a mapping from <%s> to <%s>", this.actualAsString(), entry, key, ((Multimap)this.actual()).asMap().get(key));
            } else if (((Multimap)this.actual()).containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : ((Multimap)this.actual()).entries()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.actualAsString(), entry, value, keys);
            } else {
                this.fail("contains entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
            }
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        if (((Multimap)this.actual()).containsEntry(key, value)) {
            this.fail("does not contain entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public IterableSubject valuesForKey(@Nullable Object key) {
        return new IterableValuesForKey(this.metadata, this, key);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.actual(), (Object)other)) {
            if (this.actual() instanceof ListMultimap && other instanceof SetMultimap || this.actual() instanceof SetMultimap && other instanceof ListMultimap) {
                String mapType1 = this.actual() instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                String mapType2 = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
                this.failWithRawMessage("Not true that %s %s is equal to %s <%s>. A %s cannot equal a %s if either is non-empty.", mapType1, this.actualAsString(), mapType2, other, mapType1, mapType2);
            } else {
                if (this.actual() instanceof ListMultimap) {
                    this.containsExactlyEntriesIn((Multimap)other).inOrder();
                    return;
                }
                if (this.actual() instanceof SetMultimap) {
                    this.containsExactlyEntriesIn((Multimap)other);
                    return;
                }
                this.fail("is equal to", other);
            }
        }
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, (Multimap)this.actual());
        ListMultimap<?, ?> extra = MultimapSubject.difference((Multimap)this.actual(), expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(missing.entries(), extra.entries());
                this.failWithRawMessage("Not true that %s contains exactly <%s>. It is missing <%s> and has unexpected items <%s>", this.actualAsString(), MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(missing).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing)), addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(extra).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra)));
                return ALREADY_FAILED;
            }
            this.failWithBadResults("contains exactly", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), "is missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing)));
            return ALREADY_FAILED;
        }
        if (!extra.isEmpty()) {
            this.failWithBadResults("contains exactly", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), "has unexpected items", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(expectedMultimap);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.check().that(((Multimap)this.actual()).entries()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    private static Multimap<Object, Object> accumulateMultimap(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        LinkedListMultimap expectedMultimap = LinkedListMultimap.create();
        expectedMultimap.put(k0, v0);
        for (int i = 0; i < rest.length; i += 2) {
            expectedMultimap.put(rest[i], rest[i + 1]);
        }
        return expectedMultimap;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Ordered containsExactly(Multimap<?, ?> expectedMultimap) {
        return this.containsExactlyEntriesIn(expectedMultimap);
    }

    private static <K, V> Collection<V> get(Multimap<K, V> multimap, @Nullable Object key) {
        if (multimap.containsKey(key)) {
            return (Collection)multimap.asMap().get(key);
        }
        return Collections.emptyList();
    }

    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static <K, V> String countDuplicatesMultimap(Multimap<K, V> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            entries.add(key + "=" + SubjectUtils.countDuplicates(multimap.get(key)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, entries);
        sb.append("}");
        return sb.toString();
    }

    private static Multimap<?, ?> annotateEmptyStringsMultimap(Multimap<?, ?> multimap) {
        if (multimap.containsKey((Object)"") || multimap.containsValue((Object)"")) {
            LinkedListMultimap annotatedMultimap = LinkedListMultimap.create();
            for (Map.Entry entry : multimap.entries()) {
                String key = "".equals(entry.getKey()) ? "\"\" (empty String)" : entry.getKey();
                String value = "".equals(entry.getValue()) ? "\"\" (empty String)" : entry.getValue();
                annotatedMultimap.put((Object)key, (Object)value);
            }
            return annotatedMultimap;
        }
        return multimap;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<A, E> correspondence;

        private UsingCorrespondence(Correspondence<A, E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, @Nullable E expectedValue) {
            if (((Multimap)MultimapSubject.this.actual()).containsKey(expectedKey)) {
                Collection actualValues = (Collection)this.getCastActual().asMap().get(expectedKey);
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.compare(actualValue, expectedValue)) continue;
                    return;
                }
                MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, actualValues);
            } else {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.getCastActual().entries()) {
                    if (!this.correspondence.compare(actualEntry.getValue(), expectedValue)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, keys);
                } else {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains at least one entry with key <%s> and a value that %s <%s>", MultimapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue);
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable E excludedValue) {
            if (((Multimap)MultimapSubject.this.actual()).containsKey(excludedKey)) {
                Collection actualValues = (Collection)this.getCastActual().asMap().get(excludedKey);
                ArrayList matchingValues = new ArrayList();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.compare(actualValue, excludedValue)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s did not contain an entry with key <%s> and a value that %s <%s>. It maps that key to the following such values: <%s>", MultimapSubject.this.actualAsString(), excludedKey, this.correspondence, excludedValue, matchingValues);
                }
            }
        }

        @CanIgnoreReturnValue
        public <K, V extends E> Ordered containsExactlyEntriesIn(Multimap<K, V> expectedMultimap) {
            return new IterableEntries(MultimapSubject.this.metadata, MultimapSubject.this).comparingElementsUsing(new MapSubject.EntryCorrespondence(this.correspondence)).containsExactlyElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public <K, V extends E> Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
            Multimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMultimap);
        }

        @CanIgnoreReturnValue
        public <K, V extends E> Ordered containsExactly() {
            return MultimapSubject.this.containsExactly();
        }

        private Multimap<?, A> getCastActual() {
            return (Multimap)MultimapSubject.this.actual();
        }
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;

        MultimapInOrder(Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
        }

        @Override
        public void inOrder() {
            boolean keysInOrder = Lists.newArrayList((Iterable)((Multimap)MultimapSubject.this.actual()).keySet()).equals(Lists.newArrayList((Iterable)this.expectedMultimap.keySet()));
            LinkedHashSet keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            LinkedHashSet allKeys = Sets.newLinkedHashSet();
            allKeys.addAll(((Multimap)MultimapSubject.this.actual()).keySet());
            allKeys.addAll(this.expectedMultimap.keySet());
            for (Object key : allKeys) {
                ArrayList expectedVals;
                ArrayList actualVals = Lists.newArrayList((Iterable)MultimapSubject.get((Multimap)MultimapSubject.this.actual(), key));
                if (actualVals.equals(expectedVals = Lists.newArrayList((Iterable)MultimapSubject.get(this.expectedMultimap, key)))) continue;
                keysWithValuesOutOfOrder.add(key);
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order, and the values for keys <%s> are not in order either", MultimapSubject.this.actualAsString(), this.expectedMultimap, keysWithValuesOutOfOrder);
                } else {
                    MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The keys are not in order", MultimapSubject.this.actualAsString(), this.expectedMultimap);
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithRawMessage("Not true that %s contains exactly <%s> in order. The values for keys <%s> are not in order", MultimapSubject.this.actualAsString(), this.expectedMultimap, keysWithValuesOutOfOrder);
            }
        }
    }

    private static class IterableEntries
    extends IterableSubject {
        private final String stringRepresentation;

        IterableEntries(FailureMetadata metadata, MultimapSubject multimapSubject) {
            super(metadata, (Iterable<?>)((Multimap)multimapSubject.actual()).entries());
            this.stringRepresentation = ((Multimap)multimapSubject.actual()).toString();
            if (multimapSubject.internalCustomName() != null) {
                this.named(multimapSubject.internalCustomName(), new Object[0]);
            }
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }

    private static class IterableValuesForKey
    extends IterableSubject {
        @Nullable
        private final Object key;
        private final String stringRepresentation;

        IterableValuesForKey(FailureMetadata metadata, MultimapSubject multimapSubject, @Nullable Object key) {
            super(metadata, (Iterable<?>)((Multimap)multimapSubject.actual()).get(key));
            this.key = key;
            this.stringRepresentation = multimapSubject.actualAsString();
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return "Values for key <" + this.key + "> (<" + this.actual() + ">) in " + this.stringRepresentation;
        }
    }
}

