/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;

public class JavacErrorDescriptionListener
implements DescriptionListener {
    private final Log log;
    private final JavaFileObject sourceFile;
    private final Function<Fix, AppliedFix> fixToAppliedFix;
    private final boolean dontUseErrors;
    private static final String MESSAGE_BUNDLE_KEY = "error.prone";

    private JavacErrorDescriptionListener(Log log, EndPosTable endPositions, JavaFileObject sourceFile, boolean dontUseErrors) {
        this.log = log;
        this.sourceFile = sourceFile;
        this.dontUseErrors = dontUseErrors;
        Preconditions.checkNotNull((Object)endPositions);
        try {
            CharSequence sourceFileContent = sourceFile.getCharContent(true);
            this.fixToAppliedFix = fix -> AppliedFix.fromSource(sourceFileContent, endPositions).apply((Fix)fix);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void onDescribed(Description description) {
        List appliedFixes = description.fixes.stream().map(this.fixToAppliedFix).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        String message = JavacErrorDescriptionListener.messageForFixes(description, appliedFixes);
        JavaFileObject originalSource = this.log.useSource(this.sourceFile);
        switch (description.severity) {
            case ERROR: {
                if (this.dontUseErrors) {
                    this.log.warning((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                    break;
                }
                this.log.error((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
            case WARNING: {
                this.log.warning((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
            case SUGGESTION: {
                this.log.note((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
        }
        if (originalSource != null) {
            this.log.useSource(originalSource);
        }
    }

    private static String messageForFixes(Description description, List<AppliedFix> appliedFixes) {
        StringBuilder messageBuilder = new StringBuilder(description.getMessage());
        boolean first = true;
        for (AppliedFix appliedFix : appliedFixes) {
            if (first) {
                messageBuilder.append("\nDid you mean ");
            } else {
                messageBuilder.append(" or ");
            }
            if (appliedFix.isRemoveLine()) {
                messageBuilder.append("to remove this line");
            } else {
                messageBuilder.append("'").append(appliedFix.getNewCodeSnippet()).append("'");
            }
            first = false;
        }
        if (!first) {
            messageBuilder.append("?");
        }
        return messageBuilder.toString();
    }

    static DescriptionListener.Factory provider() {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), false);
    }

    static DescriptionListener.Factory providerForRefactoring() {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, compilation.endPositions, compilation.getSourceFile(), true);
    }
}

