/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;

public interface LoadedTypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    public static class Compound
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LoadedTypeInitializer[] loadedTypeInitializer;

        public Compound(LoadedTypeInitializer ... loadedTypeInitializer) {
            this.loadedTypeInitializer = loadedTypeInitializer;
        }

        public Compound(List<? extends LoadedTypeInitializer> loadedTypeInitializers) {
            this.loadedTypeInitializer = loadedTypeInitializers.toArray(new LoadedTypeInitializer[loadedTypeInitializers.size()]);
        }

        @Override
        public void onLoad(Class<?> type) {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializer) {
                loadedTypeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializer) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.loadedTypeInitializer, ((Compound)other).loadedTypeInitializer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.loadedTypeInitializer);
        }

        public String toString() {
            return "LoadedTypeInitializer.Compound{loadedTypeInitializer=" + Arrays.toString(this.loadedTypeInitializer) + '}';
        }
    }

    public static class ForStaticField<T>
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Object STATIC_FIELD = null;
        private final String fieldName;
        private final T value;
        private final boolean makeAccessible;

        protected ForStaticField(String fieldName, T value, boolean makeAccessible) {
            this.fieldName = fieldName;
            this.value = value;
            this.makeAccessible = makeAccessible;
        }

        public static LoadedTypeInitializer accessible(String fieldName, Object value) {
            return new ForStaticField<Object>(fieldName, value, false);
        }

        public static LoadedTypeInitializer nonAccessible(String fieldName, Object value) {
            return new ForStaticField<Object>(fieldName, value, true);
        }

        @Override
        public void onLoad(Class<?> type) {
            try {
                Field field = type.getDeclaredField(this.fieldName);
                if (this.makeAccessible) {
                    AccessController.doPrivileged(new FieldAccessibilityAction(field));
                }
                field.set(STATIC_FIELD, this.value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Cannot access " + this.fieldName + " from " + type, exception);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException("There is no field " + this.fieldName + " defined on " + type, exception);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForStaticField that = (ForStaticField)other;
            return this.makeAccessible == that.makeAccessible && this.fieldName.equals(that.fieldName) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + (this.makeAccessible ? 1 : 0);
            return result;
        }

        public String toString() {
            return "LoadedTypeInitializer.ForStaticField{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + ", makeAccessible=" + this.makeAccessible + '}';
        }

        protected static class FieldAccessibilityAction
        implements PrivilegedAction<Void> {
            private static final Void NOTHING = null;
            private final Field field;

            protected FieldAccessibilityAction(Field field) {
                this.field = field;
            }

            @Override
            public Void run() {
                this.field.setAccessible(true);
                return NOTHING;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                FieldAccessibilityAction that = (FieldAccessibilityAction)other;
                return this.field.equals(that.field);
            }

            public int hashCode() {
                return this.field.hashCode();
            }

            public String toString() {
                return "LoadedTypeInitializer.ForStaticField.FieldAccessibilityAction{field=" + this.field + '}';
            }
        }
    }

    public static enum NoOp implements LoadedTypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }

        public String toString() {
            return "LoadedTypeInitializer.NoOp." + this.name();
        }
    }
}

