#!/bin/sh
# vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
# -*- mode: sh; coding: utf-8 -*-
# Test upgrade command
# Copyright © 2005 Canonical Limited.
#	Author: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "Upgrade"

begin_test "upgrade with no parameters barfs"
tla upgrade && test_fail "upgrade didn't barf"
end_test

begin_test "upgrade nothing to do"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p ~/.arch-params/archives
tla upgrade --move-old-config || test_fail "upgrade failed"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade  archives no signing"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p ~/.arch-params/archives
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003
tla upgrade --move-old-config || "upgrade upgrade failed"
[ -e ~/.arch-params/\=locations/foo@example.org--2003 ] && test_fail "foo@example.org--2003 old registration not removed"
file_matches "foo-archive" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 new registration missing"
[ -e ~/.arch-params/upgraded-by-baz-1.3/\=locations/foo@example.org--2003 ] || test_fail "foo@example.org--2003 registration not saved"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade read-only archives"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p ~/.arch-params/archives
chmod -R a-w "${ARCHIVEDIR}/foo-archive"
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003
tla upgrade --move-old-config || "upgrade upgrade failed"
# url=cached:http://bazaar.canonical.com/archives/thelove@canonical.com readonly
grep "readonly" ~/.arch-params/archives/foo@example.org--2003 || test_fail "the readonly flag is not set."
chmod -R u+w "${ARCHIVEDIR}/foo-archive"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade  archives signed"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p ~/.arch-params/archives
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003
touch ${ARCHIVEDIR}/foo-archive/\=meta-info/signed-archive
tla upgrade --move-old-config 
[ -e ~/.arch-params/\=locations/foo@example.org--2003 ] && test_fail "foo@example.org--2003 registration not upgraded"
file_matches "foo-archive" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 new registration missing"
file_matches "when_unsigned=error" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 not set to fail on missing sigs"
[ -e ~/.arch-params/upgraded-by-baz-1.3/\=locations/foo@example.org--2003 ] || test_fail "foo@example.org--2003 registration not saved"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade archives signed gpg_command"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p  ~/.arch-params/signing
mkdir -p ~/.arch-params/archives
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003
touch ${ARCHIVEDIR}/foo-archive/\=meta-info/signed-archive
echo "gnome-gpg --clearsign" > ~/.arch-params/signing/foo@example.org--2003
tla upgrade --move-old-config 
[ -e ~/.arch-params/\=locations/foo@example.org--2003 ] && test_fail "foo@example.org--2003 registration not upgraded"
file_matches "foo-archive" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 new registration missing"
file_matches "when_unsigned=error" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 not set to fail on missing sigs"
[ -e ~/.arch-params/upgraded-by-baz-1.3/\=locations/foo@example.org--2003 ] || test_fail "foo@example.org--2003 registration not saved"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/signing
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade archives signed warnings"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p  ~/.arch-params/signing
mkdir -p ~/.arch-params/archives
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003
touch ${ARCHIVEDIR}/foo-archive/\=meta-info/signed-archive
echo "if [ -n "$DISPLAY" ]; then
gnome-gpg --clearsign
else
   gpg --clearsign
fi" > ~/.arch-params/signing/foo@example.org--2003
echo "recognize this" > ~/.arch-params/signing/foo@example.org--2003.check
tla upgrade --move-old-config >,,log 2>&1
file_matches "WARNING: Unconvertable check script" ,,log || test_fail "check script not warned on"
file_matches "Cannot upgrade" ,,log || test_fail "signing script not warned on"
[ -e ~/.arch-params/\=locations/foo@example.org--2003 ] && test_fail "foo@example.org--2003 registration not upgraded"
file_matches "foo-archive" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 new registration missing"
file_matches "when_unsigned=error" ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 not set to fail on missing sigs"
[ -e ~/.arch-params/upgraded-by-baz-1.3/\=locations/foo@example.org--2003 ] || test_fail "foo@example.org--2003 registration not saved"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/signing
rm -rf ~/.arch-params/archives
end_test

begin_test "upgrade  whack names"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
mkdir -p  ~/.arch-params/\=locations
mkdir -p ~/.arch-params/archives
echo "url=${CACHEDARCHIVEDIR}/jane-archive" > ~/.arch-params/archives/jane@example.com--2003
echo "${ARCHIVEDIR}/foo-archive" > ~/.arch-params/\=locations/foo@example.org--2003-SOURCE
tla upgrade --move-old-config 
[ -e ~/.arch-params/\=locations/foo@example.org--2003-SOURCE ] && test_fail "foo@example.org--2003 registration not upgraded"
file_matches 'foo-archive.*priority=50' ~/.arch-params/archives/foo@example.org--2003 || test_fail "foo@example.org--2003 new registration missing"
[ -e ~/.arch-params/upgraded-by-baz-1.3/\=locations/foo@example.org--2003-SOURCE ] || test_fail "foo@example.org--2003 registration not saved"
rm -rf ~/.arch-params/\=locations
rm -rf ~/.arch-params/archives
end_test

clean_workdir
