#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple tree-version tests
# Copyright © 2003 Colin Walters <walters@verbum.org>
#             2004 Canonical Ltd
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "tree-version"

cleanup () {
  :
}

begin_test "check it works at all"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
tla tree-version > ./hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.0' ./hello-world.version
cleanup
end_test

begin_test "check -d works"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
tla tree-version -d hello-world > ../hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.0' ../hello-world.version
cleanup
end_test

begin_test "check it sets the version correctly"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
tla tree-version > ./hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.0' ./hello-world.version
tla tree-version jane@example.com--2003/hello-world--mainline--1.1
rm ./hello-world.version
tla tree-version > ./hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.1' ./hello-world.version
cleanup
end_test

begin_test "check it sets the version correctly with -d"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
tla tree-version -d hello-world > ./hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.0' ./hello-world.version
tla tree-version -d hello-world jane@example.com--2003/hello-world--mainline--1.1
rm ./hello-world.version
tla tree-version -d hello-world > ./hello-world.version
file_matches 'jane@example.com--2003/hello-world--mainline--1.1' ./hello-world.version
cleanup
end_test

clean_workdir

