/* patch-id.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PATCH_ID_H
#define INCLUDE__LIBARCH__PATCH_ID_H

#include "hackerlab/arrays/ar.h"

/* A patch id - i.e. foo@example.com/foo--bar--0--base-0
 * with allocating accessors for its interesting bits, lazy parsing
 * and memory mgmt
 */
typedef struct arch_patch_id_ 
{
    t_uchar *patch_id;
    t_uchar *archive;
    t_uchar *branch;
    t_uchar *version;
    t_uchar *revision;
    t_uchar *patchlevel;
    
} arch_patch_id;

AR_TYPEDEF(arch_patch_id *, patch_id);
/* ar_patch_id is talloc managed, be sure to talloc_steal (ar_base(array), patch) */

extern void arch_patch_id_init (arch_patch_id *patch, t_uchar const *patch_id);
extern void arch_patch_id_init_archive (arch_patch_id *patch, t_uchar const *archive, t_uchar const *revision);
extern arch_patch_id *arch_patch_id_new (t_uchar const *patch_id);
extern arch_patch_id *arch_patch_id_copy (arch_patch_id *patch);
extern arch_patch_id *arch_patch_id_new_archive (t_uchar const *archive,
                                                    t_uchar const *revision);
extern void arch_patch_id_finalise (arch_patch_id *patch);
/* should be const ! */
extern t_uchar * arch_patch_id_archive (arch_patch_id *patch);
extern t_uchar * arch_patch_id_branch (arch_patch_id *patch); /* aka fq_version - somewhere patches go */
extern t_uchar * arch_patch_id_version (arch_patch_id *patch);
extern t_uchar * arch_patch_id_revision (arch_patch_id *patch);
extern t_uchar * arch_patch_id_patch_id (arch_patch_id *patch);
extern t_uchar * arch_patch_id_patchlevel (arch_patch_id *patch);
  
extern void ar_patch_id_extend_taking (ar_patch_id * patches,
                                       ar_patch_id * other_patches);
extern int arch_patch_id_cmp (arch_patch_id *a,
                              arch_patch_id *b);
extern void ar_sort_patch_id (ar_patch_id patches,
                              int reverse);

#endif /* INCLUDE__LIBARCH__PATCH_ID_H */
