/* archive-location.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 *      Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ARCHIVE_LOCATION_H
#define INCLUDE__LIBARCH__ARCHIVE_LOCATION_H


#include "hackerlab/arrays/ar.h"
#include "hackerlab/mem/talloc.h"
#include "libinifile/inifile.h"

typedef struct arch_archive_location_
{
  /* must be talloced in the location context */
  t_uchar * url;
  /* 0:not, 1: unknown, 2: yes */
  int master;
  /* 0:not, 1: unknown, 2: yes */
  int readonly;
  /* 0:not, 1: unknown, 2: disabled */
  int disabled;
  /* defaults to 100, <0 means disabled */
  int priority;
} arch_archive_location_t;

AR_TYPEDEF(arch_archive_location_t *, archive_location)
#define ar_free_archive_location(array) \
{ \
    int index; \
    for (index = 0; index < ar_size_archive_location (*array); ++index) \
      talloc_free ((*array)[index]); \
    ar_free_archive_location(array); \
}

extern arch_archive_location_t * arch_archive_location_new (t_uchar const * const url);
extern arch_archive_location_t * arch_archive_location_new_inivalue (t_uchar const * const inivalue);
/* result is a talloc allocated struct. use talloc_free or steal it to another talloc context */
#define arch_archive_location_delete(foo) talloc_free(foo)
extern t_uchar * arch_archive_location_to_ini_key(arch_archive_location_t const * const location);

#endif  /* INCLUDE__LIBARCH__ARCHIVE_LOCATION_H */
