/* annotation-builder.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ANNOTATION_BUILDER_H
#define INCLUDE__LIBARCH__ANNOTATION_BUILDER_H

#include "hackerlab/arrays/ar.h"
#include "libawk/relational.h"
#include "libarch/annotated-file.h"
#include "libarch/patch-parser.h"

AR_TYPEDEF(arch_annotated_file_t *, arch_annotated_file);

/* A annotation builder.
 * provides a builder interface for assembling annotation data
 * about a revision
 */
typedef struct arch_annotation_builder_
{
  /* FIXME, want easy to use sets */
  ar_arch_annotated_file files;
  arch_annotated_file_t *current_file;
  arch_patch_t *current_patch;
} arch_annotation_builder_t;

/* derived classes only */
extern void arch_annotation_builder_init (arch_annotation_builder_t *builder);
extern void arch_annotation_builder_finalise (arch_annotation_builder_t *builder);

/* public api */
extern arch_annotation_builder_t * arch_annotation_builder_new (void * context);
extern void arch_annotation_builder_add_file (arch_annotation_builder_t *builder, t_uchar const *file_id, int length_if_known);
extern int arch_annotation_builder_has_file (arch_annotation_builder_t *builder, t_uchar const *file_id);
extern arch_annotated_file_t * arch_annotation_builder_get_file (arch_annotation_builder_t *builder, void * context, t_uchar const *file_id);

extern void arch_annotation_builder_add_patch (arch_annotation_builder_t *builder, arch_patch_id *patch, t_uchar const *creator);
extern void arch_annotation_builder_subtract_line (arch_annotation_builder_t *builder, int old_offset);
extern void arch_annotation_builder_add_line (arch_annotation_builder_t *builder, int line);
extern void arch_annotation_builder_process_changes(arch_annotation_builder_t *builder, patch_line_changes_list changes);
  
#endif /* INCLUDE__LIBARCH__ANNOTATION_BUILDER_H */
