"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forEach = forEach;
exports.range = range;
exports.isDefinition = isDefinition;
exports.isReference = isReference;
exports.findParent = findParent;
exports.findParentOfType = findParentOfType;
const LSP = require("vscode-languageserver/node");
/**
 * Recursively iterate over all nodes in a tree.
 *
 * @param node The node to start iterating from
 * @param callback The callback to call for each node. Return false to stop following children.
 */
function forEach(node, callback) {
    const followChildren = callback(node) !== false;
    if (followChildren && node.children.length) {
        node.children.forEach((n) => forEach(n, callback));
    }
}
function range(n) {
    return LSP.Range.create(n.startPosition.row, n.startPosition.column, n.endPosition.row, n.endPosition.column);
}
function isDefinition(n) {
    switch (n.type) {
        case 'variable_assignment':
        case 'function_definition':
            return true;
        default:
            return false;
    }
}
function isReference(n) {
    switch (n.type) {
        case 'variable_name':
        case 'command_name':
            return true;
        default:
            return false;
    }
}
function findParent(start, predicate) {
    let node = start.parent;
    while (node !== null) {
        if (predicate(node)) {
            return node;
        }
        node = node.parent;
    }
    return null;
}
function findParentOfType(start, type) {
    if (typeof type === 'string') {
        return findParent(start, (n) => n.type === type);
    }
    return findParent(start, (n) => type.includes(n.type));
}
//# sourceMappingURL=tree-sitter.js.map