---
name: Bug report
about: Create a report to help us improve

---

<!--

Have you read Atom's Code of Conduct? By filing an Issue, you are expected to comply with it, including treating everyone with respect: https://github.com/atom/atom/blob/master/CODE_OF_CONDUCT.md

Do you want to ask a question? Are you looking for support? The Atom message board is the best place for getting support: https://discuss.atom.io

-->

### Prerequisites

* [ ] Put an X between the brackets on this line if you have done all of the following:
    * Reproduced the problem in Safe Mode: https://flight-manual.atom.io/hacking-atom/sections/debugging/#using-safe-mode
    * Followed all applicable steps in the debugging guide: https://flight-manual.atom.io/hacking-atom/sections/debugging/
    * Checked the FAQs on the message board for common solutions: https://discuss.atom.io/c/faq
    * Checked that your issue isn't already filed: https://github.com/issues?utf8=✓&q=is%3Aissue+user%3Aatom
    * Checked that there is not already an Atom package that provides the described functionality: https://atom.io/packages

### Description

[Description of the issue]

### Steps to Reproduce

1. [First Step]
2. [Second Step]
3. [and so on...]

**Expected behavior:** [What you expect to happen]

**Actual behavior:** [What actually happens]

**Reproduces how often:** [What percentage of the time does it reproduce?]

### Versions

You can get this information from copy and pasting the output of `atom --version` and `apm --version` from the command line. Also, please include the OS and what version of the OS you're running.

### Additional Information

Any additional information, configuration or data that might be necessary to reproduce the issue.
