## Highlights from the past week

- Atom IDE
  - Shipping Console Logging
  - Fixed bugs including multi-symbol autocomplete trigger, java detection etc.
  - Started learning Rust
- GitHub Package
  - Commit together with co-authors - [atom/github#1355](https://github.com/atom/github/pull/1355)
  - Automated the production of `gpg` and `gpg-agent` binaries for Windows, MacOS, and Linux with [squeegpg-native](https://github.com/atom/squeegpg-native).
  - Investigated the setup for [including a TypeScript transpiler in an Atom package](https://github.com/smashwilson/minimal-typescript-atom) with React.
  - Begin an npm package, [squeegpg](https://github.com/atom/squeegpg), to wrap GPG interaction and gpg-agent management using the binaries from [squeegpg-native](https://github.com/atom/squeegpg-native). Set up a bunch of yak-shaving tasks like configuring Circle/AppVeyor/Travis CI and installing Greenkeeper.
  - Upgrade `fs-extra` and replace our proliferating helper methods with the already-Promisified versions from the newer version. [atom/github#1350](https://github.com/atom/github/pull/1350)
- Teletype
  - Adjusted teletype-server's caching directives in an effort to reduce or eliminate package initialization errors ([atom/teletype-server#47](https://github.com/atom/teletype-server/pull/47), [atom/teletype#318](https://github.com/atom/teletype/issues/318))
  - Published first draft of RFC for streamlining collaboration set-up, including the ability to give guests a URL that they can use to join your portal, and a "buddy list" for more quickly collaborating with coworkers and friends ([atom/teletype#344](https://github.com/atom/teletype/pull/344))
- Tree-sitter
  - Fixed some remaining issues with last week's optimizations related to parser size & compile time (https://github.com/tree-sitter/tree-sitter/pull/148)
- Xray
  - Optimized selections. We're moving 1k selections in a document with 10k edits in ~2ms, and we think there's still room for improvement.
  - Made significant progress on a switch to a client/server architecture.
  - See [this week's in-depth Xray update](https://github.com/atom/xray/blob/master/docs/updates/2018_03_19.md) for more details.
- Engineering Improvements
  - Process `.tsx` files within Atom as TypeScript in a kind of hacky way. [atom/atom#16944](https://github.com/atom/atom/pull/16944)
- Shipped Atom 1.25.0 and 1.26.0-beta0!

## Focus for week ahead

- Atom IDE
  - Continue learning rust, try out ide-rust
  - Bugs and PRs
  - Check in with Facebook on Symbols and Debugger
  - Folder level configuration
- GitHub Package
  - Wrap up co-authors feature [atom/github#1355](https://github.com/atom/github/pull/1355)
- Teletype
  - Update RFC for streamlining collaboration set-up to incorporate feedback from core dev team, and then request comments from the public ([atom/teletype#344](https://github.com/atom/teletype/pull/344))
  - Add preliminary support for joining a portal via URL ([atom/teletype#109](https://github.com/atom/teletype/issues/109))
- Tree-sitter
  - Address bugs reported now that Tree-sitter is in stable Atom.
- Xray
  - Continue to make progress on the [PR switching Xray to a client/server architecture](https://github.com/atom/xray/pull/46). Hopefully we can merge it this week.
  - Investigate a switch from JSON to protocol buffers.
