/*@license
 AsyGL: Render Bezier patches and triangles via subdivision with WebGL.
  Copyright 2019: John C. Bowman and Supakorn "Jamie" Rassameemasmuang
  University of Alberta

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*@license for gl-matrix mat3 and mat4 functions:
Copyright (c) 2015, Brandon Jones, Colin MacKenzie IV.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/
let vertex="\nattribute vec3 position;\n#ifdef WIDTH\nattribute float width;\n#endif\n#ifdef NORMAL\nattribute vec3 normal;\n#endif\nattribute float materialIndex;\n#ifdef COLOR\nattribute vec4 color;\n#endif\n\nuniform mat3 normMat;\nuniform mat4 viewMat;\nuniform mat4 projViewMat;\n\n#ifdef NORMAL\n#ifndef ORTHOGRAPHIC\nvarying vec3 ViewPosition;\n#endif\nvarying vec3 Normal;\n#endif\nvarying vec4 diffuse;\nvarying vec3 specular;\nvarying float roughness,metallic,fresnel0;\nvarying vec4 emissive;\n\nstruct Material {\n  vec4 diffuse,emissive,specular;\n  vec4 parameters;\n};\n\nuniform Material Materials[Nmaterials];\n\nvoid main(void)\n{\n  vec4 v=vec4(position,1.0);\n  gl_Position=projViewMat*v;\n#ifdef NORMAL\n#ifndef ORTHOGRAPHIC\n  ViewPosition=(viewMat*v).xyz;\n#endif      \n  Normal=normal*normMat;\n        \n  Material m;\n#ifdef TRANSPARENT\n  m=Materials[int(abs(materialIndex))-1];\n  if(materialIndex >= 0.0) {\n    diffuse=m.diffuse;\n    emissive=m.emissive;\n  } else {\n    diffuse=color;\n#if nlights > 0\n    emissive=vec4(0.0);\n#else\n    emissive=color;\n#endif\n  }\n#else\n  m=Materials[int(materialIndex)];\n#ifdef COLOR\n  diffuse=color;\n#if nlights > 0\n  emissive=vec4(0.0);\n#else\n  emissive=color;\n#endif\n#else\n  diffuse=m.diffuse;\n  emissive=m.emissive;\n#endif\n#endif\n  specular=m.specular.rgb;\n  vec4 parameters=m.parameters;\n  roughness=1.0-parameters[0];\n  metallic=parameters[1];\n  fresnel0=parameters[2];\n#else\n  emissive=Materials[int(materialIndex)].emissive;\n#endif\n#ifdef WIDTH\n  gl_PointSize=width;\n#endif\n}\n",fragment="\n#ifdef NORMAL\n#ifndef ORTHOGRAPHIC\nvarying vec3 ViewPosition;\n#endif\nvarying vec3 Normal;\nvarying vec4 diffuse;\nvarying vec3 specular;\nvarying float roughness,metallic,fresnel0;\n\nfloat Roughness2;\nvec3 normal;\n\nstruct Light {\n  vec3 direction;\n  vec3 color;\n};\n\nuniform Light Lights[Nlights];\n\nfloat NDF_TRG(vec3 h)\n{\n  float ndoth=max(dot(normal,h),0.0);\n  float alpha2=Roughness2*Roughness2;\n  float denom=ndoth*ndoth*(alpha2-1.0)+1.0;\n  return denom != 0.0 ? alpha2/(denom*denom) : 0.0;\n}\n    \nfloat GGX_Geom(vec3 v)\n{\n  float ndotv=max(dot(v,normal),0.0);\n  float ap=1.0+Roughness2;\n  float k=0.125*ap*ap;\n  return ndotv/((ndotv*(1.0-k))+k);\n}\n    \nfloat Geom(vec3 v, vec3 l)\n{\n  return GGX_Geom(v)*GGX_Geom(l);\n}\n    \nfloat Fresnel(vec3 h, vec3 v, float fresnel0)\n{\n  float a=1.0-max(dot(h,v),0.0);\n  float b=a*a;\n  return fresnel0+(1.0-fresnel0)*b*b*a;\n}\n    \n// physical based shading using UE4 model.\nvec3 BRDF(vec3 viewDirection, vec3 lightDirection)\n{\n  vec3 lambertian=diffuse.rgb;\n  vec3 h=normalize(lightDirection+viewDirection);\n      \n  float omegain=max(dot(viewDirection,normal),0.0);\n  float omegali=max(dot(lightDirection,normal),0.0);\n      \n  float D=NDF_TRG(h);\n  float G=Geom(viewDirection,lightDirection);\n  float F=Fresnel(h,viewDirection,fresnel0);\n      \n  float denom=4.0*omegain*omegali;\n  float rawReflectance=denom > 0.0 ? (D*G)/denom : 0.0;\n      \n  vec3 dielectric=mix(lambertian,rawReflectance*specular,F);\n  vec3 metal=rawReflectance*diffuse.rgb;\n      \n  return mix(dielectric,metal,metallic);\n}\n#endif\nvarying vec4 emissive;\n    \nvoid main(void)\n{\n#if defined(NORMAL) && nlights > 0\n  normal=normalize(Normal);\n  normal=gl_FrontFacing ? normal : -normal;\n#ifdef ORTHOGRAPHIC\n  vec3 viewDir=vec3(0.0,0.0,1.0);\n#else\n  vec3 viewDir=-normalize(ViewPosition);\n#endif\n  Roughness2=roughness*roughness;\n  vec3 color=emissive.rgb;\n  for(int i=0; i < nlights; ++i) {\n    Light Li=Lights[i];\n    vec3 L=Li.direction;\n    float cosTheta=max(dot(normal,L),0.0);\n    vec3 radiance=cosTheta*Li.color;\n    color += BRDF(viewDir,L)*radiance;\n  }\n  gl_FragColor=vec4(color,diffuse.a);\n#else\n  gl_FragColor=emissive;\n#endif\n}\n";!function(e,t){if("object"==typeof exports&&"object"==typeof module)module.exports=t();else if("function"==typeof define&&define.amd)define([],t);else{var i=t();for(var a in i)("object"==typeof exports?exports:e)[a]=i[a]}}("undefined"!=typeof self?self:this,function(){return function(e){var t={};function i(a){if(t[a])return t[a].exports;var r=t[a]={i:a,l:!1,exports:{}};return e[a].call(r.exports,r,r.exports,i),r.l=!0,r.exports}return i.m=e,i.c=t,i.d=function(e,t,a){i.o(e,t)||Object.defineProperty(e,t,{configurable:!1,enumerable:!0,get:a})},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=1)}([function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.setMatrixArrayType=function(e){t.ARRAY_TYPE=e},t.toRadian=function(e){return e*r},t.equals=function(e,t){return Math.abs(e-t)<=a*Math.max(1,Math.abs(e),Math.abs(t))};var a=t.EPSILON=1e-6;t.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,t.RANDOM=Math.random;var r=Math.PI/180},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.mat4=t.mat3=void 0;var a=n(i(2)),r=n(i(3));function n(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i]);return t.default=e,t}t.mat3=a,t.mat4=r},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.create=function(){var e=new a.ARRAY_TYPE(9);return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=1,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e},t.fromMat4=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e},t.invert=function(e,t){var i=t[0],a=t[1],r=t[2],n=t[3],s=t[4],o=t[5],l=t[6],h=t[7],c=t[8],d=c*s-o*h,m=-c*n+o*l,f=h*n-s*l,u=i*d+a*m+r*f;if(!u)return null;return u=1/u,e[0]=d*u,e[1]=(-c*a+r*h)*u,e[2]=(o*a-r*s)*u,e[3]=m*u,e[4]=(c*i-r*l)*u,e[5]=(-o*i+r*n)*u,e[6]=f*u,e[7]=(-h*i+a*l)*u,e[8]=(s*i-a*n)*u,e};var a=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i]);return t.default=e,t}(i(0))},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.create=function(){var e=new a.ARRAY_TYPE(16);return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},t.identity=function(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},t.invert=function(e,t){var i=t[0],a=t[1],r=t[2],n=t[3],s=t[4],o=t[5],l=t[6],h=t[7],c=t[8],d=t[9],m=t[10],f=t[11],u=t[12],v=t[13],g=t[14],p=t[15],x=i*o-a*s,M=i*l-r*s,w=i*h-n*s,A=a*l-r*o,b=a*h-n*o,S=r*h-n*l,R=c*v-d*u,P=c*g-m*u,D=c*p-f*u,T=d*g-m*v,y=d*p-f*v,I=m*p-f*g,z=x*I-M*y+w*T+A*D-b*P+S*R;if(!z)return null;return z=1/z,e[0]=(o*I-l*y+h*T)*z,e[1]=(r*y-a*I-n*T)*z,e[2]=(v*S-g*b+p*A)*z,e[3]=(m*b-d*S-f*A)*z,e[4]=(l*D-s*I-h*P)*z,e[5]=(i*I-r*D+n*P)*z,e[6]=(g*w-u*S-p*M)*z,e[7]=(c*S-m*w+f*M)*z,e[8]=(s*y-o*D+h*R)*z,e[9]=(a*D-i*y-n*R)*z,e[10]=(u*b-v*w+p*x)*z,e[11]=(d*w-c*b-f*x)*z,e[12]=(o*P-s*T-l*R)*z,e[13]=(i*T-a*P+r*R)*z,e[14]=(v*M-u*A-g*x)*z,e[15]=(c*A-d*M+m*x)*z,e},t.multiply=r,t.translate=function(e,t,i){var a=i[0],r=i[1],n=i[2],s=void 0,o=void 0,l=void 0,h=void 0,c=void 0,d=void 0,m=void 0,f=void 0,u=void 0,v=void 0,g=void 0,p=void 0;t===e?(e[12]=t[0]*a+t[4]*r+t[8]*n+t[12],e[13]=t[1]*a+t[5]*r+t[9]*n+t[13],e[14]=t[2]*a+t[6]*r+t[10]*n+t[14],e[15]=t[3]*a+t[7]*r+t[11]*n+t[15]):(s=t[0],o=t[1],l=t[2],h=t[3],c=t[4],d=t[5],m=t[6],f=t[7],u=t[8],v=t[9],g=t[10],p=t[11],e[0]=s,e[1]=o,e[2]=l,e[3]=h,e[4]=c,e[5]=d,e[6]=m,e[7]=f,e[8]=u,e[9]=v,e[10]=g,e[11]=p,e[12]=s*a+c*r+u*n+t[12],e[13]=o*a+d*r+v*n+t[13],e[14]=l*a+m*r+g*n+t[14],e[15]=h*a+f*r+p*n+t[15]);return e},t.rotate=function(e,t,i,r){var n=r[0],s=r[1],o=r[2],l=Math.sqrt(n*n+s*s+o*o),h=void 0,c=void 0,d=void 0,m=void 0,f=void 0,u=void 0,v=void 0,g=void 0,p=void 0,x=void 0,M=void 0,w=void 0,A=void 0,b=void 0,S=void 0,R=void 0,P=void 0,D=void 0,T=void 0,y=void 0,I=void 0,z=void 0,O=void 0,E=void 0;if(Math.abs(l)<a.EPSILON)return null;n*=l=1/l,s*=l,o*=l,h=Math.sin(i),c=Math.cos(i),d=1-c,m=t[0],f=t[1],u=t[2],v=t[3],g=t[4],p=t[5],x=t[6],M=t[7],w=t[8],A=t[9],b=t[10],S=t[11],R=n*n*d+c,P=s*n*d+o*h,D=o*n*d-s*h,T=n*s*d-o*h,y=s*s*d+c,I=o*s*d+n*h,z=n*o*d+s*h,O=s*o*d-n*h,E=o*o*d+c,e[0]=m*R+g*P+w*D,e[1]=f*R+p*P+A*D,e[2]=u*R+x*P+b*D,e[3]=v*R+M*P+S*D,e[4]=m*T+g*y+w*I,e[5]=f*T+p*y+A*I,e[6]=u*T+x*y+b*I,e[7]=v*T+M*y+S*I,e[8]=m*z+g*O+w*E,e[9]=f*z+p*O+A*E,e[10]=u*z+x*O+b*E,e[11]=v*z+M*O+S*E,t!==e&&(e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]);return e},t.fromTranslation=function(e,t){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=t[0],e[13]=t[1],e[14]=t[2],e[15]=1,e},t.fromRotation=function(e,t,i){var r=i[0],n=i[1],s=i[2],o=Math.sqrt(r*r+n*n+s*s),l=void 0,h=void 0,c=void 0;if(Math.abs(o)<a.EPSILON)return null;return r*=o=1/o,n*=o,s*=o,l=Math.sin(t),h=Math.cos(t),c=1-h,e[0]=r*r*c+h,e[1]=n*r*c+s*l,e[2]=s*r*c-n*l,e[3]=0,e[4]=r*n*c-s*l,e[5]=n*n*c+h,e[6]=s*n*c+r*l,e[7]=0,e[8]=r*s*c+n*l,e[9]=n*s*c-r*l,e[10]=s*s*c+h,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},t.frustum=function(e,t,i,a,r,n,s){var o=1/(i-t),l=1/(r-a),h=1/(n-s);return e[0]=2*n*o,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=2*n*l,e[6]=0,e[7]=0,e[8]=(i+t)*o,e[9]=(r+a)*l,e[10]=(s+n)*h,e[11]=-1,e[12]=0,e[13]=0,e[14]=s*n*2*h,e[15]=0,e},t.ortho=function(e,t,i,a,r,n,s){var o=1/(t-i),l=1/(a-r),h=1/(n-s);return e[0]=-2*o,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*h,e[11]=0,e[12]=(t+i)*o,e[13]=(r+a)*l,e[14]=(s+n)*h,e[15]=1,e};var a=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i]);return t.default=e,t}(i(0));function r(e,t,i){var a=t[0],r=t[1],n=t[2],s=t[3],o=t[4],l=t[5],h=t[6],c=t[7],d=t[8],m=t[9],f=t[10],u=t[11],v=t[12],g=t[13],p=t[14],x=t[15],M=i[0],w=i[1],A=i[2],b=i[3];return e[0]=M*a+w*o+A*d+b*v,e[1]=M*r+w*l+A*m+b*g,e[2]=M*n+w*h+A*f+b*p,e[3]=M*s+w*c+A*u+b*x,M=i[4],w=i[5],A=i[6],b=i[7],e[4]=M*a+w*o+A*d+b*v,e[5]=M*r+w*l+A*m+b*g,e[6]=M*n+w*h+A*f+b*p,e[7]=M*s+w*c+A*u+b*x,M=i[8],w=i[9],A=i[10],b=i[11],e[8]=M*a+w*o+A*d+b*v,e[9]=M*r+w*l+A*m+b*g,e[10]=M*n+w*h+A*f+b*p,e[11]=M*s+w*c+A*u+b*x,M=i[12],w=i[13],A=i[14],b=i[15],e[12]=M*a+w*o+A*d+b*v,e[13]=M*r+w*l+A*m+b*g,e[14]=M*n+w*h+A*f+b*p,e[15]=M*s+w*c+A*u+b*x,e}}])});let canvasWidth,canvasHeight,b,B,angle,Zoom0,viewportmargin,zoomFactor,zoomPinchFactor,zoomPinchCap,zoomStep,shiftHoldDistance,shiftWaitTime,vibrateTime,embedded,canvas,gl,alpha,offscreen,context,maxMaterials,halfCanvasWidth,halfCanvasHeight,Zoom,P=[],Materials=[],Lights=[],Centers=[],Background=[1,1,1,1],absolute=!1,viewportshift=[0,0],nlights=0,Nmaterials=1,materials=[],pixel=.75,BezierFactor=.4,FillFactor=.1,maxViewportWidth=window.innerWidth,maxViewportHeight=window.innerHeight;const windowTrim=10;let lastzoom,H,zmin,zmax,size2,ArcballFactor,positionBuffer,materialBuffer,colorBuffer,indexBuffer,resizeStep=1.2,Fuzz2=1e3*Number.EPSILON,Fuzz4=Fuzz2*Fuzz2,third=1/3,rotMat=mat4.create(),projMat=mat4.create(),viewMat=mat4.create(),projViewMat=mat4.create(),normMat=mat3.create(),viewMat3=mat3.create(),rotMats=mat4.create(),cjMatInv=mat4.create(),translMat=mat4.create(),center={x:0,y:0,z:0},shift={x:0,y:0},viewParam={xmin:0,xmax:0,ymin:0,ymax:0,zmin:0,zmax:0},redraw=!0,remesh=!0,mouseDownOrTouchActive=!1,lastMouseX=null,lastMouseY=null,touchID=null,Positions=[],Normals=[],Colors=[],Indices=[];class Material{constructor(e,t,i,a,r,n){this.diffuse=e,this.emissive=t,this.specular=i,this.shininess=a,this.metallic=r,this.fresnel0=n}setUniform(e,t){let i=i=>gl.getUniformLocation(e,"Materials["+t+"]."+i);gl.uniform4fv(i("diffuse"),new Float32Array(this.diffuse)),gl.uniform4fv(i("emissive"),new Float32Array(this.emissive)),gl.uniform4fv(i("specular"),new Float32Array(this.specular)),gl.uniform4f(i("parameters"),this.shininess,this.metallic,this.fresnel0,0)}}let indexExt,enumPointLight=1,enumDirectionalLight=2;class Light{constructor(e,t){this.direction=e,this.color=t}setUniform(e,t){let i=i=>gl.getUniformLocation(e,"Lights["+t+"]."+i);gl.uniform3fv(i("direction"),new Float32Array(this.direction)),gl.uniform3fv(i("color"),new Float32Array(this.color))}}function initShaders(){let e=gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS);maxMaterials=Math.floor((e-14)/4),Nmaterials=Math.min(Math.max(Nmaterials,Materials.length),maxMaterials),noNormalShader=initShader(),pixelShader=initShader(["WIDTH"]),materialShader=initShader(["NORMAL"]),colorShader=initShader(["NORMAL","COLOR"]),transparentShader=initShader(["NORMAL","COLOR","TRANSPARENT"])}function setBuffers(){positionBuffer=gl.createBuffer(),materialBuffer=gl.createBuffer(),colorBuffer=gl.createBuffer(),indexBuffer=gl.createBuffer()}function noGL(){gl||alert("Could not initialize WebGL")}function saveAttributes(){let e=window.parent.document.asygl[alpha];e.gl=gl,e.nlights=Lights.length,e.Nmaterials=Nmaterials,e.maxMaterials=maxMaterials,e.noNormalShader=noNormalShader,e.pixelShader=pixelShader,e.materialShader=materialShader,e.colorShader=colorShader,e.transparentShader=transparentShader}function restoreAttributes(){let e=window.parent.document.asygl[alpha];gl=e.gl,nlights=e.nlights,Nmaterials=e.Nmaterials,maxMaterials=e.maxMaterials,noNormalShader=e.noNormalShader,pixelShader=e.pixelShader,materialShader=e.materialShader,colorShader=e.colorShader,transparentShader=e.transparentShader}function initGL(){if(alpha=Background[3]<1,embedded){let e=window.parent.document;null==e.asygl&&(e.asygl=Array(2)),context=canvas.getContext("2d"),(offscreen=e.offscreen)||(offscreen=e.createElement("canvas"),e.offscreen=offscreen),e.asygl[alpha]&&e.asygl[alpha].gl?(restoreAttributes(),(Lights.length!=nlights||Math.min(Materials.length,maxMaterials)>Nmaterials)&&(initShaders(),saveAttributes())):((gl=offscreen.getContext("webgl",{alpha:alpha}))||noGL(),initShaders(),e.asygl[alpha]={},saveAttributes())}else(gl=canvas.getContext("webgl",{alpha:alpha}))||noGL(),initShaders();setBuffers(),indexExt=gl.getExtension("OES_element_index_uint")}function getShader(e,t,i,a=[]){let r=`#version 100\n#ifdef GL_FRAGMENT_PRECISION_HIGH\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n  #define nlights ${Lights.length}\n\n  const int Nlights=${Math.max(Lights.length,1)};\n\n  #define Nmaterials ${Nmaterials}\n`;orthographic&&(r+="#define ORTHOGRAPHIC\n"),a.forEach(e=>r+="#define "+e+"\n");let n=e.createShader(i);return e.shaderSource(n,r+t),e.compileShader(n),e.getShaderParameter(n,e.COMPILE_STATUS)?n:(alert(e.getShaderInfoLog(n)),null)}function drawBuffer(e,t,i=e.indices){if(0==e.indices.length)return;let a=t==pixelShader,r=t!=noNormalShader&&!a;setUniforms(e,t),gl.bindBuffer(gl.ARRAY_BUFFER,positionBuffer),gl.bufferData(gl.ARRAY_BUFFER,new Float32Array(e.vertices),gl.STATIC_DRAW),gl.vertexAttribPointer(t.vertexPositionAttribute,3,gl.FLOAT,!1,r?24:a?16:12,0),r&&Lights.length>0?gl.vertexAttribPointer(t.vertexNormalAttribute,3,gl.FLOAT,!1,24,12):a&&gl.vertexAttribPointer(t.vertexWidthAttribute,1,gl.FLOAT,!1,16,12),-1!=t.vertexMaterialAttribute&&(gl.bindBuffer(gl.ARRAY_BUFFER,materialBuffer),gl.bufferData(gl.ARRAY_BUFFER,new Int16Array(e.materialIndices),gl.STATIC_DRAW),gl.vertexAttribPointer(t.vertexMaterialAttribute,1,gl.SHORT,!1,2,0)),t!=colorShader&&t!=transparentShader||(gl.bindBuffer(gl.ARRAY_BUFFER,colorBuffer),gl.bufferData(gl.ARRAY_BUFFER,new Uint8Array(e.colors),gl.STATIC_DRAW),gl.vertexAttribPointer(t.vertexColorAttribute,4,gl.UNSIGNED_BYTE,!0,0,0)),gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,indexBuffer),gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,indexExt?new Uint32Array(i):new Uint16Array(i),gl.STATIC_DRAW),gl.drawElements(r?gl.TRIANGLES:a?gl.POINTS:gl.LINES,i.length,indexExt?gl.UNSIGNED_INT:gl.UNSIGNED_SHORT,0),embedded&&context.drawImage(offscreen,0,0)}class vertexBuffer{constructor(){this.clear()}clear(){this.vertices=[],this.materialIndices=[],this.colors=[],this.indices=[],this.nvertices=0,this.materials=[],this.materialTable=[]}vertex(e,t){return this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.vertices.push(t[0]),this.vertices.push(t[1]),this.vertices.push(t[2]),this.materialIndices.push(materialIndex),this.nvertices++}Vertex(e,t,i=[0,0,0,0]){return this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.vertices.push(t[0]),this.vertices.push(t[1]),this.vertices.push(t[2]),this.materialIndices.push(materialIndex),this.colors.push(i[0]),this.colors.push(i[1]),this.colors.push(i[2]),this.colors.push(i[3]),this.nvertices++}vertex1(e){return this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.materialIndices.push(materialIndex),this.nvertices++}vertex0(e,t){return this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.vertices.push(t),this.materialIndices.push(materialIndex),this.nvertices++}iVertex(e,t,i,a=[0,0,0,0]){let r=6*e;this.vertices[r]=t[0],this.vertices[r+1]=t[1],this.vertices[r+2]=t[2],this.vertices[r+3]=i[0],this.vertices[r+4]=i[1],this.vertices[r+5]=i[2],this.materialIndices[e]=materialIndex;let n=4*e;this.colors[n]=a[0],this.colors[n+1]=a[1],this.colors[n+2]=a[2],this.colors[n+3]=a[3],this.indices.push(e)}append(e){append(this.vertices,e.vertices),append(this.materialIndices,e.materialIndices),append(this.colors,e.colors),appendOffset(this.indices,e.indices,this.nvertices),this.nvertices+=e.nvertices}}let materialIndex,material0Data=new vertexBuffer,material1Data=new vertexBuffer,materialData=new vertexBuffer,colorData=new vertexBuffer,transparentData=new vertexBuffer,triangleData=new vertexBuffer;function append(e,t){let i=e.length,a=t.length;e.length+=a;for(let r=0;r<a;++r)e[i+r]=t[r]}function appendOffset(e,t,i){let a=e.length,r=t.length;e.length+=t.length;for(let n=0;n<r;++n)e[a+n]=t[n]+i}class Geometry{constructor(){this.data=new vertexBuffer,this.Onscreen=!1,this.m=[]}offscreen(e){let t=projViewMat,i=e[0],a=i[0],r=i[1],n=i[2],s=1/(t[3]*a+t[7]*r+t[11]*n+t[15]);this.x=this.X=(t[0]*a+t[4]*r+t[8]*n+t[12])*s,this.y=this.Y=(t[1]*a+t[5]*r+t[9]*n+t[13])*s;for(let i=1,a=e.length;i<a;++i){let a=e[i],r=a[0],n=a[1],s=a[2],o=1/(t[3]*r+t[7]*n+t[11]*s+t[15]),l=(t[0]*r+t[4]*n+t[8]*s+t[12])*o,h=(t[1]*r+t[5]*n+t[9]*s+t[13])*o;l<this.x?this.x=l:l>this.X&&(this.X=l),h<this.y?this.y=h:h>this.Y&&(this.Y=h)}return(this.X<-1.01||this.x>1.01||this.Y<-1.01||this.y>1.01)&&(this.Onscreen=!1,!0)}T(e){let t=this.c[0],i=this.c[1],a=this.c[2],r=e[0]-t,n=e[1]-i,s=e[2]-a;return[r*normMat[0]+n*normMat[3]+s*normMat[6]+t,r*normMat[1]+n*normMat[4]+s*normMat[7]+i,r*normMat[2]+n*normMat[5]+s*normMat[8]+a]}Tcorners(e,t){return[this.T(e),this.T([e[0],e[1],t[2]]),this.T([e[0],t[1],e[2]]),this.T([e[0],t[1],t[2]]),this.T([t[0],e[1],e[2]]),this.T([t[0],e[1],t[2]]),this.T([t[0],t[1],e[2]]),this.T(t)]}setMaterial(e,t){null==e.materialTable[this.MaterialIndex]&&(e.materials.length>=Nmaterials&&t(),e.materialTable[this.MaterialIndex]=e.materials.length,e.materials.push(Materials[this.MaterialIndex])),materialIndex=e.materialTable[this.MaterialIndex]}render(){let e;if(this.setMaterialIndex(),0==this.CenterIndex?e=corners(this.Min,this.Max):(this.c=Centers[this.CenterIndex-1],e=this.Tcorners(this.Min,this.Max)),this.offscreen(e))return void this.data.clear();let t,i=this.controlpoints;if(0==this.CenterIndex){if(!remesh&&this.Onscreen)return void this.append();t=i}else{let e=i.length;t=Array(e);for(let a=0;a<e;++a)t[a]=this.T(i[a])}let a=orthographic?1:this.Min[2]/B[2],r=pixel*Math.hypot(a*(viewParam.xmax-viewParam.xmin),a*(viewParam.ymax-viewParam.ymin))/size2;this.res2=r*r,this.Epsilon=FillFactor*r,this.data.clear(),this.Onscreen=!0,this.process(t)}}class BezierPatch extends Geometry{constructor(e,t,i,a,r,n){super(),this.controlpoints=e,this.Min=a,this.Max=r,this.color=n,this.CenterIndex=t;let s=e.length;if(n){let e=n[0][3]+n[1][3]+n[2][3];this.transparent=16==s||4==s?e+n[3][3]<1020:e<765}else this.transparent=Materials[i].diffuse[3]<1;this.MaterialIndex=i,this.vertex=this.transparent?this.data.Vertex.bind(this.data):this.data.vertex.bind(this.data),this.L2norm(this.controlpoints)}setMaterialIndex(){this.transparent?this.setMaterial(transparentData,drawTransparent):this.color?this.setMaterial(colorData,drawColor):this.setMaterial(materialData,drawMaterial)}L2norm(e){let t=e[0];this.epsilon=0;let i=e.length;for(let a=1;a<i;++a)this.epsilon=Math.max(this.epsilon,abs2([e[a][0]-t[0],e[a][1]-t[1],e[a][2]-t[2]]));this.epsilon*=Fuzz4}processTriangle(e){let t=e[0],i=e[1],a=e[2],r=unit(cross([i[0]-t[0],i[1]-t[1],i[2]-t[2]],[a[0]-t[0],a[1]-t[1],a[2]-t[2]]));this.offscreen([t,i,a])||(this.color?(this.data.indices.push(this.data.Vertex(t,r,this.color[0])),this.data.indices.push(this.data.Vertex(i,r,this.color[1])),this.data.indices.push(this.data.Vertex(a,r,this.color[2]))):(this.data.indices.push(this.vertex(t,r)),this.data.indices.push(this.vertex(i,r)),this.data.indices.push(this.vertex(a,r))),this.append())}processQuad(e){let t=e[0],i=e[1],a=e[2],r=e[3],n=cross([i[0]-t[0],i[1]-t[1],i[2]-t[2]],[a[0]-i[0],a[1]-i[1],a[2]-i[2]]),s=cross([a[0]-r[0],a[1]-r[1],a[2]-r[2]],[r[0]-t[0],r[1]-t[1],r[2]-t[2]]),o=unit([n[0]+s[0],n[1]+s[1],n[2]+s[2]]);if(!this.offscreen([t,i,a,r])){let e,n,s,l;this.color?(e=this.data.Vertex(t,o,this.color[0]),n=this.data.Vertex(i,o,this.color[1]),s=this.data.Vertex(a,o,this.color[2]),l=this.data.Vertex(r,o,this.color[3])):(e=this.vertex(t,o),n=this.vertex(i,o),s=this.vertex(a,o),l=this.vertex(r,o)),this.data.indices.push(e),this.data.indices.push(n),this.data.indices.push(s),this.data.indices.push(e),this.data.indices.push(s),this.data.indices.push(l),this.append()}}process(e){if(this.transparent&&(materialIndex=this.color?-1-materialIndex:1+materialIndex),10==e.length)return this.process3(e);if(3==e.length)return this.processTriangle(e);if(4==e.length)return this.processQuad(e);let t=e[0],i=e[3],a=e[12],r=e[15],n=this.normal(i,e[2],e[1],t,e[4],e[8],a);iszero(n)&&iszero(n=this.normal(i,e[2],e[1],t,e[13],e[14],r))&&(n=this.normal(r,e[11],e[7],i,e[4],e[8],a));let s=this.normal(t,e[4],e[8],a,e[13],e[14],r);iszero(s)&&iszero(s=this.normal(t,e[4],e[8],a,e[11],e[7],i))&&(s=this.normal(i,e[2],e[1],t,e[13],e[14],r));let o=this.normal(a,e[13],e[14],r,e[11],e[7],i);iszero(o)&&iszero(o=this.normal(a,e[13],e[14],r,e[2],e[1],t))&&(o=this.normal(t,e[4],e[8],a,e[11],e[7],i));let l=this.normal(r,e[11],e[7],i,e[2],e[1],t);if(iszero(l)&&iszero(l=this.normal(r,e[11],e[7],i,e[4],e[8],a))&&(l=this.normal(a,e[13],e[14],r,e[2],e[1],t)),this.color){let h=this.color[0],c=this.color[1],d=this.color[2],m=this.color[3],f=this.data.Vertex(t,n,h),u=this.data.Vertex(a,s,c),v=this.data.Vertex(r,o,d),g=this.data.Vertex(i,l,m);this.Render(e,f,u,v,g,t,a,r,i,!1,!1,!1,!1,h,c,d,m)}else{let h=this.vertex(t,n),c=this.vertex(a,s),d=this.vertex(r,o),m=this.vertex(i,l);this.Render(e,h,c,d,m,t,a,r,i,!1,!1,!1,!1)}this.data.indices.length>0&&this.append()}append(){this.transparent?transparentData.append(this.data):this.color?colorData.append(this.data):materialData.append(this.data)}Render(e,t,i,a,r,n,s,o,l,h,c,d,m,f,u,v,g){if(this.Distance(e)<this.res2)this.offscreen([n,s,o])||(this.data.indices.push(t),this.data.indices.push(i),this.data.indices.push(a)),this.offscreen([n,o,l])||(this.data.indices.push(t),this.data.indices.push(a),this.data.indices.push(r));else{if(this.offscreen(e))return;let p=e[0],x=e[3],M=e[12],w=e[15],A=new Split3(p,e[1],e[2],x),b=new Split3(e[4],e[5],e[6],e[7]),S=new Split3(e[8],e[9],e[10],e[11]),R=new Split3(M,e[13],e[14],w),P=new Split3(p,e[4],e[8],M),D=new Split3(A.m0,b.m0,S.m0,R.m0),T=new Split3(A.m3,b.m3,S.m3,R.m3),y=new Split3(A.m5,b.m5,S.m5,R.m5),I=new Split3(A.m4,b.m4,S.m4,R.m4),z=new Split3(A.m2,b.m2,S.m2,R.m2),O=new Split3(x,e[7],e[11],w),E=[p,A.m0,A.m3,A.m5,P.m0,D.m0,T.m0,y.m0,P.m3,D.m3,T.m3,y.m3,P.m5,D.m5,T.m5,y.m5],_=[P.m5,D.m5,T.m5,y.m5,P.m4,D.m4,T.m4,y.m4,P.m2,D.m2,T.m2,y.m2,M,R.m0,R.m3,R.m5],L=[y.m5,I.m5,z.m5,O.m5,y.m4,I.m4,z.m4,O.m4,y.m2,I.m2,z.m2,O.m2,R.m5,R.m4,R.m2,w],N=[A.m5,A.m4,A.m2,x,y.m0,I.m0,z.m0,O.m0,y.m3,I.m3,z.m3,O.m3,y.m5,I.m5,z.m5,O.m5],C=E[15],B=this.normal(E[0],E[4],E[8],E[12],E[13],E[14],E[15]);iszero(B)&&iszero(B=this.normal(E[0],E[4],E[8],E[12],E[11],E[7],E[3]))&&(B=this.normal(E[3],E[2],E[1],E[0],E[13],E[14],E[15]));let F=this.normal(_[12],_[13],_[14],_[15],_[11],_[7],_[3]);iszero(F)&&iszero(F=this.normal(_[12],_[13],_[14],_[15],_[2],_[1],_[0]))&&(F=this.normal(_[0],_[4],_[8],_[12],_[11],_[7],_[3]));let V=this.normal(L[15],L[11],L[7],L[3],L[2],L[1],L[0]);iszero(V)&&iszero(V=this.normal(L[15],L[11],L[7],L[3],L[4],L[8],L[12]))&&(V=this.normal(L[12],L[13],L[14],L[15],L[2],L[1],L[0]));let H=this.normal(N[3],N[2],N[1],N[0],N[4],N[8],N[12]);iszero(H)&&iszero(H=this.normal(N[3],N[2],N[1],N[0],N[13],N[14],N[15]))&&(H=this.normal(N[15],N[11],N[7],N[3],N[4],N[8],N[12]));let G=this.normal(L[3],L[2],L[1],C,L[4],L[8],L[12]),U=this.Epsilon,W=[.5*(n[0]+s[0]),.5*(n[1]+s[1]),.5*(n[2]+s[2])];if(!h)if(h=Straightness(p,e[4],e[8],M)<this.res2){let e=unit(this.derivative(_[0],_[1],_[2],_[3]));W=[W[0]-U*e[0],W[1]-U*e[1],W[2]-U*e[2]]}else W=E[12];let Y=[.5*(s[0]+o[0]),.5*(s[1]+o[1]),.5*(s[2]+o[2])];if(!c)if(c=Straightness(M,e[13],e[14],w)<this.res2){let e=unit(this.derivative(L[12],L[8],L[4],L[0]));Y=[Y[0]-U*e[0],Y[1]-U*e[1],Y[2]-U*e[2]]}else Y=_[15];let j=[.5*(o[0]+l[0]),.5*(o[1]+l[1]),.5*(o[2]+l[2])];if(!d)if(d=Straightness(w,e[11],e[7],x)<this.res2){let e=unit(this.derivative(N[15],L[14],L[13],_[12]));j=[j[0]-U*e[0],j[1]-U*e[1],j[2]-U*e[2]]}else j=L[3];let k=[.5*(l[0]+n[0]),.5*(l[1]+n[1]),.5*(l[2]+n[2])];if(!m)if(m=Straightness(p,e[1],e[2],x)<this.res2){let e=unit(this.derivative(E[3],E[7],E[11],E[15]));k=[k[0]-U*e[0],k[1]-U*e[1],k[2]-U*e[2]]}else k=N[0];if(f){let e=Array(4),p=Array(4),x=Array(4),M=Array(4),w=Array(4);for(let t=0;t<4;++t)e[t]=.5*(f[t]+u[t]),p[t]=.5*(u[t]+v[t]),x[t]=.5*(v[t]+g[t]),M[t]=.5*(g[t]+f[t]),w[t]=.5*(e[t]+x[t]);let A=this.data.Vertex(W,B,e),b=this.data.Vertex(Y,F,p),S=this.data.Vertex(j,V,x),R=this.data.Vertex(k,H,M),P=this.data.Vertex(C,G,w);this.Render(E,t,A,P,R,n,W,C,k,h,!1,!1,m,f,e,w,M),this.Render(_,A,i,b,P,W,s,Y,C,h,c,!1,!1,e,u,p,w),this.Render(L,P,b,a,S,C,Y,o,j,!1,c,d,!1,w,p,v,x),this.Render(N,R,P,S,r,k,C,j,l,!1,!1,d,m,M,w,x,g)}else{let e=this.vertex(W,B),f=this.vertex(Y,F),u=this.vertex(j,V),v=this.vertex(k,H),g=this.vertex(C,G);this.Render(E,t,e,g,v,n,W,C,k,h,!1,!1,m),this.Render(_,e,i,f,g,W,s,Y,C,h,c,!1,!1),this.Render(L,g,f,a,u,C,Y,o,j,!1,c,d,!1),this.Render(N,v,g,u,r,k,C,j,l,!1,!1,d,m)}}}process3(e){this.Res2=BezierFactor*BezierFactor*this.res2;let t=e[0],i=e[6],a=e[9],r=this.normal(a,e[5],e[2],t,e[1],e[3],i),n=this.normal(t,e[1],e[3],i,e[7],e[8],a),s=this.normal(i,e[7],e[8],a,e[5],e[2],t);if(this.color){let o=this.color[0],l=this.color[1],h=this.color[2],c=this.data.Vertex(t,r,o),d=this.data.Vertex(i,n,l),m=this.data.Vertex(a,s,h);this.Render3(e,c,d,m,t,i,a,!1,!1,!1,o,l,h)}else{let o=this.vertex(t,r),l=this.vertex(i,n),h=this.vertex(a,s);this.Render3(e,o,l,h,t,i,a,!1,!1,!1)}this.data.indices.length>0&&this.append()}Render3(e,t,i,a,r,n,s,o,l,h,c,d,m){if(this.Distance3(e)<this.Res2)this.offscreen([r,n,s])||(this.data.indices.push(t),this.data.indices.push(i),this.data.indices.push(a));else{if(this.offscreen(e))return;let f=e[0],u=e[1],v=e[2],g=e[3],p=e[4],x=e[5],M=e[6],w=e[7],A=e[8],b=e[9],S=[.5*(b[0]+x[0]),.5*(b[1]+x[1]),.5*(b[2]+x[2])],R=[.5*(b[0]+A[0]),.5*(b[1]+A[1]),.5*(b[2]+A[2])],P=[.5*(x[0]+v[0]),.5*(x[1]+v[1]),.5*(x[2]+v[2])],D=[.5*(A[0]+p[0]),.5*(A[1]+p[1]),.5*(A[2]+p[2])],T=[.5*(A[0]+w[0]),.5*(A[1]+w[1]),.5*(A[2]+w[2])],y=[.5*(v[0]+p[0]),.5*(v[1]+p[1]),.5*(v[2]+p[2])],I=[.5*(v[0]+f[0]),.5*(v[1]+f[1]),.5*(v[2]+f[2])],z=[.5*(p[0]+g[0]),.5*(p[1]+g[1]),.5*(p[2]+g[2])],O=[.5*(w[0]+M[0]),.5*(w[1]+M[1]),.5*(w[2]+M[2])],E=[.5*(f[0]+u[0]),.5*(f[1]+u[1]),.5*(f[2]+u[2])],_=[.5*(u[0]+g[0]),.5*(u[1]+g[1]),.5*(u[2]+g[2])],L=[.5*(g[0]+M[0]),.5*(g[1]+M[1]),.5*(g[2]+M[2])],N=[.5*(S[0]+P[0]),.5*(S[1]+P[1]),.5*(S[2]+P[2])],C=[.5*(R[0]+T[0]),.5*(R[1]+T[1]),.5*(R[2]+T[2])],B=[.5*(P[0]+I[0]),.5*(P[1]+I[1]),.5*(P[2]+I[2])],F=[.5*D[0]+.25*(p[0]+u[0]),.5*D[1]+.25*(p[1]+u[1]),.5*D[2]+.25*(p[2]+u[2])],V=[.5*(T[0]+O[0]),.5*(T[1]+O[1]),.5*(T[2]+O[2])],H=[.5*y[0]+.25*(p[0]+w[0]),.5*y[1]+.25*(p[1]+w[1]),.5*y[2]+.25*(p[2]+w[2])],G=[.25*(x[0]+p[0])+.5*z[0],.25*(x[1]+p[1])+.5*z[1],.25*(x[2]+p[2])+.5*z[2]],U=[.5*(E[0]+_[0]),.5*(E[1]+_[1]),.5*(E[2]+_[2])],W=[.5*(_[0]+L[0]),.5*(_[1]+L[1]),.5*(_[2]+L[2])],Y=[.5*(H[0]+U[0]),.5*(H[1]+U[1]),.5*(H[2]+U[2])],j=[.5*(H[0]+W[0]),.5*(H[1]+W[1]),.5*(H[2]+W[2])],k=[.5*(U[0]+W[0]),.5*(U[1]+W[1]),.5*(U[2]+W[2])],X=[.5*(G[0]+V[0]),.5*(G[1]+V[1]),.5*(G[2]+V[2])],Z=[.5*(C[0]+G[0]),.5*(C[1]+G[1]),.5*(C[2]+G[2])],q=[.5*(C[0]+V[0]),.5*(C[1]+V[1]),.5*(C[2]+V[2])],K=[.5*(N[0]+F[0]),.5*(N[1]+F[1]),.5*(N[2]+F[2])],$=[.5*(B[0]+F[0]),.5*(B[1]+F[1]),.5*(B[2]+F[2])],Q=[.5*(N[0]+B[0]),.5*(N[1]+B[1]),.5*(N[2]+B[2])],J=[f,E,I,U,[.5*(y[0]+E[0]),.5*(y[1]+E[1]),.5*(y[2]+E[2])],B,k,Y,$,Q],ee=[k,W,j,L,[.5*(z[0]+O[0]),.5*(z[1]+O[1]),.5*(z[2]+O[2])],X,M,O,V,q],te=[Q,K,N,Z,[.5*(S[0]+D[0]),.5*(S[1]+D[1]),.5*(S[2]+D[2])],S,q,C,R,b],ie=[q,Z,X,K,[.25*(P[0]+T[0]+_[0]+p[0]),.25*(P[1]+T[1]+_[1]+p[1]),.25*(P[2]+T[2]+_[2]+p[2])],j,Q,$,Y,k],ae=this.normal(k,j,X,q,Z,K,Q),re=this.normal(q,Z,K,Q,$,Y,k),ne=this.normal(Q,$,Y,k,j,X,q),se=this.Epsilon,oe=[.5*(n[0]+s[0]),.5*(n[1]+s[1]),.5*(n[2]+s[2])];if(!o)if(o=Straightness(M,w,A,b)<this.res2){let e=unit(this.sumderivative(ie[0],ie[2],ie[5],ie[9],ie[1],ie[3],ie[6]));oe=[oe[0]-se*e[0],oe[1]-se*e[1],oe[2]-se*e[2]]}else oe=q;let le=[.5*(s[0]+r[0]),.5*(s[1]+r[1]),.5*(s[2]+r[2])];if(!l)if(l=Straightness(f,v,x,b)<this.res2){let e=unit(this.sumderivative(ie[6],ie[3],ie[1],ie[0],ie[7],ie[8],ie[9]));le=[le[0]-se*e[0],le[1]-se*e[1],le[2]-se*e[2]]}else le=Q;let he=[.5*(r[0]+n[0]),.5*(r[1]+n[1]),.5*(r[2]+n[2])];if(!h)if(h=Straightness(f,u,g,M)<this.res2){let e=unit(this.sumderivative(ie[9],ie[8],ie[7],ie[6],ie[5],ie[2],ie[0]));he=[he[0]-se*e[0],he[1]-se*e[1],he[2]-se*e[2]]}else he=k;if(c){let e=Array(4),f=Array(4),u=Array(4);for(let t=0;t<4;++t)e[t]=.5*(d[t]+m[t]),f[t]=.5*(m[t]+c[t]),u[t]=.5*(c[t]+d[t]);let v=this.data.Vertex(oe,ae,e),g=this.data.Vertex(le,re,f),p=this.data.Vertex(he,ne,u);this.Render3(J,t,p,g,r,he,le,!1,l,h,c,u,f),this.Render3(ee,p,i,v,he,n,oe,o,!1,h,u,d,e),this.Render3(te,g,v,a,le,oe,s,o,l,!1,f,e,m),this.Render3(ie,v,g,p,oe,le,he,!1,!1,!1,e,f,u)}else{let e=this.vertex(oe,ae),c=this.vertex(le,re),d=this.vertex(he,ne);this.Render3(J,t,d,c,r,he,le,!1,l,h),this.Render3(ee,d,i,e,he,n,oe,o,!1,h),this.Render3(te,c,e,a,le,oe,s,o,l,!1),this.Render3(ie,e,c,d,oe,le,he,!1,!1,!1)}}}Distance(e){let t=e[0],i=e[3],a=e[12],r=e[15],n=Distance2(r,t,this.normal(i,e[2],e[1],t,e[4],e[8],a));return n=Math.max(n,Straightness(t,e[1],e[2],i)),n=Math.max(n,Straightness(t,e[4],e[8],a)),n=Math.max(n,Straightness(i,e[7],e[11],r)),n=Math.max(n,Straightness(a,e[13],e[14],r)),n=Math.max(n,Straightness(e[4],e[5],e[6],e[7])),n=Math.max(n,Straightness(e[8],e[9],e[10],e[11])),n=Math.max(n,Straightness(e[1],e[5],e[9],e[13])),Math.max(n,Straightness(e[2],e[6],e[10],e[14]))}Distance3(e){let t=e[0],i=e[4],a=e[6],r=e[9],n=abs2([(t[0]+a[0]+r[0])*third-i[0],(t[1]+a[1]+r[1])*third-i[1],(t[2]+a[2]+r[2])*third-i[2]]);return n=Math.max(n,Straightness(t,e[1],e[3],a)),n=Math.max(n,Straightness(t,e[2],e[5],r)),Math.max(n,Straightness(a,e[7],e[8],r))}derivative(e,t,i,a){let r=[t[0]-e[0],t[1]-e[1],t[2]-e[2]];if(abs2(r)>this.epsilon)return r;let n=bezierPP(e,t,i);return abs2(n)>this.epsilon?n:bezierPPP(e,t,i,a)}sumderivative(e,t,i,a,r,n,s){let o=this.derivative(e,t,i,a),l=this.derivative(e,r,n,s);return[o[0]+l[0],o[1]+l[1],o[2]+l[2]]}normal(e,t,i,a,r,n,s){let o=r[0]-a[0],l=r[1]-a[1],h=r[2]-a[2],c=i[0]-a[0],d=i[1]-a[1],m=i[2]-a[2],f=[l*m-h*d,h*c-o*m,o*d-l*c];if(abs2(f)>this.epsilon)return unit(f);let u=[c,d,m],v=[o,l,h],g=bezierPP(a,i,t),p=bezierPP(a,r,n),x=cross(p,u),M=cross(v,g);if(abs2(f=[x[0]+M[0],x[1]+M[1],x[2]+M[2]])>this.epsilon)return unit(f);let w=bezierPPP(a,i,t,e),A=bezierPPP(a,r,n,s);x=cross(p,g),M=cross(v,w);let b=cross(A,u),S=cross(A,g),R=cross(p,w),P=cross(A,w);return unit([9*x[0]+3*(M[0]+b[0]+S[0]+R[0])+P[0],9*x[1]+3*(M[1]+b[1]+S[1]+R[1])+P[1],9*x[2]+3*(M[2]+b[2]+S[2]+R[2])+P[2]])}}class BezierCurve extends Geometry{constructor(e,t,i,a,r){super(),this.controlpoints=e,this.Min=a,this.Max=r,this.CenterIndex=t,this.MaterialIndex=i}setMaterialIndex(){this.setMaterial(material1Data,drawMaterial1)}processLine(e){let t=e[0],i=e[1];this.offscreen([t,i])||(this.data.indices.push(this.data.vertex1(t)),this.data.indices.push(this.data.vertex1(i)),this.append())}process(e){if(2==e.length)return this.processLine(e);let t=this.data.vertex1(e[0]),i=this.data.vertex1(e[3]);this.Render(e,t,i),this.data.indices.length>0&&this.append()}append(){material1Data.append(this.data)}Render(e,t,i){let a=e[0],r=e[1],n=e[2],s=e[3];if(Straightness(a,r,n,s)<this.res2)this.offscreen([a,s])||(this.data.indices.push(t),this.data.indices.push(i));else{if(this.offscreen(e))return;let o=[.5*(a[0]+r[0]),.5*(a[1]+r[1]),.5*(a[2]+r[2])],l=[.5*(r[0]+n[0]),.5*(r[1]+n[1]),.5*(r[2]+n[2])],h=[.5*(n[0]+s[0]),.5*(n[1]+s[1]),.5*(n[2]+s[2])],c=[.5*(o[0]+l[0]),.5*(o[1]+l[1]),.5*(o[2]+l[2])],d=[.5*(l[0]+h[0]),.5*(l[1]+h[1]),.5*(l[2]+h[2])],m=[.5*(c[0]+d[0]),.5*(c[1]+d[1]),.5*(c[2]+d[2])],f=[a,o,c,m],u=[m,d,h,s],v=this.data.vertex1(m);this.Render(f,t,v),this.Render(u,v,i)}}}class Pixel extends Geometry{constructor(e,t,i,a,r){super(),this.controlpoint=e,this.width=t,this.CenterIndex=0,this.MaterialIndex=i,this.Min=a,this.Max=r}setMaterialIndex(){this.setMaterial(material0Data,drawMaterial0)}process(e){this.data.indices.push(this.data.vertex0(this.controlpoint,this.width)),this.append()}append(){material0Data.append(this.data)}}class Triangles extends Geometry{constructor(e,t,i){super(),this.CenterIndex=0,this.MaterialIndex=e,this.Min=t,this.Max=i,this.Positions=Positions,this.Normals=Normals,this.Colors=Colors,this.Indices=Indices,Positions=[],Normals=[],Colors=[],Indices=[],this.transparent=Materials[e].diffuse[3]<1}setMaterialIndex(){this.transparent?this.setMaterial(transparentData,drawTransparent):this.setMaterial(triangleData,drawTriangle)}process(e){materialIndex=this.Colors.length>0?-1-materialIndex:1+materialIndex;for(let e=0,t=this.Indices.length;e<t;++e){let t=this.Indices[e],i=t[0],a=this.Positions[i[0]],r=this.Positions[i[1]],n=this.Positions[i[2]];if(!this.offscreen([a,r,n])){let e=t.length>1?t[1]:i;if(e&&0!=e.length||(e=i),this.Colors.length>0){let s=t.length>2?t[2]:i;s&&0!=s.length||(s=i);let o=this.Colors[s[0]],l=this.Colors[s[1]],h=this.Colors[s[2]];this.transparent|=o[3]+l[3]+h[3]<765,this.data.iVertex(i[0],a,this.Normals[e[0]],o),this.data.iVertex(i[1],r,this.Normals[e[1]],l),this.data.iVertex(i[2],n,this.Normals[e[2]],h)}else this.data.iVertex(i[0],a,this.Normals[e[0]]),this.data.iVertex(i[1],r,this.Normals[e[1]]),this.data.iVertex(i[2],n,this.Normals[e[2]])}}this.data.nvertices=this.Positions.length,this.data.indices.length>0&&this.append()}append(){this.transparent?transparentData.append(this.data):triangleData.append(this.data)}}function home(){mat4.identity(rotMat),initProjection(),setProjection(),remesh=!0,redraw=!0}function initShader(e=[]){let t=getShader(gl,vertex,gl.VERTEX_SHADER,e),i=getShader(gl,fragment,gl.FRAGMENT_SHADER,e),a=gl.createProgram();return gl.attachShader(a,t),gl.attachShader(a,i),gl.linkProgram(a),gl.getProgramParameter(a,gl.LINK_STATUS)||alert("Could not initialize shaders"),a}class Split3{constructor(e,t,i,a){this.m0=[.5*(e[0]+t[0]),.5*(e[1]+t[1]),.5*(e[2]+t[2])];let r=.5*(t[0]+i[0]),n=.5*(t[1]+i[1]),s=.5*(t[2]+i[2]);this.m2=[.5*(i[0]+a[0]),.5*(i[1]+a[1]),.5*(i[2]+a[2])],this.m3=[.5*(this.m0[0]+r),.5*(this.m0[1]+n),.5*(this.m0[2]+s)],this.m4=[.5*(r+this.m2[0]),.5*(n+this.m2[1]),.5*(s+this.m2[2])],this.m5=[.5*(this.m3[0]+this.m4[0]),.5*(this.m3[1]+this.m4[1]),.5*(this.m3[2]+this.m4[2])]}}function iszero(e){return 0==e[0]&&0==e[1]&&0==e[2]}function unit(e){let t=1/(Math.sqrt(e[0]*e[0]+e[1]*e[1]+e[2]*e[2])||1);return[e[0]*t,e[1]*t,e[2]*t]}function abs2(e){return e[0]*e[0]+e[1]*e[1]+e[2]*e[2]}function dot(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]}function cross(e,t){return[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]}function bezierPP(e,t,i){return[e[0]+i[0]-2*t[0],e[1]+i[1]-2*t[1],e[2]+i[2]-2*t[2]]}function bezierPPP(e,t,i,a){return[a[0]-e[0]+3*(t[0]-i[0]),a[1]-e[1]+3*(t[1]-i[1]),a[2]-e[2]+3*(t[2]-i[2])]}function Straightness(e,t,i,a){let r=[third*(a[0]-e[0]),third*(a[1]-e[1]),third*(a[2]-e[2])];return Math.max(abs2([t[0]-r[0]-e[0],t[1]-r[1]-e[1],t[2]-r[2]-e[2]]),abs2([a[0]-r[0]-i[0],a[1]-r[1]-i[1],a[2]-r[2]-i[2]]))}function Distance2(e,t,i){let a=dot([e[0]-t[0],e[1]-t[1],e[2]-t[2]],i);return a*a}function corners(e,t){return[e,[e[0],e[1],t[2]],[e[0],t[1],e[2]],[e[0],t[1],t[2]],[t[0],e[1],e[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],t]}function COBTarget(e,t){mat4.fromTranslation(translMat,[center.x,center.y,center.z]),mat4.invert(cjMatInv,translMat),mat4.multiply(e,t,cjMatInv),mat4.multiply(e,translMat,e)}function setUniforms(e,t){let i=t==pixelShader;gl.useProgram(t),t.vertexPositionAttribute=gl.getAttribLocation(t,"position"),gl.enableVertexAttribArray(t.vertexPositionAttribute),i&&(t.vertexWidthAttribute=gl.getAttribLocation(t,"width"),gl.enableVertexAttribArray(t.vertexWidthAttribute));let a=t!=noNormalShader&&!i&&Lights.length>0;if(a&&(t.vertexNormalAttribute=gl.getAttribLocation(t,"normal"),gl.enableVertexAttribArray(t.vertexNormalAttribute)),t.vertexMaterialAttribute=gl.getAttribLocation(t,"materialIndex"),-1!=t.vertexMaterialAttribute&&gl.enableVertexAttribArray(t.vertexMaterialAttribute),t.projViewMatUniform=gl.getUniformLocation(t,"projViewMat"),t.viewMatUniform=gl.getUniformLocation(t,"viewMat"),t.normMatUniform=gl.getUniformLocation(t,"normMat"),t!=colorShader&&t!=transparentShader||(t.vertexColorAttribute=gl.getAttribLocation(t,"color"),gl.enableVertexAttribArray(t.vertexColorAttribute)),a)for(let e=0;e<Lights.length;++e)Lights[e].setUniform(t,e);if(-1!=t.vertexMaterialAttribute)for(let i=0;i<e.materials.length;++i)e.materials[i].setUniform(t,i);gl.uniformMatrix4fv(t.projViewMatUniform,!1,projViewMat),gl.uniformMatrix4fv(t.viewMatUniform,!1,viewMat),gl.uniformMatrix3fv(t.normMatUniform,!1,normMat)}function handleMouseDown(e){mouseDownOrTouchActive=!0,lastMouseX=e.clientX,lastMouseY=e.clientY}let pinchStart,touchStartTime,pinch=!1;function pinchDistance(e){return Math.hypot(e[0].pageX-e[1].pageX,e[0].pageY-e[1].pageY)}function handleTouchStart(e){e.preventDefault();let t=e.targetTouches;swipe=rotate=pinch=!1,zooming||(1!=t.length||mouseDownOrTouchActive||(touchStartTime=(new Date).getTime(),touchId=t[0].identifier,lastMouseX=t[0].pageX,lastMouseY=t[0].pageY),2!=t.length||mouseDownOrTouchActive||(touchId=t[0].identifier,pinchStart=pinchDistance(t),pinch=!0))}function handleMouseUpOrTouchEnd(e){mouseDownOrTouchActive=!1}function rotateScene(e,t,i,a,r){if(e==i&&t==a)return;let[n,s]=arcball([e,-t],[i,-a]);mat4.fromRotation(rotMats,2*r*ArcballFactor*n/lastzoom,s),mat4.multiply(rotMat,rotMats,rotMat)}function shiftScene(e,t,i,a){let r=1/lastzoom;shift.x+=(i-e)*r*halfCanvasWidth,shift.y-=(a-t)*r*halfCanvasHeight}function panScene(e,t,i,a){orthographic?shiftScene(e,t,i,a):(center.x+=(i-e)*(viewParam.xmax-viewParam.xmin),center.y-=(a-t)*(viewParam.ymax-viewParam.ymin))}function updateViewMatrix(){COBTarget(viewMat,rotMat),mat4.translate(viewMat,viewMat,[center.x,center.y,0]),mat3.fromMat4(viewMat3,viewMat),mat3.invert(normMat,viewMat3),mat4.multiply(projViewMat,projMat,viewMat)}function capzoom(){let e=Math.sqrt(Number.MAX_VALUE),t=1/e;Zoom<=t&&(Zoom=t),Zoom>=e&&(Zoom=e),Zoom!=lastzoom&&(remesh=!0),lastzoom=Zoom}function zoomImage(e){let t=zoomStep*halfCanvasHeight*e;const i=Math.log(.1*Number.MAX_VALUE)/Math.log(zoomFactor);Math.abs(t)<i&&(Zoom*=zoomFactor**t,capzoom())}function normMouse(e){let t=e[0],i=e[1],a=Math.hypot(t,i);return a>1&&(denom=1/a,t*=denom,i*=denom),[t,i,Math.sqrt(Math.max(1-i*i-t*t,0))]}function arcball(e,t){let i=normMouse(e),a=normMouse(t),r=dot(i,a);return r>1?r=1:r<-1&&(r=-1),[Math.acos(r),unit(cross(i,a))]}function zoomScene(e,t,i,a){zoomImage(t-a)}const DRAGMODE_ROTATE=1,DRAGMODE_SHIFT=2,DRAGMODE_ZOOM=3,DRAGMODE_PAN=4;function processDrag(e,t,i,a=1){let r;switch(i){case DRAGMODE_ROTATE:r=rotateScene;break;case DRAGMODE_SHIFT:r=shiftScene;break;case DRAGMODE_ZOOM:r=zoomScene;break;case DRAGMODE_PAN:r=panScene;break;default:r=((e,t,i,a)=>{})}r((lastMouseX-halfCanvasWidth)/halfCanvasWidth,(lastMouseY-halfCanvasHeight)/halfCanvasHeight,(e-halfCanvasWidth)/halfCanvasWidth,(t-halfCanvasHeight)/halfCanvasHeight,a),lastMouseX=e,lastMouseY=t,setProjection(),redraw=!0}function handleKey(e){let t=[];switch(e.key){case"x":t=[1,0,0];break;case"y":t=[0,1,0];break;case"z":t=[0,0,1];break;case"h":home();break;case"+":case"=":case">":expand();break;case"-":case"_":case"<":shrink()}t.length>0&&(mat4.rotate(rotMat,rotMat,.1,t),updateViewMatrix(),redraw=!0)}function handleMouseWheel(e){e.preventDefault(),e.deltaY<0?Zoom*=zoomFactor:Zoom/=zoomFactor,capzoom(),setProjection(),redraw=!0}function handleMouseMove(e){if(!mouseDownOrTouchActive)return;let t;processDrag(e.clientX,e.clientY,t=e.getModifierState("Control")?DRAGMODE_SHIFT:e.getModifierState("Shift")?DRAGMODE_ZOOM:e.getModifierState("Alt")?DRAGMODE_PAN:DRAGMODE_ROTATE)}let zooming=!1,swipe=!1,rotate=!1;function handleTouchMove(e){if(e.preventDefault(),zooming)return;let t=e.targetTouches;if(!pinch&&1==t.length&&touchId==t[0].identifier){let e=t[0].pageX,i=t[0].pageY,a=e-lastMouseX,r=i-lastMouseY,n=a*a+r*r<=shiftHoldDistance*shiftHoldDistance;if(n&&!swipe&&!rotate&&(new Date).getTime()-touchStartTime>shiftWaitTime&&(navigator.vibrate&&window.navigator.vibrate(vibrateTime),swipe=!0),swipe)processDrag(e,i,DRAGMODE_SHIFT);else if(!n){rotate=!0,processDrag(t[0].pageX,t[0].pageY,DRAGMODE_ROTATE,.5)}}if(pinch&&!swipe&&2==t.length&&touchId==t[0].identifier){let e=pinchDistance(t),i=e-pinchStart;zooming=!0,(i*=zoomPinchFactor)>zoomPinchCap&&(i=zoomPinchCap),i<-zoomPinchCap&&(i=-zoomPinchCap),zoomImage(i/size2),pinchStart=e,swipe=rotate=zooming=!1,setProjection(),redraw=!0}}let pixelShader,noNormalShader,materialShader,colorShader,transparentShader,zbuffer=[];function transformVertices(e){let t=viewMat[2],i=viewMat[6],a=viewMat[10];zbuffer.length=e.length;for(let r=0;r<e.length;++r){let n=6*r;zbuffer[r]=t*e[n]+i*e[n+1]+a*e[n+2]}}function drawMaterial0(){drawBuffer(material0Data,pixelShader),material0Data.clear()}function drawMaterial1(){drawBuffer(material1Data,noNormalShader),material1Data.clear()}function drawMaterial(){drawBuffer(materialData,materialShader),materialData.clear()}function drawColor(){drawBuffer(colorData,colorShader),colorData.clear()}function drawTriangle(){drawBuffer(triangleData,transparentShader),triangleData.clear()}function drawTransparent(){let e=transparentData.indices;if(e.length>0){transformVertices(transparentData.vertices);let t=e.length/3,i=Array(t).fill().map((e,t)=>t);i.sort(function(t,i){let a=3*t;Ia=e[a],Ib=e[a+1],Ic=e[a+2];let r=3*i;return IA=e[r],IB=e[r+1],IC=e[r+2],zbuffer[Ia]+zbuffer[Ib]+zbuffer[Ic]<zbuffer[IA]+zbuffer[IB]+zbuffer[IC]?-1:1});let a=Array(e.length);for(let r=0;r<t;++r){let t=3*i[r];a[3*r]=e[t],a[3*r+1]=e[t+1],a[3*r+2]=e[t+2]}gl.depthMask(!1),drawBuffer(transparentData,transparentShader,a),gl.depthMask(!0)}transparentData.clear()}function drawBuffers(){drawMaterial0(),drawMaterial1(),drawMaterial(),drawColor(),drawTriangle(),drawTransparent()}function draw(){embedded&&(offscreen.width=canvas.width,offscreen.height=canvas.height,setViewport()),gl.clearColor(Background[0],Background[1],Background[2],Background[3]),gl.clear(gl.COLOR_BUFFER_BIT|gl.DEPTH_BUFFER_BIT);for(let e=0;e<P.length;++e)P[e].render();drawBuffers(),remesh=!1}function tick(){requestAnimationFrame(tick),redraw&&(draw(),redraw=!1)}function setDimensions(e,t,i,a){let r=e/t,n=1/lastzoom,s=(i/e+viewportshift[0])*lastzoom,o=(a/t+viewportshift[1])*lastzoom;if(orthographic){let e=B[0]-b[0],t=B[1]-b[1];if(e<t*r){let e=.5*t*r*n,i=2*e*s,a=t*n*o;viewParam.xmin=-e-i,viewParam.xmax=e-i,viewParam.ymin=b[1]*n-a,viewParam.ymax=B[1]*n-a}else{let t=.5*e/(r*Zoom),i=e*n*s,a=2*t*o;viewParam.xmin=b[0]*n-i,viewParam.xmax=B[0]*n-i,viewParam.ymin=-t-a,viewParam.ymax=t-a}}else{let e=H*n,t=e*r,i=2*t*s,a=2*e*o;viewParam.xmin=-t-i,viewParam.xmax=t-i,viewParam.ymin=-e-a,viewParam.ymax=e-a}}function setProjection(){setDimensions(canvasWidth,canvasHeight,shift.x,shift.y),(orthographic?mat4.ortho:mat4.frustum)(projMat,viewParam.xmin,viewParam.xmax,viewParam.ymin,viewParam.ymax,-viewParam.zmax,-viewParam.zmin),updateViewMatrix()}function initProjection(){H=-Math.tan(.5*angle)*B[2],center.x=center.y=0,center.z=.5*(b[2]+B[2]),lastzoom=Zoom=Zoom0,viewParam.zmin=b[2],viewParam.zmax=B[2],shift.x=shift.y=0}function setViewport(){gl.viewportWidth=canvasWidth,gl.viewportHeight=canvasHeight,gl.viewport(0,0,gl.viewportWidth,gl.viewportHeight),gl.scissor(0,0,gl.viewportWidth,gl.viewportHeight)}function setCanvas(){canvas.width=canvasWidth,canvas.height=canvasHeight,embedded&&(offscreen.width=canvasWidth,offscreen.height=canvasHeight),size2=Math.hypot(canvasWidth,canvasHeight),halfCanvasWidth=.5*canvasWidth,halfCanvasHeight=.5*canvasHeight}function setsize(e,t){e>maxViewportWidth&&(e=maxViewportWidth),t>maxViewportHeight&&(t=maxViewportHeight),shift.x*=e/canvasWidth,shift.y*=t/canvasHeight,canvasWidth=e,canvasHeight=t,setCanvas(),setViewport(),home()}function expand(){setsize(canvasWidth*resizeStep+.5,canvasHeight*resizeStep+.5)}function shrink(){setsize(Math.max(canvasWidth/resizeStep+.5,1),Math.max(canvasHeight/resizeStep+.5,1))}function webGLStart(){if(canvas=document.getElementById("Asymptote"),embedded=window.parent.document!=document,initGL(),absolute&&!embedded)canvasWidth*=window.devicePixelRatio,canvasHeight*=window.devicePixelRatio;else{0==canvas.width&&(canvas.width=Math.max(window.innerWidth-windowTrim,windowTrim)),0==canvas.height&&(canvas.height=Math.max(window.innerHeight-windowTrim,windowTrim));let e=canvasWidth/canvasHeight;canvas.width>canvas.height*e?canvas.width=Math.min(canvas.height*e,canvas.width):canvas.height=Math.min(canvas.width/e,canvas.height),canvas.width>0&&(canvasWidth=canvas.width),canvas.height>0&&(canvasHeight=canvas.height)}setCanvas(),ArcballFactor=1+8*Math.hypot(viewportmargin[0],viewportmargin[1])/size2,viewportshift[0]/=Zoom0,viewportshift[1]/=Zoom0,gl.enable(gl.BLEND),gl.blendFunc(gl.SRC_ALPHA,gl.ONE_MINUS_SRC_ALPHA),gl.enable(gl.DEPTH_TEST),gl.enable(gl.SCISSOR_TEST),setViewport(),home(),canvas.onmousedown=handleMouseDown,document.onmouseup=handleMouseUpOrTouchEnd,document.onmousemove=handleMouseMove,canvas.onkeydown=handleKey,canvas.addEventListener("wheel",handleMouseWheel,!1),canvas.addEventListener("touchstart",handleTouchStart,!1),canvas.addEventListener("touchend",handleMouseUpOrTouchEnd,!1),canvas.addEventListener("touchcancel",handleMouseUpOrTouchEnd,!1),canvas.addEventListener("touchleave",handleMouseUpOrTouchEnd,!1),canvas.addEventListener("touchmove",handleTouchMove,!1),document.addEventListener("keydown",handleKey,!1),tick()}
