/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.regex.Pattern;

public class PgConstraint {
    private static final Pattern PATTERN_PRIMARY_KEY = Pattern.compile(".*PRIMARY[\\s]+KEY.*", 2);
    private String definition;
    private String name;
    private String tableName;
    private String comment;

    public PgConstraint(String name) {
        this.name = name;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("ALTER TABLE ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getTableName()));
        sbSQL.append("\n\tADD CONSTRAINT ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getName()));
        sbSQL.append(' ');
        sbSQL.append(this.getDefinition());
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON CONSTRAINT ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" ON ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.tableName));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDropSQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("ALTER TABLE ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getTableName()));
        sbSQL.append("\n\tDROP CONSTRAINT ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getName()));
        sbSQL.append(';');
        return sbSQL.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKeyConstraint() {
        return PATTERN_PRIMARY_KEY.matcher(this.definition).matches();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof PgConstraint) {
            PgConstraint constraint = (PgConstraint)object;
            equals = this.definition.equals(constraint.getDefinition()) && this.name.equals(constraint.getName()) && this.tableName.equals(constraint.getTableName());
        }
        return equals;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.definition + "|" + this.name + "|" + this.tableName).hashCode();
    }
}

