/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import java.text.MessageFormat;
import java.util.Locale;

public final class Parser {
    private String string;
    private int position;

    public Parser(String string) {
        this.string = string;
        this.skipWhitespace();
    }

    public void expect(String ... words) {
        for (String word : words) {
            this.expect(word, false);
        }
    }

    public boolean expect(String word, boolean optional) {
        int wordEnd = this.position + word.length();
        if (wordEnd <= this.string.length() && this.string.substring(this.position, wordEnd).equalsIgnoreCase(word) && (wordEnd == this.string.length() || Character.isWhitespace(this.string.charAt(wordEnd)) || this.string.charAt(wordEnd) == ';' || this.string.charAt(wordEnd) == ')' || this.string.charAt(wordEnd) == ',' || this.string.charAt(wordEnd) == '[' || "(".equals(word) || ",".equals(word) || "[".equals(word) || "]".equals(word))) {
            this.position = wordEnd;
            this.skipWhitespace();
            return true;
        }
        if (optional) {
            return false;
        }
        throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedWord"), this.string, word, this.position + 1, this.string.substring(this.position, this.position + 20)));
    }

    public boolean expectOptional(String ... words) {
        boolean found = this.expect(words[0], true);
        if (!found) {
            return false;
        }
        for (int i = 1; i < words.length; ++i) {
            this.skipWhitespace();
            this.expect(words[i]);
        }
        return true;
    }

    public void skipWhitespace() {
        while (this.position < this.string.length() && Character.isWhitespace(this.string.charAt(this.position))) {
            ++this.position;
        }
    }

    public String parseIdentifier() {
        String identifier = this.parseIdentifierInternal();
        if (this.string.charAt(this.position) == '.') {
            ++this.position;
            identifier = identifier + '.' + this.parseIdentifierInternal();
        }
        this.skipWhitespace();
        return identifier;
    }

    private String parseIdentifierInternal() {
        char chr;
        int endPos;
        boolean quoted;
        boolean bl = quoted = this.string.charAt(this.position) == '\"';
        if (quoted) {
            int endPos2 = this.string.indexOf(34, this.position + 1);
            String result = this.string.substring(this.position, endPos2 + 1);
            this.position = endPos2 + 1;
            return result;
        }
        for (endPos = this.position; endPos < this.string.length() && !Character.isWhitespace(chr = this.string.charAt(endPos)) && chr != ',' && chr != ')' && chr != '(' && chr != ';' && chr != '.'; ++endPos) {
        }
        String result = this.string.substring(this.position, endPos).toLowerCase(Locale.ENGLISH);
        this.position = endPos;
        return result;
    }

    public String getRest() {
        String result;
        if (this.string.charAt(this.string.length() - 1) == ';') {
            if (this.position == this.string.length() - 1) {
                return null;
            }
            result = this.string.substring(this.position, this.string.length() - 1);
        } else {
            result = this.string.substring(this.position);
        }
        this.position = this.string.length();
        return result;
    }

    public int parseInteger() {
        int endPos;
        for (endPos = this.position; endPos < this.string.length() && Character.isLetterOrDigit(this.string.charAt(endPos)); ++endPos) {
        }
        try {
            int result = Integer.parseInt(this.string.substring(this.position, endPos));
            this.position = endPos;
            this.skipWhitespace();
            return result;
        }
        catch (NumberFormatException ex) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedInteger"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)), ex);
        }
    }

    public String parseString() {
        char chr;
        int endPos;
        boolean quoted;
        boolean bl = quoted = this.string.charAt(this.position) == '\'';
        if (quoted) {
            String result;
            int endPos2;
            boolean escape = false;
            for (endPos2 = this.position + 1; endPos2 < this.string.length(); ++endPos2) {
                char chr2 = this.string.charAt(endPos2);
                if (chr2 == '\\') {
                    escape = !escape;
                    continue;
                }
                if (escape || chr2 != '\'') continue;
                if (endPos2 + 1 >= this.string.length() || this.string.charAt(endPos2 + 1) != '\'') break;
                ++endPos2;
            }
            try {
                result = this.string.substring(this.position, endPos2 + 1);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to get substring: " + this.string + " start pos: " + this.position + " end pos: " + (endPos2 + 1), ex);
            }
            this.position = endPos2 + 1;
            this.skipWhitespace();
            return result;
        }
        for (endPos = this.position; endPos < this.string.length() && !Character.isWhitespace(chr = this.string.charAt(endPos)) && chr != ',' && chr != ')' && chr != ';'; ++endPos) {
        }
        if (this.position == endPos) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedString"), this.string, this.position + 1));
        }
        String result = this.string.substring(this.position, endPos);
        this.position = endPos;
        this.skipWhitespace();
        return result;
    }

    public String getExpression() {
        int endPos = this.getExpressionEnd();
        if (this.position == endPos) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedExpression"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)));
        }
        String result = this.string.substring(this.position, endPos).trim();
        this.position = endPos;
        return result;
    }

    private int getExpressionEnd() {
        int charPos;
        int bracesCount = 0;
        boolean singleQuoteOn = false;
        for (charPos = this.position; charPos < this.string.length(); ++charPos) {
            char chr = this.string.charAt(charPos);
            if (chr == '(') {
                ++bracesCount;
                continue;
            }
            if (chr == ')') {
                if (bracesCount == 0) break;
                --bracesCount;
                continue;
            }
            if (chr == '\'') {
                singleQuoteOn = !singleQuoteOn;
                continue;
            }
            if (chr == ',' && !singleQuoteOn && bracesCount == 0 || chr == ';' && bracesCount == 0 && !singleQuoteOn) break;
        }
        return charPos;
    }

    public int getPosition() {
        return this.position;
    }

    public String getString() {
        return this.string;
    }

    public void throwUnsupportedCommand() {
        throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringUnsupportedCommand"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)));
    }

    public String expectOptionalOneOf(String ... words) {
        for (String word : words) {
            if (!this.expectOptional(word)) continue;
            return word;
        }
        return null;
    }

    public String getSubString(int startPos, int endPos) {
        return this.string.substring(startPos, endPos);
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String parseDataType() {
        boolean timestamp;
        int endPos;
        for (endPos = this.position; endPos < this.string.length() && !Character.isWhitespace(this.string.charAt(endPos)) && this.string.charAt(endPos) != '(' && this.string.charAt(endPos) != ')' && this.string.charAt(endPos) != ','; ++endPos) {
        }
        if (endPos == this.position) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotParseStringExpectedDataType"), this.string, this.position + 1, this.string.substring(this.position, this.position + 20)));
        }
        String dataType = this.string.substring(this.position, endPos);
        this.position = endPos;
        this.skipWhitespace();
        if ("character".equalsIgnoreCase(dataType) && this.expectOptional("varying")) {
            dataType = "character varying";
        } else if ("double".equalsIgnoreCase(dataType) && this.expectOptional("precision")) {
            dataType = "double precision";
        }
        boolean bl = timestamp = "timestamp".equalsIgnoreCase(dataType) || "time".equalsIgnoreCase(dataType);
        if (this.string.charAt(this.position) == '(') {
            dataType = dataType + this.getExpression();
        }
        if (timestamp) {
            if (this.expectOptional("with", "time", "zone")) {
                dataType = dataType + " with time zone";
            } else if (this.expectOptional("without", "time", "zone")) {
                dataType = dataType + " without time zone";
            }
        }
        if (this.expectOptional("[")) {
            this.expect("]");
            dataType = dataType + "[]";
        }
        return dataType;
    }

    public boolean isConsumed() {
        return this.position == this.string.length() || this.position + 1 == this.string.length() && this.string.charAt(this.position) == ';';
    }
}

