/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.text.MessageFormat;

public class CreateFunctionParser {
    public static void parse(PgDatabase database, String statement) {
        Parser parser = new Parser(statement);
        parser.expect("CREATE");
        parser.expectOptional("OR", "REPLACE");
        parser.expect("FUNCTION");
        String functionName = parser.parseIdentifier();
        String schemaName = ParserUtils.getSchemaName(functionName, database);
        PgSchema schema = database.getSchema(schemaName);
        if (schema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), schemaName, statement));
        }
        PgFunction function = new PgFunction();
        function.setName(ParserUtils.getObjectName(functionName));
        schema.addFunction(function);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            String mode = parser.expectOptional("IN") ? "IN" : (parser.expectOptional("OUT") ? "OUT" : (parser.expectOptional("INOUT") ? "INOUT" : (parser.expectOptional("VARIADIC") ? "VARIADIC" : null)));
            int position = parser.getPosition();
            String argumentName = null;
            String dataType = parser.parseDataType();
            int position2 = parser.getPosition();
            if (!(parser.expectOptional(")") || parser.expectOptional(",") || parser.expectOptional("=") || parser.expectOptional("DEFAULT"))) {
                parser.setPosition(position);
                argumentName = ParserUtils.getObjectName(parser.parseIdentifier());
                dataType = parser.parseDataType();
            } else {
                parser.setPosition(position2);
            }
            String defaultExpression = parser.expectOptional("=") || parser.expectOptional("DEFAULT") ? parser.getExpression() : null;
            PgFunction.Argument argument = new PgFunction.Argument();
            argument.setDataType(dataType);
            argument.setDefaultExpression(defaultExpression);
            argument.setMode(mode);
            argument.setName(argumentName);
            function.addArgument(argument);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        function.setBody(parser.getRest());
    }

    private CreateFunctionParser() {
    }
}

