<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Chiffrement SSL/TLS fort: foire aux questions - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">SSL/TLS</a></div><div id="page-content"><div id="preamble"><h1>Chiffrement SSL/TLS fort: foire aux questions</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_faq.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_faq.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

<blockquote>
<p>Le sage n'apporte pas de bonnes rponses, il pose les bonnes questions</p>
<p class="cite">-- <cite>Claude Levi-Strauss</cite></p>

</blockquote>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#installation">Installation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#aboutconfig">Configuration</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#aboutcerts">Certificats</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#aboutssl">Le protocole SSL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#support">Support de mod_ssl</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="installation" id="installation">Installation</a></h2>
<ul>
<li><a href="#mutex">Pourquoi le dmarrage d'Apache provoque-t-il des
erreurs de permission en rapport avec SSLMutex ?</a></li>
<li><a href="#entropy">Pourquoi mod_ssl s'arrte-t-il avec l'erreur
"Failed to generate temporary 512 bit RSA private key" au dmarrage
d'Apache ?</a></li>
</ul>

<h3><a name="mutex" id="mutex">Pourquoi le dmarrage d'Apache provoque-t-il des
erreurs de permission en rapport avec SSLMutex ?</a></h3>
    <p>Des erreurs telles que ``<code>mod_ssl: Child could not open
    SSLMutex lockfile /opt/apache/logs/ssl_mutex.18332 (avec l'erreur
    systme qui suit) [...] System: Permission denied (errno: 13)</code>''
    sont souvent provoques par des permissions trop restrictives sur les
    rpertoires <em>parents</em>. Assurez-vous que tous les rpertoires
    parents (ici <code>/opt</code>, <code>/opt/apache</code> et
    <code>/opt/apache/logs</code>) ont le bit x positionn au moins pour
    l'UID sous lequel les processus enfants d'Apache s'excutent (voir la
    directive <code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code>).</p>


<h3><a name="entropy" id="entropy">Pourquoi mod_ssl s'arrte-t-il avec l'erreur
"Failed to generate temporary 512 bit RSA private key" au dmarrage
d'Apache ?</a></h3>
    <p>Pour fonctionner correctement, les logiciels de cryptographie ont
    besoin d'une source de donnes alatoires. De nombreux systmes
    d'exploitation libres proposent un "priphrique source d'entropie"
    qui fournit ce service (il se nomme en gnral
    <code>/dev/random</code>). Sur d'autres systmes, les applications
    doivent amorcer manuellement
    le Gnrateur de Nombres Pseudo-Alatoires d'OpenSSL
    (Pseudo Random Number Generator -PRNG)  l'aide de donnes appropries
    avant de gnrer des cls ou d'effectuer un chiffrement  cl
    publique. Depuis la version 0.9.5, les fonctions d'OpenSSL qui ncessitent
    des donnes alatoires provoquent une erreur si le PRNG n'a pas t amorc
    avec une source de donnes alatoires d'au moins 128 bits.</p>
    <p>Pour viter cette erreur, <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> doit fournir
    suffisamment d'entropie au PRNG pour lui permettre de fonctionner
    correctement. Ce niveau d'entropie est dfini par la directive
    <code class="directive"><a href="../mod/mod_ssl.html#sslrandomseed">SSLRandomSeed</a></code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="aboutconfig" id="aboutconfig">Configuration</a></h2>
<ul>
<li><a href="#parallel">Peut-on faire cohabiter HTTP et HTTPS sur le mme
serveur ?</a></li>
<li><a href="#ports">Quel port HTTPS utilise-t-il ?</a></li>
<li><a href="#httpstest">Comment s'exprimer en langage HTTPS  des fins
de test ?</a></li>
<li><a href="#hang">Pourquoi la communication se bloque-t-elle lorsque je
me connecte  mon serveur Apache configur pour SSL ?</a></li>
<li><a href="#refused">Pourquoi, lorsque je tente d'accder en HTTPS  mon
serveur Apache+mod_ssl frachement install, l'erreur ``Connection Refused''
s'affiche-t-elle ?</a></li>
<li><a href="#envvars">Pourquoi les variables <code>SSL_XXX</code>
ne sont-elles pas disponibles dans mes scripts CGI et SSI ?</a></li>
<li><a href="#relative">Comment puis-je basculer entre les protocoles HTTP et
HTTPS dans les hyperliens relatifs ?</a></li>
</ul>

<h3><a name="parallel" id="parallel">Peut-on faire cohabiter HTTP et HTTPS sur le mme
serveur ?</a></h3>
    <p>Oui. HTTP et HTTPS utilisent des ports diffrents (HTTP coute le port
    80 et HTTPS le port 443), si bien qu'il n'y a pas de conflit direct entre
    les deux. Vous pouvez soit excuter deux instances spares du serveur,
    chacune d'entre elles coutant l'un de ces ports, soit utiliser l'lgante
    fonctionnalit d'Apache que constituent les htes virtuels pour crer
    deux serveurs virtuels grs par la mme instance d'Apache - le
    premier serveur rpondant en HTTP aux requtes sur le port 80,
    le second rpondant en HTTPS aux requtes sur le port
    443.</p>


<h3><a name="ports" id="ports">Quel port HTTPS utilise-t-il ?</a></h3>
<p>Vous pouvez associer le protocole HTTPS  n'importe quel port, mais le port
standard est le port 443, que tout navigateur compatible HTTPS va utiliser par
dfaut. Vous pouvez forcer votre navigateur  utiliser un port diffrent en le
prcisant dans l'URL. Par exemple, si votre serveur est configur pour
servir des pages en HTTPS sur le port 8080, vous pourrez y accder par
l'adresse <code>https://example.com:8080/</code>.</p>


<h3><a name="httpstest" id="httpstest">Comment s'exprimer en langage HTTPS  des fins
de test ?</a></h3>
 <p>Alors que vous utilisez simplement</p>

    <div class="example"><p><code>$ telnet localhost 80<br />
    GET / HTTP/1.0</code></p></div>

    <p>pour tester facilement Apache via HTTP, les choses ne sont pas si
    simples pour HTTPS  cause du protocole SSL situ entre TCP et HTTP.
    La commande OpenSSL <code>s_client</code> vous permet cependant
    d'effectuer un test similaire via HTTPS :</p>

    <div class="example"><p><code>$ openssl s_client -connect localhost:443 -state -debug<br />
    GET / HTTP/1.0</code></p></div>

    <p>Avant la vritable rponse HTTP, vous recevrez des informations
    dtailles  propos de l'tablissement de la connexion SSL. Si vous
    recherchez un client en ligne de commande  usage plus gnral qui comprend
    directement HTTP et HTTPS, qui peut effectuer des oprations GET et POST,
    peut utiliser un mandataire, supporte les requtes portant sur une partie
    d'un fichier (byte-range), etc..., vous devriez vous tourner vers
    l'excellent outil <a href="http://curl.haxx.se/">cURL</a>. Grce  lui,
    vous pouvez vrifier si Apache rpond correctement aux requtes via
    HTTP et HTTPS comme suit :</p>

    <div class="example"><p><code>$ curl http://localhost/<br />
    $ curl https://localhost/</code></p></div>


<h3><a name="hang" id="hang">Pourquoi la communication se bloque-t-elle lorsque je
me connecte  mon serveur Apache configur pour SSL ?</a></h3>
<p>Ceci peut arriver si vous vous connectez  un serveur HTTPS (ou 
un serveur virtuel) via HTTP (par exemple, en utilisant
<code>http://example.com/</code> au lieu de <code>https://example.com</code>).
Cela peut aussi arriver en essayant de vous connecter via HTTPS  un
serveur HTTP (par exemple, en utilisant <code>https://example.com/</code>
avec un serveur qui ne supporte pas HTTPS, ou le supporte, mais sur un
port non standard). Assurez-vous que vous vous connectez bien  un
serveur (virtuel) qui supporte SSL.</p>


<h3><a name="refused" id="refused">Pourquoi, lorsque je tente d'accder en HTTPS  mon
serveur Apache+mod_ssl frachement install, l'erreur ``Connection Refused''
s'affiche-t-elle ?</a></h3>
<p>Une configuration incorrecte peut provoquer ce type d'erreur.
Assurez-vous que vos directives <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> s'accordent avec vos directives
    <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>. Si
    l'erreur persiste, recommencez depuis le dbut en restaurant la
    configuration par dfaut fournie par<code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>.</p>


<h3><a name="envvars" id="envvars">Pourquoi les variables <code>SSL_XXX</code>
ne sont-elles pas disponibles dans mes scripts CGI et SSI ?</a></h3>
<p>Assurez-vous que la directive ``<code>SSLOptions +StdEnvVars</code>'' est
bien prsente dans le contexte de vos requtes CGI/SSI.</p>


<h3><a name="relative" id="relative">Comment puis-je basculer entre les protocoles HTTP et
HTTPS dans les hyperliens relatifs ?</a></h3>

<p>Normalement, pour basculer entre HTTP et HTTPS, vous devez utiliser des
hyperliens pleinement qualifis (car vous devez modifier le schma de l'URL).
Cependant,  l'aide du module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, vous pouvez
manipuler des hyperliens relatifs, pour obtenir le mme effet.</p>
    <pre class="prettyprint lang-config">RewriteEngine on
RewriteRule   "^/(.*)_SSL$"   "https://%{SERVER_NAME}/$1" [R,L]
RewriteRule   "^/(.*)_NOSSL$" "http://%{SERVER_NAME}/$1"  [R,L]</pre>


    <p>Ce jeu de rgles rewrite vous permet d'utiliser des hyperliens de la
    forme <code>&lt;a href="document.html_SSL"&gt;</code> pour passer en HTTPS
    dans les liens relatifs. (Remplacez SSL par NOSSL pour passer en HTTP.)</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="aboutcerts" id="aboutcerts">Certificats</a></h2>
<ul>
<li><a href="#keyscerts">Qu'est-ce qu'un cl prive RSA, un certificat,
une demande de signature de certificat (CSR) ?</a></li>
<li><a href="#startup">Y a-t-il une diffrence au dmarrage entre un serveur
Apache non SSL et un serveur Apache supportant SSL ?</a></li>
<li><a href="#selfcert">Comment crer un certificat auto-sign SSL  des
fins de test ?</a></li>
<li><a href="#realcert">Comment crer un vrai certificat SSL ?</a></li>
<li><a href="#ownca">Comment crer et utiliser sa propre Autorit de
certification (CA) ?</a></li>
<li><a href="#passphrase">Comment modifier le mot de passe
de ma cl prive ?</a></li>
<li><a href="#removepassphrase">Comment dmarrer Apache sans avoir  entrer de
mot de passe ?</a></li>
<li><a href="#verify">Comment vrifier si une cl prive correspond bien
 son certificat ?</a></li>
<li><a href="#pemder">Comment convertir un certificat du format PEM
au format DER ?</a></li>
<li><a href="#gid">Pourquoi les navigateurs se plaignent-ils de ne pas pouvoir
vrifier mon certificat de serveur ?</a></li>
</ul>

<h3><a name="keyscerts" id="keyscerts">Qu'est-ce qu'un cl prive RSA, un certificat,
une demande de signature de certificat (CSR) ?</a></h3>
<p>Un fichier de cl prive RSA est un fichier numrique que vous pouvez
utiliser pour dchiffrer des messages que l'on vous a envoys. Il a son
pendant  caractre public que vous pouvez distribuer (par le biais de votre
certificat), ce qui permet aux utilisateurs de chiffrer les messages qu'ils
vous envoient.</p>
    <p>Une Demande de Signature de Certificat (CSR) est un fichier numrique
    qui contient votre cl publique et votre nom. La CSR doit tre envoye 
    une Autorit de Certification (CA), qui va la convertir en vrai certificat
    en la signant.</p>
    <p>Un certificat contient votre cl publique RSA, votre nom, le nom
    de la CA, et est sign numriquement par cette dernire. Les navigateurs
    qui reconnaissent la CA peuvent vrifier la signature du certificat, et
    ainsi en extraire votre cl publique RSA. Ceci leur permet de vous envoyer
    des messages chiffrs que vous seul pourrez dchiffrer.</p>
    <p>Se rfrer au chapitre <a href="ssl_intro.html">Introduction</a>
    pour une description gnrale du protocole SSL.</p>


<h3><a name="startup" id="startup">Y a-t-il une diffrence au dmarrage entre un serveur
Apache non SSL et un serveur Apache supportant SSL ?</a></h3>
<p>Oui. En gnral, avec ou sans <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> intgr, le dmarrage
d'Apache ne prsente pas de diffrences. Cependant, si votre fichier de cl
prive SSL possde un mot de passe, vous devrez le taper au dmarrage
d'Apache.</p>

    <p>Devoir entrer manuellement le mot de passe au dmarrage du serveur peut
    poser quelques problmes - par exemple, quand le serveur est dmarr au
    moyen de scripts au lancement du systme. Dans ce cas, vous pouvez suivre
    les tapes <a href="#removepassphrase">ci-dessous</a> pour supprimer le
    mot de passe de votre cl prive. Gardez  l'esprit qu'agir ainsi augmente
    les risques de scurit - agissez avec prcaution !</p>


<h3><a name="selfcert" id="selfcert">Comment crer un certificat auto-sign SSL  des
fins de test ?</a></h3>
    <ol>
    <li>Vrifiez qu'OpenSSL est install et l'excutable openssl dans votre
    <code>PATH</code>.<br />
    <br />
    </li>
    <li>Excuter la commande suivante pour crer les fichiers
    <code>server.key</code> et <code>server.crt</code> :<br />
	<code><strong>$ openssl req -new -x509 -nodes -out server.crt
			-keyout server.key</strong></code><br />
	Ces fichiers seront utiliss comme suit dans votre
	<code>httpd.conf</code> :
        <pre class="prettyprint lang-config">SSLCertificateFile    "/path/to/this/server.crt"
SSLCertificateKeyFile "/path/to/this/server.key"</pre>

    </li>
    <li>Il est important de savoir que le fichier <code>server.key</code> n'a
    <em>pas</em> de mot de passe. Pour ajouter un mot de passe  la cl, vous
    devez excuter la commande suivante et confirmer le mot de passe comme
    demand.<br />
	<p><code><strong>$ openssl rsa -des3 -in server.key -out
	server.key.new</strong></code><br />
	<code><strong>$ mv server.key.new server.key</strong></code><br /></p>
	Sauvegardez le fichier <code>server.key</code> ainsi que son mot de
	passe en lieu sr.
    </li>
    </ol>


<h3><a name="realcert" id="realcert">Comment crer un vrai certificat SSL ?</a></h3>
<p>Voici la marche  suivre pas  pas :</p>
    <ol>
    <li>Assurez-vous qu'OpenSSL est bien install et dans votre <code>PATH</code>.
    <br />
    <br />
    </li>
    <li>Crez une cl prive RSA pour votre serveur Apache
    	(elle sera au format PEM et chiffre en Triple-DES):<br />
       <br />
       <code><strong>$ openssl genrsa -des3 -out server.key 2048</strong></code><br />
       <br />
       Enregistrez le fichier <code>server.key</code> et le mot de passe
       ventuellement dfini en lieu sr.
       Vous pouvez afficher les dtails de cette cl prive RSA  l'aide de la
       commande :<br />

       <br />
       <code><strong>$ openssl rsa -noout -text -in server.key</strong></code><br />
       <br />
       Si ncessaire, vous pouvez aussi crer une version PEM non chiffre
       (non recommand) de cl prive RSA avec :<br />
       <br />
       <code><strong>$ openssl rsa -in server.key -out server.key.unsecure</strong></code><br />
       <br />

    </li>
    <li>Crez une Demande de signature de Certificat (CSR)  l'aide de la
    cl prive prcdemment gnre (la sortie sera au format PEM):<br />
       <br />
       <code><strong>$ openssl req -new -key server.key -out server.csr</strong></code><br />
       <br />
       Vous devez entrer le Nom de Domaine Pleinement Qualifi
       ("Fully Qualified Domain Name" ou FQDN) de votre serveur lorsqu'OpenSSL
       vous demande le "CommonName", c'est  dire que si vous gnrez une CSR
       pour un site web auquel on accdera par l'URL
       <code>https://www.foo.dom/</code>, le FQDN sera "www.foo.dom". Vous
       pouvez afficher les dtails de ce CSR avec :<br />

       <br />
       <code><strong>$ openssl req -noout -text -in server.csr</strong></code><br />
       <br />
    </li>
    <li>Vous devez maintenant envoyer la CSR  une Autorit de Certification
    (CA), afin que cette dernire puisse la signer. Une fois la CSR signe,
    vous disposerez d'un vritable certificat que vous pourrez utiliser avec
    Apache. Vous pouvez faire signer votre CSR par une CA commerciale ou par
    votre propre CA.<br />
       Les CAs commerciales vous demandent en gnral de leur envoyer la CSR
       par l'intermdiaire d'un formulaire web, de rgler le montant de la
       signature, puis vous envoient un certificat sign que vous pouvez
       enregistrer dans un fichier server.crt.

       Pour plus de dtails sur la manire de crer sa propre CA, et de
       l'utiliser pour signer une CSR, voir <a href="#ownca">ci-dessous</a>.<br />

       Une fois la CSR signe, vous pouvez afficher les dtails du certificat
       comme suit :<br />
       <br />
       <code><strong>$ openssl x509 -noout -text -in server.crt</strong></code><br />

    </li>
    <li>Vous devez maintenant disposer de deux fichiers :
    <code>server.key</code> et <code>server.crt</code>. Ils sont prciss dans
    votre fichier <code>httpd.conf</code> comme suit :
       <pre class="prettyprint lang-config">SSLCertificateFile    "/path/to/this/server.crt"
SSLCertificateKeyFile "/path/to/this/server.key"</pre>

       Le fichier <code>server.csr</code> n'est plus ncessaire.
    </li>

    </ol>


<h3><a name="ownca" id="ownca">Comment crer et utiliser sa propre Autorit de
certification (CA) ?</a></h3>
    <p>La solution la plus simple consiste  utiliser les scripts
    <code>CA.sh</code> ou <code>CA.pl</code> fournis avec OpenSSL. De
    prfrence, utilisez cette solution,  moins que vous ayez de bonnes
    raisons de ne pas le faire. Dans ce dernier cas, vous pouvez crer un
    certificat auto-sign comme suit :</p>

    <ol>
    <li>Crez une cl prive RSA pour votre serveur
    	(elle sera au format PEM et chiffre en Triple-DES) :<br />
       <br />
       <code><strong>$ openssl genrsa -des3 -out server.key 2048</strong></code><br />
       <br />
       Sauvegardez le fichier <code>server.key</code> et le mot de passe
       ventuellement dfini en lieu sr.
       Vous pouvez afficher les dtails de cette cl prive RSA  l'aide de la
       commande :<br />
       <br />
       <code><strong>$ openssl rsa -noout -text -in server.key</strong></code><br />
       <br />
       Si ncessaire, vous pouvez aussi crer une version PEM non chiffre
       (non recommand) de cette cl prive RSA	 avec :<br />
       <br />
       <code><strong>$ openssl rsa -in server.key -out server.key.unsecure</strong></code><br />
       <br />
    </li>
    <li>Crez un certificat auto-sign (structure X509)  l'aide de la cl RSA
    que vous venez de gnrer (la sortie sera au format PEM) :<br />
       <br />
       <code><strong>$ openssl req -new -x509 -nodes -sha1 -days 365
		       -key server.key -out server.crt -extensions usr_cert</strong></code><br />
       <br />
       Cette commande signe le certificat du serveur et produit un fichier
       <code>server.crt</code>. Vous pouvez afficher les dtails de ce
       certificat avec :<br />
       <br />
       <code><strong>$ openssl x509 -noout -text -in server.crt</strong></code><br />
       <br />
    </li>
    </ol>


<h3><a name="passphrase" id="passphrase">Comment modifier le mot de passe
de ma cl prive ?</a></h3>
<p>Vous devez simplement lire la cl avec l'ancien mot de passe et la
rcrire en spcifiant le nouveau mot de passe. Pour cela, vous pouvez
utiliser les commandes suivantes :</p>


    <p><code><strong>$ openssl rsa -des3 -in server.key -out server.key.new</strong></code><br />
    <code><strong>$ mv server.key.new server.key</strong></code><br /></p>

    <p>La premire fois qu'il vous est demand un mot de passe PEM, vous
    devez entrer l'ancien mot de passe. Ensuite, on vous demandera d'entrer
    encore un mot de passe - cette fois, entrez le nouveau mot de passe. Si on
    vous demande de vrifier le mot de passe, vous devrez entrer le nouveau
    mot de passe une seconde fois.</p>


<h3><a name="removepassphrase" id="removepassphrase">Comment dmarrer Apache sans avoir  entrer de
mot de passe ?</a></h3>
<p>L'apparition de ce dialogue au dmarrage et  chaque redmarrage provient
du fait que la cl prive RSA contenue dans votre fichier server.key est
enregistre sous forme chiffre pour des raisons de scurit. Le
dchiffrement de ce fichier ncessite un mot de passe, afin de pouvoir tre
lu et interprt. Cependant, La suppression du mot de passe diminue le niveau de
scurit du serveur - agissez avec prcautions !</p>
    <ol>
    <li>Supprimer le chiffrement de la cl prive RSA (tout en conservant une
    copie de sauvegarde du fichier original) :<br />
       <br />
       <code><strong>$ cp server.key server.key.org</strong></code><br />
       <code><strong>$ openssl rsa -in server.key.org -out server.key</strong></code><br />

       <br />
    </li>
    <li>Assurez-vous que le fichier server.key n'est lisible que par root :<br />
       <br />
       <code><strong>$ chmod 400 server.key</strong></code><br />
       <br />
    </li>
    </ol>

    <p>Maintenant, <code>server.key</code> contient une copie non chiffre de
    la cl. Si vous utilisez ce fichier pour votre serveur, il ne vous
    demandera plus de mot de passe. CEPENDANT, si quelqu'un arrive  obtenir
    cette cl, il sera en mesure d'usurper votre identit sur le rseau.
    Vous DEVEZ par consquent vous assurer que seuls root ou le serveur web
    peuvent lire ce fichier (de prfrence, dmarrez le serveur web sous
    root et faites le s'excuter sous un autre utilisateur, en n'autorisant
    la lecture de la cl que par root).</p>

    <p>Une autre alternative consiste  utiliser la directive
    ``<code>SSLPassPhraseDialog exec:/chemin/vers/programme</code>''. Gardez
    cependant  l'esprit que ce n'est bien entendu ni plus ni moins
    scuris.</p>


<h3><a name="verify" id="verify">Comment vrifier si une cl prive correspond bien
 son certificat ?</a></h3>
<p>Une cl prive contient une srie de nombres. Deux de ces nombres forment la
"cl publique", les autres appartiennent  la "cl prive". Les bits de la
"cl publique" sont inclus quand vous gnrez une CSR, et font par
consquent partie du certificat associ.</p>
    <p>Pour vrifier que la cl publique contenue dans votre certificat
    correspond bien  la partie publique de votre cl prive, il vous suffit
    de comparer ces nombres. Pour afficher le certificat et la cl,
    utilisez cette commande :</p>

    <p><code><strong>$ openssl x509 -noout -text -in server.crt</strong></code><br />
    <code><strong>$ openssl rsa -noout -text -in server.key</strong></code></p>

    <p>Les parties `modulus' et `public exponent' doivent tre identiques dans
    la cl et le certificat. Comme le `public exponent' est habituellement
    65537, et comme il est difficile de vrifier visuellement que les nombreux
    nombres du `modulus' sont identiques, vous pouvez utiliser l'approche
    suivante :</p>

    <p><code><strong>$ openssl x509 -noout -modulus -in server.crt | openssl md5</strong></code><br />
    <code><strong>$ openssl rsa -noout -modulus -in server.key | openssl md5</strong></code></p>

    <p>Il ne vous reste ainsi que deux nombres relativement courts  comparer.
    Il est possible, en thorie que ces deux nombres soient les mmes, sans que
    les nombres du modulus soient identiques, mais les chances en sont infimes.</p>
    <p>Si vous souhaitez vrifier  quelle cl ou certificat appartient une CSR
    particulire, vous pouvez effectuer le mme calcul
    sur la CSR comme suit :</p>

    <p><code><strong>$ openssl req -noout -modulus -in server.csr | openssl md5</strong></code></p>


<h3><a name="pemder" id="pemder">Comment convertir un certificat du format PEM
au format DER ?</a></h3>
<p>Le format des certificats par dfaut pour OpenSSL est le format PEM,
qui est tout simplement un format DER cod en Base64, avec des lignes
d'en-ttes et des annotations. Certaines applications, comme
Microsoft Internet Explorer, ont besoin d'un certificat au format DER de base.
Vous pouvez convertir un fichier PEM <code>cert.pem</code> en son quivalent
au format DER <code>cert.der</code>  l'aide de la commande suivante :
<code><strong>$ openssl x509 -in cert.pem -out cert.der
-outform DER</strong></code></p>


<h3><a name="gid" id="gid">Pourquoi les navigateurs se plaignent-ils de ne pas pouvoir
vrifier mon certificat de serveur ?</a></h3>

    <p>Ceci peut se produire si votre certificat de serveur est sign
    par une autorit de certification intermdiaire. Plusieurs CAs,
    comme Verisign ou Thawte, ont commenc  signer les certificats avec
    des certificats intermdiaires au lieu de leur certificat racine.</p>

    <p>Les certificats de CA intermdiaires se situe  un niveau
    intermdiaire entre le certificat racine de la CA (qui est install dans les
    navigateurs) et le certificat du serveur (que vous avez install sur
    votre serveur). Pour que le navigateur puisse traverser et vrifier
    la chane de confiance depuis le certificat du serveur jusqu'au
    certificat racine, il faut lui fournir les certificats
    intermdiaires. Les CAs devraient pouvoir fournir de tels
    paquetages de certificats intermdiaires  installer sur les
    serveurs.</p>

    <p>Vous devez inclure ces certificats intermdiaires via la
    directive <code class="directive"><a href="../mod/mod_ssl.html#sslcertificatechainfile">SSLCertificateChainFile</a></code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="aboutssl" id="aboutssl">Le protocole SSL</a></h2>
<ul>
<li><a href="#random">Pourquoi de nombreuses et alatoires erreurs de
protocole SSL apparaissent-elles en cas de forte charge du serveur ?</a></li>
<li><a href="#load">Pourquoi la charge de mon serveur est-elle plus
importante depuis qu'il sert des ressources chiffres en SSL ?</a></li>
<li><a href="#establishing">Pourquoi les connexions en HTTPS  mon serveur
prennent-elles parfois jusqu' 30 secondes pour s'tablir ?</a></li>
<li><a href="#ciphers">Quels sont les algorithmes de chiffrement
supports par mod_ssl ?</a></li>
<li><a href="#adh">Pourquoi une erreur ``no shared cipher'' apparat-elle
quand j'essaie d'utiliser un algorithme de chiffrement
Diffie-Hellman anonyme (ADH) ?</a></li>
<li><a href="#sharedciphers">Pourquoi une erreur ``no shared cipher''
apparat-elle lorsqu'on se connecte  mon serveur
frachement install ?</a></li>
<li><a href="#vhosts">Pourquoi ne peut-on pas utiliser SSL avec des htes
virtuels identifis par un nom et non par une adresse IP ?</a></li>
<li><a href="#vhosts2">Est-il possible d'utiliser
l'hbergement virtuel bas sur le nom d'hte
pour diffrencier plusieurs htes virtuels ?</a></li>
<li><a href="#comp">Comment mettre en oeuvre la compression SSL ?</a></li>
<li><a href="#lockicon">Lorsque j'utilise l'authentification de base sur HTTPS,
l'icne de verrouillage des navigateurs Netscape reste ouverte quand la bote
de dialogue d'authentification apparat. Cela signifie-t-il que les utilisateur
et mot de passe sont envoys en clair ?</a></li>
<li><a href="#msie">Pourquoi des erreurs d'entre/sortie apparaissent-elles
lorsqu'on se connecte  un serveur Apache+mod_ssl avec
Microsoft Internet Explorer (MSIE) ?</a></li>
<li><a href="#srp">Comment activer TLS-SRP ?</a></li>
<li><a href="#javadh">Pourquoi des erreurs de ngociation apparaissent
avec les clients bass sur Java lorsqu'on utilise un certificat de plus
de 1024 bits ?</a></li>
</ul>

<h3><a name="random" id="random">Pourquoi de nombreuses et alatoires erreurs de
protocole SSL apparaissent-elles en cas de forte charge du serveur ?</a></h3>
<p>Ce problme peut avoir plusieurs causes, mais la principale rside dans le
cache de session SSL dfini par la directive
<code class="directive"><a href="../mod/mod_ssl.html#sslsessioncache">SSLSessionCache</a></code>. Le cache de session
DBM est souvent  la source du problme qui peut tre rsolu en utilisant le
cache de session SHM (ou en n'utilisant tout simplement pas de cache).</p>


<h3><a name="load" id="load">Pourquoi la charge de mon serveur est-elle plus
importante depuis qu'il sert des ressources chiffres en SSL ?</a></h3>
<p>SSL utilise un procd de chiffrement fort qui ncessite la manipulation
d'une quantit trs importante de nombres. Lorsque vous effectuez une requte
pour une page web via HTTPS, tout (mme les images) est chiffr avant d'tre
transmis. C'est pourquoi un accroissement du traffic HTTPS entrane une
augmentation de la charge.</p>


<h3><a name="establishing" id="establishing">Pourquoi les connexions en HTTPS  mon serveur
prennent-elles parfois jusqu' 30 secondes pour s'tablir ?</a></h3>
<p>Ce problme provient en gnral d'un priphrique <code>/dev/random</code>
qui bloque l'appel systme read(2) jusqu' ce que suffisamment d'entropie
soit disponible pour servir la requte. Pour plus d'information, se rfrer au
manuel de rfrence de la directive
<code class="directive"><a href="../mod/mod_ssl.html#sslrandomseed">SSLRandomSeed</a></code>.</p>


<h3><a name="ciphers" id="ciphers">Quels sont les algorithmes de chiffrement
supports par mod_ssl ?</a></h3>
<p>En gnral, tous les algorithmes de chiffrement supports par la version
d'OpenSSL installe, le sont aussi par <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>. La liste des
algorithmes disponibles peut dpendre de la manire dont vous avez install
OpenSSL. Typiquement, au moins les algorithmes suivants sont supports :</p>

    <ol>
    <li>RC4 avec SHA1</li>
    <li>AES avec SHA1</li>
    <li>Triple-DES avec SHA1</li>
    </ol>

    <p>Pour dterminer la liste relle des algorithmes disponibles, vous
    pouvez utiliser la commande suivante :</p>
    <div class="example"><p><code>$ openssl ciphers -v</code></p></div>


<h3><a name="adh" id="adh">Pourquoi une erreur ``no shared cipher'' apparat-elle
quand j'essaie d'utiliser un algorithme de chiffrement
Diffie-Hellman anonyme (ADH) ?</a></h3>
<p>Par dfaut et pour des raisons de scurit, OpenSSl ne permet <em>pas</em>
l'utilisation des algorithmes de chiffrements ADH. Veuillez vous informer
sur les effets pervers potentiels si vous choisissez d'activer le support
de ces algorithmes de chiffrements.</p>
<p>Pour pouvoir utiliser les algorithmes de chiffrements Diffie-Hellman
anonymes (ADH), vous devez compiler OpenSSL avec
``<code>-DSSL_ALLOW_ADH</code>'', puis ajouter ``<code>ADH</code>''  votre
directive <code class="directive"><a href="../mod/mod_ssl.html#sslciphersuite">SSLCipherSuite</a></code>.</p>


<h3><a name="sharedciphers" id="sharedciphers">Pourquoi une erreur ``no shared cipher''
apparat-elle lorsqu'on se connecte  mon serveur
frachement install ?</a></h3>
<p>Soit vous avez fait une erreur en dfinissant votre directive
<code class="directive"><a href="../mod/mod_ssl.html#sslciphersuite">SSLCipherSuite</a></code> (comparez-la avec
l'exemple prconfigur dans <code>extra/httpd-ssl.conf</code>), soit vous avez
choisi d'utiliser des algorithmes DSA/DH au lieu de RSA lorsque vous avez
gnr votre cl prive, et avez ignor ou tes pass outre les
avertissements. Si vous avez choisi DSA/DH, votre serveur est incapable de
communiquer en utilisant des algorithmes de chiffrements SSL bass sur RSA
(du moins tant que vous n'aurez pas configur une paire cl/certificat RSA
additionnelle). Les navigateurs modernes tels que NS ou IE ne peuvent
communiquer par SSL qu'avec des algorithmes RSA. C'est ce qui provoque l'erreur
"no shared ciphers". Pour la corriger, gnrez une nouvelle paire
cl/certificat pour le serveur en utilisant un algorithme de chiffrement
RSA.</p>


<h3><a name="vhosts" id="vhosts">Pourquoi ne peut-on pas utiliser SSL avec des htes
virtuels identifis par un nom et non par une adresse IP ?</a></h3>
<p>La raison est trs technique, et s'apparente au problme de la primaut de
l'oeuf ou de la poule. La couche du protocole SSL se trouve en dessous de la
couche de protocole HTTP qu'elle encapsule. Lors de l'tablissement d'une
connexion SSL (HTTPS), Apache/mod_ssl doit ngocier les paramtres du
protocole SSL avec le client. Pour cela, mod_ssl doit consulter la
configuration du serveur virtuel (par exemple, il doit accder  la suite
d'algorithmes de chiffrement, au certificat du serveur, etc...). Mais afin de
slectionner le bon serveur virtuel, Apache doit connatre le contenu du champ
d'en-tte HTTP <code>Host</code>. Pour cela, il doit lire l'en-tte de la
requte HTTP. Mais il ne peut le faire tant que la ngociation SSL n'est pas
termine, or, la phase de ngociation SSL a besoin du nom d'hte contenu
dans l'en-tte de la requte. Voir la question suivante pour
contourner ce problme.</p>

    <p>Notez que si votre certificat comporte un nom de serveur avec
    caractres gnriques, ou des noms de serveurs multiples dans le
    champ subjectAltName, vous pouvez utiliser SSL avec les serveurs
    virtuels  base de noms sans avoir  contourner ce problme.</p>


<h3><a name="vhosts2" id="vhosts2">Est-il possible d'utiliser
l'hbergement virtuel bas sur le nom d'hte
pour diffrencier plusieurs htes virtuels ?</a></h3>
    <p>L'hbergement virtuel bas sur le nom est une mthode trs populaire
    d'identification des diffrents htes virtuels. Il permet d'utiliser la
    mme adresse IP et le mme numro de port pour de nombreux sites
    diffrents. Lorsqu'on se tourne vers SSL, il semble tout naturel de penser
    que l'on peut appliquer la mme mthode pour grer plusieurs htes
    virtuels SSL sur le mme serveur.</p>

    <p>C'est possible, mais seulement si on utilise une version 2.2.12
    ou suprieure du serveur web compile avec OpenSSL
    version 0.9.8j ou suprieure. Ceci est du au fait que
    l'utilisation de l'hbergement virtuel  base de nom
    avec SSL ncessite une fonctionnalit appele
    Indication du Nom de Serveur (Server Name Indication - SNI) que
    seules les rvisions les plus rcentes de la
    spcification SSL supportent.</p>

    <p>Notez que si votre certificat comporte un nom de serveur avec
    caractres gnriques, ou des noms de serveurs multiples dans le
    champ subjectAltName, vous pouvez utiliser SSL avec les serveurs
    virtuels  base de noms sans avoir  contourner ce problme.</p>

    <p>La raison en est que le protocole SSL constitue une couche spare qui
    encapsule le protocole HTTP. Aini, la session SSL ncessite une
    transaction spare qui prend place avant que la session HTTP n'ait dbut.
    Le serveur reoit une requte SSL sur l'adresse IP X et le port Y
    (habituellement 443). Comme la requte SSL ne contenait aucun
    en-tte Host:, le serveur n'avait aucun moyen de dterminer quel hte virtuel SSL il
    devait utiliser. En gnral, il utilisait le premier
    qu'il trouvait et qui
    correspondait  l'adresse IP et au port spcifis.</p>

    <p>Par contre, si vous utilisez des versions du serveur web et
    d'OpenSSL qui supportent SNI, et si le navigateur du client le
    supporte aussi, alors le nom d'hte sera inclus dans la
    requte SSL originale, et le serveur web pourra
    slectionner le bon serveur virtuel SSL.</p>

    <p>Bien entendu, vous pouvez utiliser l'hbergement virtuel bas sur le nom
    pour identifier de nombreux htes virtuels non-SSL
    (tous sur le port 80 par exemple), et ne grer qu'un seul hte virtuel SSL
    (sur le port 443). Mais dans ce cas, vous devez dfinir le numro de port
    non-SSL  l'aide de la directive NameVirtualHost dans ce style :</p>

    <pre class="prettyprint lang-config">NameVirtualHost 192.168.1.1:80</pre>


    <p>il existe d'autres solutions alternatives comme :</p>

    <p>Utiliser des adresses IP diffrentes pour chaque hte SSL.
    Utiliser des numros de port diffrents pour chaque hte SSL.</p>


<h3><a name="comp" id="comp">Comment mettre en oeuvre la compression SSL ?</a></h3>
<p>Bien que la ngociation pour la compression SSL ait t dfinie dans la
spcification de SSLv2 et TLS, ce n'est qu'en mai 2004 que la RFC 3749 a
dfini DEFLATE comme une mthode de compression standard ngociable.
</p>
<p>Depuis la version 0.9.8, OpenSSL supporte cette compression par dfaut
lorsqu'il est compil avec l'option <code>zlib</code>. Si le client et le
serveur supportent la compression, elle sera utilise. Cependant, la
plupart des clients essaient encore de se connecter avec un Hello SSLv2.
Comme SSLv2 ne comportait pas de table des algorithmes de compression prfrs
dans sa ngociation, la compression ne peut pas tre ngocie avec ces clients.
Si le client dsactive le support SSLv2, un Hello SSLv3 ou TLS peut tre
envoy, selon la bibliothque SSL utilise, et la compression peut tre mise
en oeuvre. Vous pouvez vrifier si un client utilise la compression SSL en
journalisant la variable <code>%{SSL_COMPRESS_METHOD}x</code>.
</p>


<h3><a name="lockicon" id="lockicon">Lorsque j'utilise l'authentification de base sur HTTPS,
l'icne de verrouillage des navigateurs Netscape reste ouverte quand la bote
de dialogue d'authentification apparat. Cela signifie-t-il que les utilisateur
et mot de passe sont envoys en clair ?</a></h3>
<p>Non, le couple utilisateur/mot de passe est transmis sous forme chiffre.
	L'icne de chiffrement dans les navigateurs Netscape n'est pas vraiment
	synchronis avec la couche SSL/TLS. Il ne passe  l'tat verrouill
	qu'au moment o la premire partie des donnes relatives  la page web
	proprement dite sont transfres, ce qui peut prter  confusion. Le
	dispositif d'authentification de base appartient  la couche HTTP, qui
	est situe au dessus de la couche SSL/TLS dans HTTPS. Avant tout
	transfert de donnes HTTP sous HTTPS, la couche SSL/TLS a dj achev
	sa phase de ngociation et bascul dans le mode de communication
	chiffre. Ne vous laissez donc pas abuser par l'tat de cet icne.</p>


<h3><a name="msie" id="msie">Pourquoi des erreurs d'entre/sortie apparaissent-elles
lorsqu'on se connecte via HTTPS  un serveur Apache+mod_ssl avec des
versions anciennes de
Microsoft Internet Explorer (MSIE) ?</a></h3>
<p>La premire raison en est la prsence dans l'implmentation SSL de
certaines versions de MSIE de bogues subtils en rapport avec le
dispositif de "maintien en vie" (keep-alive) HTTP, et les alertes de
notification de fermeture de session SSL en cas de coupure de la
connexion au point d'entre (socket). De plus, l'interaction entre
SSL et les fonctionnalits HTTP/1.1 pose problme avec certaines
versions de MSIE. Vous pouvez contourner ces problmes en interdisant
 Apache l'utilisation de HTTP/1.1, les connexions avec maintien en vie
ou l'envoi de messages de notification de fermeture de session SSL aux
clients MSIE. Pour cela, vous pouvez utiliser la directive suivante
dans votre section d'hte virtuel avec support SSL :</p>
    <pre class="prettyprint lang-config">SetEnvIf User-Agent "MSIE [2-5]" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0</pre>

    <p>En outre, certaines versions de MSIE ont des problmes avec des
    algorithmes de chiffrement particuliers. Hlas, il n'est pas
    possible d'apporter une solution spcifique  MSIE pour ces
    problmes, car les algorithmes de chiffrement sont utiliss ds la
    phase de ngociation SSL. Ainsi, une directive
    <code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code> spcifique
     MSIE ne peut tre d'aucun secours. Par contre, vous devrez
    ajuster les paramtres gnraux de manire drastique. Avant de
    vous dcider, soyez sr que vos clients rencontrent vraiment des
    problmes. Dans la ngative, n'effectuez pas ces ajustements car
    ils affecteront <em>tous</em> vos clients, ceux utilisant MSIE,
    mais aussi les autres.</p>



<h3><a name="srp" id="srp">Comment activer TLS-SRP ?</a></h3>
    <p>Le protocole TLS-SRP (Echange de cls scuris par mot de passe
    pour TLS comme spcifi dans la RFC 5054) peut complter ou mme
    remplacer les certificats lors du processus d'authentification des
    connexions SSL. Pour utiliser TLS-SRP, spcifiez un fichier de
    vrification SRP OpenSSL via la directive <code class="directive"><a href="../mod/mod_ssl.html#sslsrpverifierfile">SSLSRPVerifierFile</a></code>. Vous pouvez crer
    le fichier de vrification via l'utilitaire <code>openssl</code> :</p>
    <div class="example"><p><code>
    openssl srp -srpvfile passwd.srpv -add username
    </code></p></div>
    <p>Une fois ce fichier cr, vous devez le rfrencer dans la
    configuration du serveur SSL :</p>
    <div class="example"><p><code>
    SSLSRPVerifierFile /path/to/passwd.srpv
    </code></p></div>
    <p>Pour forcer les clients  utiliser des algorithmes de chiffrement
    bass sur TLS-SRP et s'affranchissant des certificats, utilisez la
    directive suivante :</p>
    <div class="example"><p><code>
    SSLCipherSuite "!DSS:!aRSA:SRP"
    </code></p></div>


<h3><a name="javadh" id="javadh">Pourquoi des erreurs de ngociation apparaissent
avec les clients bass sur Java lorsqu'on utilise un certificat de plus
de 1024 bits ?</a></h3>
    <p>Depuis la version 2.4.7,
    <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> utilise des paramtres DH qui comportent
    des nombres premiers de plus de 1024 bits. Cependant, java 7 et ses versions
    antrieures ne supportent que les nombres premiers DH d'une longueur
    maximale de 1024 bits.</p>

    <p>Si votre client bas sur Java s'arrte avec une exception telle
    que <code>java.lang.RuntimeException: Could not generate DH
    keypair</code> et
    <code>java.security.InvalidAlgorithmParameterException: Prime size
    must be multiple of 64, and can only range from 512 to 1024
    (inclusive)</code>, et si httpd enregistre le message <code>tlsv1
    alert internal error (SSL alert number 80)</code> dans son journal
    des erreurs (avec un <code class="directive"><a href="../mod/core.html#loglevel">LogLevel</a></code>
    <code>info</code> ou suprieur), vous pouvez soit rarranger la
    liste d'algorithmes de mod_ssl via la directive <code class="directive"><a href="../mod/mod_ssl.html#sslciphersuite">SSLCipherSuite</a></code> (ventuellement en
    conjonction avec la directive <code class="directive"><a href="../mod/mod_ssl.html#sslhonorcipherorder">SSLHonorCipherOrder</a></code>), soit utiliser des
    paramtres DH personnaliss avec un nombre
    premier de 1024 bits, paramtres qui seront toujours prioritaires
    par rapport  tout autre paramtre DH par dfaut.</p>

    <p>Pour gnrer des paramtres DH personnaliss, utilisez la
    commande <code>openssl dhparam 1024</code>. Vous pouvez aussi
    utiliser les
    paramtres DH standards issus de la <a href="http://www.ietf.org/rfc/rfc2409.txt">RFC 2409</a>, section 6.2 :</p>
    <div class="example"><pre>-----BEGIN DH PARAMETERS-----
MIGHAoGBAP//////////yQ/aoiFowjTExmKLgNwc0SkCTgiKZ8x0Agu+pjsTmyJR
Sgh5jjQE3e+VGbPNOkMbMCsKbfJfFDdP4TVtbVHCReSFtXZiXn7G9ExC6aY37WsL
/1y29Aa37e44a/taiZ+lrp8kEXxLH+ZJKGZR7OZTgf//////////AgEC
-----END DH PARAMETERS-----</pre></div>
    <p>Ajoute les paramtres personnaliss incluant les lignes "BEGIN DH
    PARAMETERS" et "END DH PARAMETERS"  la fin du premier fichier de
    certificat dfini via la directive <code class="directive"><a href="../mod/mod_ssl.html#sslcertificatefile">SSLCertificateFile</a></code>.</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="support" id="support">Support de mod_ssl</a></h2>
<ul>
<li><a href="#resources">Quelles sont les sources d'informations
disponibles en cas de problme avec mod_ssl ?</a></li>
<li><a href="#contact">Qui peut-on contacter pour un support en cas de
problme avec mod_ssl ?</a></li>
<li><a href="#reportdetails">Quelles informations dois-je fournir lors
de l'criture d'un rapport de bogue ?</a></li>
<li><a href="#coredumphelp">Un vidage mmoire s'est produit,
pouvez-vous m'aider ?</a></li>
<li><a href="#backtrace">Comment puis-je obtenir une journalisation de
ce qui s'est pass, pour m'aider  trouver la raison de ce vidage
mmoire ?</a></li>
</ul>

<h3><a name="resources" id="resources">Quelles sont les sources d'informations
disponibles en cas de problme avec mod_ssl ?</a></h3>
<p>Voici les sources d'informations disponibles ; vous devez chercher
ici en cas de problme.</p>

    <dl>
    <dt>Vous trouverez des rponses dans la Foire Aux Questions du
    manuel utilisateur (ce document)</dt>
    <dd><a href="http://httpd.apache.org/docs/2.4/ssl/ssl_faq.html">
    	http://httpd.apache.org/docs/2.4/ssl/ssl_faq.html</a><br />
	Cherchez tout d'abord dans la foire aux questions
	(ce document). Si votre question est courante, on a dj d y
	rpondre de nombreuses fois, et elle fait probablement partie
	de ce document.
    </dd>
    </dl>


<h3><a name="contact" id="contact">Qui peut-on contacter pour un support en cas de
problme avec mod_ssl ?</a></h3>
 <p>Voici toutes les possibilits de support pour mod_ssl, par ordre
 de prfrence. Merci d'utiliser ces possibilits
 <em>dans cet ordre</em> - ne vous prcipitez pas sur celle qui vous
 parat la plus allchante. </p>
    <ol>
    <li><em>Envoyez un rapport de problme  la liste de diffusion de
    support des utilisateurs d'Apache httpd</em><br />
        <a href="mailto:users@httpd.apache.org">
        users@httpd.apache.org</a><br />
        C'est la deuxime manire de soumettre votre rapport de
	problme. Ici aussi, vous devez d'abord vous abonner  la
	liste, mais vous pourrez ensuite discuter facilement de votre
	problme avec l'ensemble de la communaut d'utilisateurs
	d'Apache httpd.
    </li>

    <li><em>Ecrire un rapport de problme dans la base de donnes des
    bogues</em><br />
	<a href="http://httpd.apache.org/bug_report.html">
	http://httpd.apache.org/bug_report.html</a><br />
        C'est la dernire manire de soumettre votre rapport de
	problme. Vous ne devez utiliser cette solution que si vous
	avez dj crit aux listes de diffusion, et n'avez pas trouv
	de solution. Merci de suivre les instructions de la page
	mentionne ci-dessus <em>avec soin</em>.
    </li>
    </ol>


<h3><a name="reportdetails" id="reportdetails">Quelles informations dois-je fournir lors
de l'criture d'un rapport de bogue ?</a></h3>
<p>Vous devez toujours fournir au moins les informations
suivantes :</p>

    <dl>
    <dt>Les versions d'Apache httpd et OpenSSL installes</dt>
    <dd>La version d'Apache peut tre dtermine en excutant
    <code>httpd -v</code>. La version d'OpenSSL peut tre dtermine
    en excutant <code>openssl version</code>. Si Lynx est install,
    vous pouvez aussi excuter la commande<code>lynx -mime_header
    http://localhost/ | grep Server</code> et ainsi obtenir ces
    informations en une seule fois.
    </dd>

    <dt>Les dtails de votre installation d'Apache httpd et OpenSSL</dt>
    <dd>A cet effet, vous pouvez fournir un fichier journal de votre
    session de terminal qui montre les tapes de la configuration et
    de l'installation. En cas d'impossibilit, vous devez au moins
    fournir la ligne de commande <code class="program"><a href="../programs/configure.html">configure</a></code> que
    vous avez utilise.
    </dd>

    <dt>En cas de vidage mmoire, inclure une trace de ce qui s'est
    pass</dt>
    <dd>Si votre serveur Apache httpd fait un vidage de sa
    mmoire, merci de fournir en pice jointe un fichier contenant
    une trace de la zone ddie  la pile (voir
    <a href="#backtrace">ci-dessous</a> pour des informations sur la manire
    de l'obtenir). Il est ncessaire de disposer de ces informations
    afin de pouvoir dterminer la raison de votre vidage mmoire.
    </dd>

    <dt>Une description dtaille de votre problme</dt>

    <dd>Ne riez pas, nous sommes srieux ! De nombreux rapports
    n'incluent pas de description de la vritable nature du problme.
    Sans ces informations, il est trs difficile pour quiconque de
    vous aider. Donc, et c'est votre propre intrt (vous souhaitez
    que le problme soit rsolu, n'est-ce pas ?), fournissez, s'il vous
    plait, le maximum de dtails possible. Bien entendu, vous devez
    aussi inclure tout ce qui a t dit prcdemment.
    </dd>
    </dl>


<h3><a name="coredumphelp" id="coredumphelp">Un vidage mmoire s'est produit,
pouvez-vous m'aider ?</a></h3>
<p>En gnral non, du moins tant que vous n'aurez pas fourni plus de
dtails  propos de la localisation dans le code o Apache a effectu
son vidage mmoire. Ce dont nous avons en gnral besoin pour vous
aider est une trace de ce qui s'est pass (voir la question suivante).
Sans cette information, il est pratiquement impossible de dterminer
la nature du problme et de vous aider  le rsoudre.</p>


<h3><a name="backtrace" id="backtrace">Comment puis-je obtenir une journalisation de
ce qui s'est pass, pour m'aider  trouver la raison de ce vidage
mmoire ?</a></h3>
<p>Vous trouverez ci-dessous les diffrentes tapes permettant
d'obtenir une journalisation des vnements (backtrace) :</p>
    <ol>
    <li>Assurez-vous que les symboles de dbogage sont disponibles, au
    moins pour Apache. Pour cela, sur les plates-formes o GCC/GDB est
    utilis, vous devez compiler Apache+mod_ssl avec l'option
    ``<code>OPTIM="-g -ggdb3"</code>''. Sur les autres plates-formes,
    l'option ``<code>OPTIM="-g"</code>'' est un minimum.
    </li>

    <li>Dmarrez le serveur et essayez de reproduire le vidage mmoire.
    A cet effet, vous pouvez utiliser une directive du style
    ``<code>CoreDumpDirectory /tmp</code>'' pour tre sr que le
    fichier de vidage mmoire puisse bien tre crit. Vous devriez
    obtenir un fichier <code>/tmp/core</code> ou
    <code>/tmp/httpd.core</code>. Si ce n'est pas le cas, essayez de
    lancer votre serveur sous un UID autre que root.
    Pour des raisons de scurit, de nombreux
    noyaux modernes de permettent pas  un processus de vider sa
    mmoire une fois qu'il a accompli un <code>setuid()</code> ( moins
    qu'il effectue un <code>exec()</code>) car des informations d'un
    niveau privilgi pourraient tre transmises en mmoire. Si
    ncessaire, vous pouvez excuter <code>/chemin/vers/httpd -X</code>
    manuellement afin de ne pas permettre  Apache de se clner (fork).
    </li>

    <li>Analysez le vidage mmoire. Pour cela, excutez
    <code>gdb /path/to/httpd /tmp/httpd.core</code> ou une commande
    similaire. Dans GDB, tout ce que vous avez  faire est d'entrer
    <code>bt</code>, et voila, vous obtenez la backtrace. Pour les
    dbogueurs autres que GDB consulter le manuel correspondant.
    </li>
    </ol>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_faq.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_faq.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/ssl/ssl_faq.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>