<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Glossaire - Serveur HTTP Apache Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page" class="no-sidebar"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Glossaire</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./de/glossary.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/glossary.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/glossary.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/glossary.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/glossary.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/glossary.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/glossary.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Ce glossaire dfinit la terminologie courante relative  Apache en
    particulier, et aux serveurs web en gnral. Vous trouverez plus
    d'informations sur chaque concept dans les liens fournis.</p>
  </div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="definitions" id="definitions">Dfinitions</a></h2>
<dl>
<dt><a name="algorithm" id="algorithm">Algorithme</a></dt>

    <dd>Une formule sans ambiguit ou un jeu de rgles destines 
    rsoudre un problme en un nombre fini d'tapes. Les algorithmes de
    chiffrement sont en gnral appels
      <dfn>Ciphers</dfn>.
    </dd>

    <dt><a name="cipher" id="cipher">Algorithme de chiffrement
    (Cipher)</a></dt>
    <dd>Un algorithme ou un systme de chiffrement des donnes.
    Quelques exemples : DES, IDEA, RC4, etc.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="apr" id="APR">APR</a></dt>
    <dd>Voir "Bibliothques pour la portabilit d'Apache"
    </dd>

    <dt><a name="tarball" id="tarball">Archive Tar (Tarball)</a></dt>
  <dd>Un paquetage de fichiers rassembls dans une archive
   l'aide de l'utilitaire <code>tar</code>.
    Les distributions d'Apache sont stockes dans des Archives Tar compresses
    ou en utilisant pkzip.
  </dd>

    <dt><a name="authentication" id="authentication">Authentification </a></dt>
    <dd>L'identification formelle d'une entit du rseau comme un serveur, un
    client, ou un utilisateur.<br />
      Voir : <a href="howto/auth.html">Authentification, Autorisation, et
      contrle d'accs</a>
    </dd>

    <dt><a name="certificationauthority" id="certificationauthority">Autorit de Certification
	(Certification Authority)</a>
      <a name="ca" id="ca">(CA)</a></dt>
    <dd>Un tiers de confiance habilit  signer des certificats pour des entits
    du rseau qu'il a authentifies selon des critres bass sur la scurit.
    Les autres entits du rseau peuvent alors utiliser la signature pour
    vrifier qu'une CA a authentifi le porteur du certificat.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="apacheportableruntime" id="apacheportableruntime">Bibliothques pour la portabilit d'Apache
       (Apache Portable Runtime)</a> <a name="apr" id="apr">(APR)</a></dt>
    <dd>Un jeu de bibliothques qui fournit la plupart des interfaces de base
      entre le serveur et le systme d'exploitation.  APR est dvelopp
      paralllement au serveur HTTP Apache comme projet indpendant.<br />
      Voir : <a href="http://apr.apache.org/">Apache Portable Runtime
      Project</a>
    </dd>


<dt><a name="certificate" id="certificate">Certificat (Certificate)</a></dt>
    <dd>Un ensemble de donnes servant  authentifier des entits du
    rseau comme un serveur ou un client. Un certificat contient des ensembles
    d'informations X509  propos de son propritaire (appel sujet/subject)
    et de l'<a class="glossarylink" href="./glossary.html#certificationauthority" title="voir glossaire">Autorit de Certification
      (Certification Authority) ou CA</a> signataire (appele
      le fournisseur/issuer), ainsi que la
      <a class="glossarylink" href="./glossary.html#publickey" title="voir glossaire">cl publique (public
      key)</a> du propritaire et la
      signature de la CA. Les entits du rseau vrifient ces signatures
      en utilisant les certificats des Autorits de Certification.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="publickeycryptography" id="publickeycryptography">Chiffrement  Cl Publique
      (Public Key Cryptography)</a></dt>
    <dd>L'tude et l'application des systmes de chiffrement asymtriques,
    qui utilisent une cl pour le chiffrement et une autre pour le
    dchiffrement. Les deux cls correspondantes constituent une paire de cls.
    Appel aussi chiffrement asymtrique.
      <br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="privatekey" id="privatekey">Cl Prive (Private Key)</a></dt>
    <dd>La cl secrte dans un systme de
    <a class="glossarylink" href="./glossary.html#publickeycryptography" title="voir glossaire">chiffrement  cl publique</a>,
    utilise pour dchiffrer les messages entrants et signer
    les messages sortants.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="publickey" id="publickey">Cl Publique (Public Key)</a></dt>
    <dd>La cl accessible au public dans un systme de <a class="glossarylink" href="./glossary.html#publickeycryptography" title="voir glossaire">Chiffrement  cl publique</a>,
      utilise pour chiffrer les messages destins uniquement  son
      propritaire et dchiffrer les signatures
      faites par son propritaire.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="connect" id="connect">CONNECT</a></dt>
    <dd>Une <a class="glossarylink" href="./glossary.html#method" title="voir glossaire">mthode</a> HTTP pour encapsuler
    des donnes brutes dans HTTP. Elle peut aussi tre utilise pour encapsuler
    d'autres protocoles, comme le protocole SSL.
    </dd>

    <dt><a name="context" id="context">Contexte (Context)</a></dt>
    <dd>Une portion des <a class="glossarylink" href="./glossary.html#configurationfile" title="voir glossaire">
    fichiers de configuration</a> dans laquelle certains types de
    <a class="glossarylink" href="./glossary.html#directive" title="voir glossaire">directives</a> sont autoriss.<br />
      Voir : <a href="mod/directive-dict.html#Context">Termes utiliss
      pour dcrire les directives d'Apache</a>
    </dd>

    <dt><a name="accesscontrol" id="accesscontrol">Contrle d'accs
    (Access Control)</a></dt>
    <dd>La restriction d'accs  des zones du rseau. Habituellement
    dans un contexte Apache,
      la restriction d'accs  certaines <em>URLs</em>.<br />
      Voir :  <a href="howto/auth.html">Authentification, Autorisation et
      Contrle d'accs</a>
    </dd>

    <dt><a name="securesocketslayer" id="securesocketslayer">
    Couche des Points de connexion Scuriss
    (Secure Sockets Layer)
      </a> <a name="ssl" id="ssl">(SSL)</a></dt>
  <dd>Un protocole cr par Netscape Communications Corporation pour
  l'authentification et le chiffrement gnraux des communications dans les
  rseaux TCP/IP.  L'utilisation la plus connue est <em>HTTPS</em>, autrement dit
  le Protocole de Transfert Hypertexte (HTTP) au dessus de SSL.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>

  <dt><a name="subrequest" id="subrequest">Sous-requte</a></dt>
    <dd>Apache possde une API des sous-requtes pour les modules qui
    permettent l'valuation complte ou partielle par le serveur de
    chemins d'autres systmes de fichiers ou d'URL. Par exemple, la
    directive <code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>,
    les modules <code class="module"><a href="./mod/mod_autoindex.html">mod_autoindex</a></code> et
    <code class="module"><a href="./mod/mod_include.html">mod_include</a></code> utilisent cette API.
    </dd>

  <dt><a name="symmetriccryptophraphy" id="symmetriccryptophraphy">
  Cryptographie Symtrique (Symmetric Cryptography)</a></dt>
  <dd>L'tude et l'application des <em>Algorithmes de chiffrement</em> qui
  utilisent une cl secrte unique pour les oprations de chiffrement et de
  dchiffrement.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>


    <dt><a name="export-crippled" id="export-crippled">
    Dgrad pour l'exportation
    (Export-Crippled)</a></dt>
    <dd>Diminu en terme de puissance cryptographique (et de scurit)
    afin de respecter les Rgles de l'Administration des Exportations
     des Etats-Unis (Export Administration Regulations ou EAR).
      Les logiciels de cryptographie dgrads pour l'exportation sont limits
       une cl de petite taille, et produisent un
      <em>Texte crypt</em> qui peut en gnral tre dcrypt
      par force brute.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>


    <dt><a name="certificatsigningrequest" id="certificatsigningrequest">Demande de signature de certificat
      (Certificate Signing Request)</a>
      <a name="csr" id="csr">(CSR)</a></dt>
    <dd>La soumission d'un <a class="glossarylink" href="./glossary.html#certificate" title="voir glossaire">certificat</a>
    non sign  une <a class="glossarylink" href="./glossary.html#certificationauthority" title="voir glossaire">Autorit de
    certification</a>, qui le signe avec la <a class="glossarylink" href="./glossary.html#privatekey" title="voir glossaire">Cl prive</a> de leur
      <em>Certificat</em> de CA. Une fois le CSR sign, il devient un vrai
      certificat.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="directive" id="directive">Directive</a></dt>
    <dd>Une commande de configuration qui contrle un ou plusieurs aspects du
    comportement d'Apache.  Les directives sont places dans le <a class="glossarylink" href="./glossary.html#configurationfile" title="voir glossaire">Fichier de configuration</a><br />
    Voir : <a href="mod/directives.html">Index des directives</a>
    </dd>

<dt><a name="configurationdirective" id="configurationdirective">Directive de configuration
	(Configuration Directive)</a></dt>
    <dd>Voir : <a class="glossarylink" href="./glossary.html#directive" title="voir glossaire">Directive</a></dd>

    <dt><a name="header" id="header">En-tte (Header)</a></dt>
    <dd>La partie de la requte et de la rponse
    <a class="glossarylink" href="./glossary.html#http" title="voir glossaire">HTTP</a> qui est envoye avant le contenu
    proprement dit, et contient des mta-informations dcrivant le contenu.
    </dd>

    <dt><a name="regularexpression" id="regularexpression">Expression Rationnelle
    (Regular Expression)</a>
      <a name="regex" id="regex">(Regex)</a></dt>
    <dd>Une mthode pour dcrire un modle sous forme de texte - par exemple,
    "tous les mots qui commencent par la lettre A" ou "tous les numros de
    tlphone  10 chiffres" ou encore "Toutes les phrases contenant 2 virgules,
    et aucun Q majuscule". Les expressions rationnelles sont trs utiles dans
    Apache car elles vous permettent d'appliquer certains attributs  des
    ensembles de fichiers ou ressources avec une grande flexibilit
      - par exemple, tous les fichiers .gif et .jpg situs dans tout rpertoire
      nomm "images", pourraient tre enregistrs comme
      "<code>/images/.*(jpg|gif)$</code>".  Lorsque l'on utilise des
      expressions rationnelles pour la substitution de chanes, les
      variables spciales $1 ... $9 contiennent des rfrences arrires
      vers les parties regroupes (entre parenthses) de l'expression
      qui correspond. La variable spciale $0 contient une rfrence
      arrire vers l'ensemble de l'expression qui correspond. Pour
      insrer un caractre littral "dollar" dans la chane de
      remplacement, il faut l'chapper avec un anti-slash. Pour des
      raisons historiques, la variable &amp; peut tre utilise en tant
      qu'alias de $0 dans certains cas, mais ceci n'est plus possible
      depuis la version 2.3.6. Apache utilise les Expressions
      Rationnelles Compatibles avec Perl fournies par la librairie <a href="http://www.pcre.org/">PCRE</a>. Vous trouverez plus
      d'information  propos de la syntaxe des expressions rationnelles
      PCRE sur ce site, ou dans le <a href="http://en.wikipedia.org/wiki/PCRE">Wikipedia de la PCRE</a>.
  </dd>

    <dt><a name="configurationfile" id="configurationfile">
    Fichier de configuration
    (Configuration File)</a></dt>
    <dd>Un fichier texte contenant des
    <a class="glossarylink" href="./glossary.html#directive" title="voir glossaire">Directives</a>
      qui contrlent la configuration d'Apache.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

    <dt><a name="filter" id="filter">Filtre (Filter)</a></dt>
    <dd>Un traitement appliqu aux donnes envoyes ou reues par le serveur.
      Les filtres en entre traitent les donnes envoyes au serveur par le
      client, alors que les filtres en sortie traitent les documents sur le
      serveur avant qu'ils soient envoys au client.
      Par exemple, le filtre en sortie
      <code>INCLUDES</code>
      traite les documents pour les
      <a class="glossarylink" href="./glossary.html#ssi" title="voir glossaire">Server Side Includes (Inclusions ct Serveur)
      </a>.<br />
      Voir : <a href="filter.html">Filtres</a>
    </dd>

<dt><a name="handler" id="handler">Gestionnaire (Handler)</a></dt>
    <dd>Une reprsentation interne  Apache de l'action  entreprendre
    quand un fichier est appel. En gnral, les fichiers ont des gestionnaires
    implicites, bass sur le type de fichier. Normalement, tous les
    fichiers sont directement servis par le serveur, mais certains
    types de fichiers sont "grs" sparment.  Par exemple, le gestionnaire
      <code>cgi-script</code> dsigne les fichiers qui doivent tre traits
      comme <a class="glossarylink" href="./glossary.html#cgi" title="voir glossaire">CGIs</a>.<br />
      Voir : <a href="handler.html">Utilisation des gestionnaires d'Apache</a>
    </dd>

    <dt><a name="hash" id="hash">Hachage (Hash)</a></dt>
    <dd>Un algorithme mathmatique  sens unique, irrversible, gnrant une
    chane de longueur fixe  partir d'une autre chane de longueur quelconque.
    Des chanes diffrentes en entre vont normalement produire des chanes
    diffrentes en sortie (selon la fonction de hachage).
    </dd>

    <dt><a name="virtualhosting" id="virtualhosting">Hbergement Virtuel
    (Virtual Hosting)</a></dt>
  <dd>Servir des sites web multiples en utilisant une seule instance d'Apache.
  Les <em>Htes virtuels bass sur IP</em> diffrencient les sites web en se
  basant sur leur adresse IP, alors que les
  <em>Htes virtuels bass sur le nom</em> utilisent uniquement le nom d'hte
  et peuvent en consquence hberger de nombreux sites avec la mme
  adresse IP.<br />
    Voir la <a href="vhosts/">Documentation des Htes Virtuels d'Apache</a>
  </dd>


    <dt><a name="htaccess" id="htaccess">.htaccess</a></dt>
    <dd>Un <a class="glossarylink" href="./glossary.html#configurationfile" title="voir glossaire">fichier de configuration</a>
    plac  un certain niveau de l'arborescence du site web, et appliquant des
    <a class="glossarylink" href="./glossary.html#directive" title="voir glossaire">directives</a> de configuration au
    rpertoire dans lequel il est plac, ainsi qu' tous ses sous-rpertoires.
    En dpit de son nom, ce fichier peut contenir pratiquement tout type de
    directive, et pas seulement des directives de contrle d'accs.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

<dt><a name="httpd.conf" id="httpd.conf">httpd.conf</a></dt>
    <dd>Le <a class="glossarylink" href="./glossary.html#configurationfile" title="voir glossaire">fichier de configuration
    </a> principal d'Apache.  Sa localisation par dfaut est
      <code>/usr/local/apache2/conf/httpd.conf</code>, mais ceci peut tre
      chang en utilisant des options de compilation ou d'excution.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

     <dt><a name="https" id="https">HTTPS</a></dt>
    <dd>Le Protocole de Transfert Hypertexte (Scuris), le mcanisme de
    communication crypte standard sur le World Wide Web.
    Il s'agit en fait de HTTP au dessus de
    <a class="glossarylink" href="./glossary.html#ssl" title="voir glossaire">SSL</a>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="uniformresourceidentifier" id="uniformresourceidentifier">Identificateur de Ressource Uniformis
    (Uniform Resource Identifier)</a>
    <a name="URI" id="URI">(URI)</a></dt>
  <dd>Une chane de caractres compacte servant  identifier une ressource
  abstraite ou physique.  Elle est formellement dfinie par la <a href="http://www.ietf.org/rfc/rfc2396.txt">RFC 2396</a>.  Les URIs
      utilises sur le world-wide web sont souvent appeles <a class="glossarylink" href="./glossary.html#url" title="voir glossaire">URLs</a>.
  </dd>

    <dt><a name="serversideincludes" id="serversideincludes">
    Inclusions Ct Serveur
    (Server Side Includes)</a> <a name="ssi" id="ssi">(SSI)
      </a></dt>
  <dd>Une technique permettant d'englober des directives de traitement dans
  des fichiers HTML.<br />
    Voir : <a href="howto/ssi.html">Introduction aux Inclusions Ct Serveur</a>
  </dd>

  <dt><a name="servernameindication" id="servernameindication">Indication du nom du serveur</a> <a name="sni" id="sni">(SNI)</a></dt>
    <dd>Une fonctionnalit SSL permettant de spcifier le
    nom du serveur dsir dans le message initial de la
    ngociation SSL, de faon  ce que le serveur web
    puisse choisir la bonne configuration de serveur virtuel 
    utiliser pendant le droulement de la ngociation SSL.
    Cette fonctionnalit a t ajoute
     SSL lorsque sont apparues les extensions TLS, RFC 3546.<br />
      Voir <a href="ssl/ssl_faq.html">la FAQ SSL</a>
      et <a href="http://www.ietf.org/rfc/rfc3546.txt">la RFC 3546</a>
    </dd>



<dt><a name="commongatewayinterface" id="commongatewayinterface">
Interface commune avec les programmes externes
(Common Gateway Interface)</a>
	 <a name="cgi" id="cgi">(CGI)</a></dt>
    <dd>La dfinition standard d'une interface entre un serveur web et un
    programme externe pour permettre  ce dernier de traiter des requtes.
     Il existe une <a href="http://www.ietf.org/rfc/rfc3875">RFC
     informationnelle</a> qui en couvre les spcificits.<br />
      Voir : <a href="howto/cgi.html">Contenu dynamique avec CGI</a>
    </dd>



<dt><a name="uniformresourcelocator" id="uniformresourcelocator">
Localisation de Ressource Uniformise
(Uniform Resource Locator)
      </a> <a name="url" id="url">(URL)</a></dt>
  <dd>Le nom/adresse d'une ressource sur l'Internet.  Il s'agit du terme
  informel commun pour ce qui est formellement dfini comme <a class="glossarylink" href="./glossary.html#uniformresourceidentifier" title="voir glossaire">
      Identificateur de Ressource Uniformis</a>.
    Les URLs sont gnralement construites selon un schma, comme
    <code>http</code> ou
    <code>https</code>, un nom d'hte, et un chemin.  Une URL pour cette page
    pourrait tre
    <code>http://httpd.apache.org/docs/2.4/glossary.html</code>.
  </dd>


    <dt><a name="proxy" id="proxy">Mandataire (Proxy)</a></dt>
    <dd>Un serveur intermdiaire qui se situe entre le client et le
    <em>serveur d'origine</em>.
    Il prend en compte les requtes des clients, les transmet au serveur
    d'origine, puis renvoie la rponse du serveur d'origine au client.
    Si plusieurs clients demandent le mme contenu, le mandataire peut l'extraire
    de son cache, plutt que le demander au serveur d'origine
     chaque fois, ce qui rduit le temps de rponse.<br />
      Voir : <a href="mod/mod_proxy.html">mod_proxy</a>
    </dd>

    <dt><a name="reverseproxy" id="reverseproxy">Mandataire inverse
    (Reverse Proxy)</a></dt>
  <dd>Un serveur <a class="glossarylink" href="./glossary.html#proxy" title="voir glossaire">mandataire</a> qui est vu du client
    comme un <em>serveur d'origine</em>.  Ceci peut s'avrer utile pour
    dissimuler le serveur d'origine rel au client pour des raisons de scurit,
    ou pour rpartir la charge.
  </dd>

    <dt><a name="method" id="method">Mthode (Method)</a></dt>
    <dd>Dans le contexte <a class="glossarylink" href="./glossary.html#http" title="voir glossaire">HTTP</a>, une action 
      effectuer sur une ressource spcifie dans la ligne de requte
      par le client.  Parmi les mthodes disponibles dans HTTP, on trouve
      <code>GET</code>, <code>POST</code>,
      et <code>PUT</code>.
    </dd>

    <dt><a name="module" id="module">Module</a></dt>
    <dd>Une partie indpendante d'un programme.  De nombreuses fonctionnalits
    d'Apache sont fournies par des modules que vous pouvez choisir d'inclure
    ou d'exclure.  Les modules qui sont compils dans le binaire
    <code class="program"><a href="./programs/httpd.html">httpd</a></code> sont appels <dfn>modules statiques</dfn>, alors
    que les modules qui existent sparment et peuvent tre chargs
    optionnellement  l'excution sont appels
      <dfn>modules dynamiques</dfn> ou <a class="glossarylink" href="./glossary.html#dso" title="voir glossaire">DSOs</a>.
      Les modules qui sont inclus par dfaut sont appels
      <dfn>modules de base</dfn>. De nombreux modules disponibles pour Apache
      ne se trouvent pas dans l'<a class="glossarylink" href="./glossary.html#tarball" title="voir glossaire">archive</a>
      du Serveur HTTP Apache .  Il sont appels
      <dfn>modules tiers</dfn>.<br />
      Voir : <a href="mod/">Index des modules</a>
    </dd>

<dt><a name="passphrase" id="passphrase">Mot de Passe (Pass Phrase)</a></dt>
    <dd>Le mot ou la phrase qui protge les fichiers de cls prives.
    Il empche les utilisateurs non autoriss de les dchiffrer. En gnral,
    il s'agit simplement de la cl secrte de chiffrement/dchiffrement
      utilise pour les <a class="glossarylink" href="./glossary.html#cipher" title="voir glossaire">Algorithmes de chiffrement</a>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="fully-qualifieddomain-name" id="fully-qualifieddomain-name">Nom de domaine entirement qualifi
	(Fully-Qualified Domain-Name)</a>
      <a name="fqdn" id="fqdn">(FQDN)</a></dt>
    <dd>Le nom unique d'une entit du rseau, comprenant un nom d'hte et un
    nom de domaine qui peuvent tre rsolus en une adresse IP. Par exemple,
      <code>www</code> est un nom d'hte, <code>example.com</code> est un nom
      de domaine, et <code>www.example.com</code> est un nom de domaine
      entirement qualifi.
    </dd>

    <dt><a name="modulemagicnumber" id="modulemagicnumber">
    Nombre Magique des Modules
    (Module Magic Number)</a>
      (<a name="mmn" id="mmn">MMN</a>)</dt>
    <dd>Le Nombre Magique des Modules est une constante dfinie dans le code
    source d'Apache et associe  la compatibilit binaire des modules.
    Sa valeur est modifie quand des structures internes d'Apache, des appels
    de fonctions et d'autres parties significatives de l'API sont modifies
    de telle faon que la compatibilit binaire ne peut plus tre garantie.
    En cas de changement de MMN, tous les modules tiers doivent tre au
    moins recompils, et parfois mme lgrement modifis afin de pouvoir
    fonctionner avec la nouvelle version d'Apache.
    </dd>

    <dt><a name="dynamicsharedobject" id="dynamicsharedobject">
    Objet Dynamique Partag (Dynamic Shared Object)
	</a> <a name="dso" id="dso">(DSO)</a></dt>
    <dd><a class="glossarylink" href="./glossary.html#module" title="voir glossaire">Modules</a> compils en dehors du binaire
      Apache <code class="program"><a href="./programs/httpd.html">httpd</a></code> et qui peuvent tre
      chargs  la demande.<br />
      Voir : <a href="dso.html">Support des objets dynamiques partags</a>
    </dd>

<dt><a name="openssl" id="openssl">OpenSSL</a></dt>
    <dd>L'ensemble d'outils Open Source pour SSL/TLS<br />
      Voir <a href="http://www.openssl.org/">http://www.openssl.org/</a>#
    </dd>

<dt><a name="apacheextensiontool" id="apacheextensiontool">
    Outil de gestion des extensions Apache
    (APache eXtension Tool)</a>
    <a name="apxs" id="apxs">(apxs)</a></dt>
    <dd>Un script Perl qui aide  la compilation des sources de <a class="glossarylink" href="./glossary.html#module" title="voir glossaire">module</a> sous forme d'Objets Dynamiques Partags
      (Dynamic Shared Objects ou
      <a class="glossarylink" href="./glossary.html#dso" title="voir glossaire">DSO</a>s) et facilite leur installation
      dans le serveur Web Apache.<br />
      Voir : Page de manuel : <code class="program"><a href="./programs/apxs.html">apxs</a></code>
    </dd>

<dt><a name="plaintext" id="plaintext">Plein Texte (Plaintext)</a></dt>
    <dd>Le texte non chiffr.</dd>



    <dt><a name="hypertexttransferprotocol" id="hypertexttransferprotocol">Protocole de Transfert Hypertexte
      (HyperText Transfer Protocol)</a>
      <a name="http" id="hhtp">(HTTP)</a></dt>
    <dd>Le protocole de transmission standard utilis sur le World Wide Web.
    Apache implmente la version 1.1 du protocole, rfrence comme HTTP/1.1 et
      dfinie par la
      <a href="http://ietf.org/rfc/rfc2616.txt">RFC 2616</a>.
    </dd>

    <dt><a name="messagedigest" id="messagedigest">Rsum de message
    (Message Digest)</a></dt>
    <dd>Un hachage du message, qui peut tre utilis pour vrifier
    que son contenu n'a pas t altr durant le transfert.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="transportlayersecurity" id="transportlayersecurity">
    Scurit de la couche Transport
    (Transport Layer Security)
      </a> <a name="tls" id="tls">(TLS)</a></dt>
  <dd>Le protocole successeur de SSL, cr par l'Internet Engineering Task
    Force (IETF) pour l'authentification et le chiffrement gnraux des
    communications dans les rseaux TCP/IP. TLS version 1 est pratiquement
    identique  SSL version 3.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>

    <dt><a name="session" id="session">Session</a></dt>
  <dd>Les informations sur le contexte d'une communication en gnral.</dd>

    <dt><a name="digitalsignature" id="digitalsignature">Signature numrique
    (Digital Signature)</a></dt>
    <dd>Un bloc de texte crypt qui valide un certificat ou un autre fichier.
    Une <a class="glossarylink" href="./glossary.html#certificationauthority" title="voir glossaire">Autorit de certification</a>
      cre une signature en gnrant une empreinte de la <em>Cl publique</em>
      fournie avec le <em>Certificat</em>; la CA chiffre ensuite l'empreinte
      avec sa propre <em>Cl prive</em>. Seule la cl publique de la CA
      peut dcrypter la signature, ce qui permet de vrifier que la CA a bien
      authentifi l'entit du rseau qui possde le
      <em>Certificat</em>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="ssleay" id="ssleay">SSLeay</a></dt>
  <dd>La bibliothque originelle d'implmentation de SSL/TLS dveloppe par
  Eric A. Young
  </dd>

<dt><a name="ciphertext" id="ciphertext">Texte crypt
(Ciphertext)</a></dt>
    <dd>Le rsultat du passage d'un document
    <a class="glossarylink" href="./glossary.html#plaintext" title="voir glossaire">Plaintext</a> (Plein texte) par un
    <a class="glossarylink" href="./glossary.html#cipher" title="voir glossaire">Cipher</a>.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="mime-type" id="mime-type">Type MIME (MIME-type)</a></dt>
    <dd>Une mthode pour dcrire le type de document transmis.  Son nom
    vient du fait que son format est issu des Multipurpose
      Internet Mail Extensions (Extensions Multi-usages de la
      Messagerie par Internet) .  Il comprend un type majeur et un type
      mineur, spars par un slash (barre oblique).  On trouve
      entre autres types <code>text/html</code>,
      <code>image/gif</code>, et <code>application/octet-stream</code>. Dans
      HTTP, le type MIME est transmis dans l'
      <a class="glossarylink" href="./glossary.html#header" title="voir glossaire">en-tte</a> <code>Content-Type</code>.<br />
      Voir : <a href="mod/mod_mime.html">mod_mime</a>
    </dd>


    <dt><a name="environmentvariable" id="environmentvariable">
    Variable d'environnement
    (Environment Variable)</a> <a name="env-variable" id="env-variable">(env-variable)</a></dt>
    <dd>Ce sont des variables nommes gres par le shell du systme
    d'exploitation, et servant au stockage d'informations et  la
    communication entre les programmes. Apache possde aussi des variables
    internes considres comme variables d'environnement, mais stockes dans
    des structures internes  Apache, et non dans l'environnement
    du shell.<br />
      Voir : <a href="env.html">Les variables d'environnement dans Apache</a>
    </dd>

     <dt><a name="x.509" id="x.509">X.509</a></dt>
  <dd>Une norme de certificat d'authentification recommande par l'International
    Telecommunication Union (ITU-T) et utilise pour
    l'authentification SSL/TLS.<br /> Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>
</dl>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./de/glossary.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/glossary.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/glossary.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/glossary.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/glossary.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/glossary.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/glossary.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/glossary.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>